/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.freemarker.FtlFileIndex;
import com.intellij.freemarker.FtlReferenceContributor;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlLanguage;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.files.FtlGlobalVariableProvider;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlFile
extends PsiFileBase {
    private static final Key<FtlFile> FOR_FILE = Key.create((String)"FOR_FILE");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.freemarker.psi.files.FtlFile");
    @NonNls
    public static final Pattern VAR_DECL_PATTERN = Pattern.compile(".#-- @ftlvariable name=\"(.*)\"[ \n\t]+type=\"([^\"]*)\"([ \n\t]+file=\"(.*)\")?([ \n\t]*)--.");
    private final CachedValue<Map<FtlFile, Map<String, FtlImplicitVariable>>> myTopLevelVars = CachedValuesManager.getManager((Project)this.getManager().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<FtlFile, Map<String, FtlImplicitVariable>>>(){

        public CachedValueProvider.Result<Map<FtlFile, Map<String, FtlImplicitVariable>>> compute() {
            return CachedValueProvider.Result.create(FtlFile.collectImplicitVariables((PsiElement)FtlFile.this.getContainingFile()), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }
    }, false);
    private final CachedValue<List<FtlVariable>> myGlobalVars = CachedValuesManager.getManager((Project)this.getManager().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<List<FtlVariable>>(){

        public CachedValueProvider.Result<List<FtlVariable>> compute() {
            ArrayList<? extends FtlVariable> result = new ArrayList<FtlVariable>();
            for (FtlGlobalVariableProvider provider : (FtlGlobalVariableProvider[])Extensions.getExtensions(FtlGlobalVariableProvider.EP_NAME)) {
                result.addAll(provider.getGlobalVariables(FtlFile.this));
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{FtlFile.this});
        }
    }, false);
    private PsiElement myContext;

    public FtlFile(FileViewProvider viewProvider) {
        super(viewProvider, (Language)FtlLanguage.INSTANCE);
    }

    public static Map<FtlFile, Map<String, FtlImplicitVariable>> collectImplicitVariables(PsiElement scope) {
        HashMap result = new HashMap();
        scope.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Map)result){
            final /* synthetic */ Map val$result;
            {
                this.val$result = map;
            }

            public void visitElement(PsiElement element) {
                if (element instanceof FtlSignatureDirective) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitComment(final PsiComment comment) {
                String[] varNames;
                String text = comment.getText();
                Matcher matcher = VAR_DECL_PATTERN.matcher(text);
                if (matcher.matches() && (varNames = FtlPsiUtil.splitVarNames(matcher.group(1), comment.getProject())) != null) {
                    final FtlFile scopeFile = FtlFile.getScopeFile(comment);
                    if (scopeFile == null && text.contains("file=\"")) {
                        return;
                    }
                    Map map = (Map)ContainerUtil.getOrCreate((Map)this.val$result, (Object)((Object)scopeFile), (Factory)new Factory<Map<String, FtlImplicitVariable>>(){

                        public Map<String, FtlImplicitVariable> create() {
                            return new THashMap();
                        }
                    });
                    FtlImplicitVariable var = (FtlImplicitVariable)ContainerUtil.getOrCreate((Map)map, (Object)varNames[0], (Factory)new Factory<FtlImplicitVariable>(){

                        public FtlImplicitVariable create() {
                            return new FtlImplicitVariable(comment, varNames[0], scopeFile);
                        }
                    });
                    map.put(varNames[0], var);
                    for (int i = 1; i < varNames.length; ++i) {
                        var = var.addSubVariable(varNames[i]);
                    }
                    var.addType(matcher.group(2));
                }
            }
        });
        return result;
    }

    @NotNull
    public FileType getFileType() {
        FtlFileType ftlFileType = FtlFileType.INSTANCE;
        if (ftlFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlFile", "getFileType"));
        }
        return ftlFileType;
    }

    public boolean isImplicitlyIncluded() {
        CachedValuesManager.getManager((Project)this.getProject());
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                return CachedValueProvider.Result.create((Object)FtlFile.this.calcImplicitlyIncluded(), (Object[])new Object[]{FtlFile.this});
            }
        });
    }

    private boolean calcImplicitlyIncluded() {
        String prefix;
        int length = "[#ftl]\n[#-- @implicitly included --]\n".length();
        return this.getTextLength() >= length && ("[#ftl]\n[#-- @implicitly included --]\n".equals(prefix = this.getText().substring(0, length)) || "<#ftl>\n<#-- @implicitly included -->\n".equals(prefix));
    }

    @Nullable
    private static FtlFile getScopeFile(PsiComment comment) {
        for (FileReference reference : FtlReferenceContributor.getFileReferences((PsiElement)comment)) {
            PsiFileSystemItem element = reference.resolve();
            if (!(element instanceof FtlFile)) continue;
            return (FtlFile)element;
        }
        return null;
    }

    @NonNls
    public String toString() {
        return "FtlFile:" + this.getName();
    }

    @NotNull
    public FtlXmlRootTag getRootTag() {
        FtlXmlRootTag tag = (FtlXmlRootTag)((Object)this.findChildByClass(FtlXmlRootTag.class));
        LOG.assertTrue(tag != null, (Object)"Shit happened");
        FtlXmlRootTag ftlXmlRootTag = tag;
        if (ftlXmlRootTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/files/FtlFile", "getRootTag"));
        }
        return ftlXmlRootTag;
    }

    public Collection<FtlImplicitVariable> getTopLevelFtlVariables(@Nullable FtlFile file) {
        Map map = (Map)((Map)this.myTopLevelVars.getValue()).get((Object)file);
        return map == null ? Collections.emptyList() : map.values();
    }

    public boolean processDeclarations(final @NotNull PsiScopeProcessor processor, final @NotNull ResolveState state, PsiElement lastParent, final @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/freemarker/psi/files/FtlFile", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/freemarker/psi/files/FtlFile", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/psi/files/FtlFile", "processDeclarations"));
        }
        return !Boolean.FALSE.equals(FtlFileReferenceDirective.FILE_RECURSION_GUARD.doPreventingRecursion((Object)this, false, (Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return FtlFile.this.processDeclarationsNoRecursion(processor, state, place);
            }
        }));
    }

    private boolean processDeclarationsNoRecursion(PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        FtlFile placeFile = (FtlFile)((Object)state.get(FOR_FILE));
        if (placeFile != null) {
            placeFile = (FtlFile)placeFile.getOriginalFile();
            for (FtlImplicitVariable ftlVariable : this.getTopLevelFtlVariables(placeFile)) {
                if (!ftlVariable.isForFile(placeFile) || FtlFile.processVariable(ftlVariable, processor, state, place)) continue;
                return false;
            }
            if (!this.getRootTag().processDirectiveDeclarations(processor, state, null, true)) {
                return false;
            }
        }
        for (FtlImplicitVariable ftlVariable : this.getTopLevelFtlVariables(null)) {
            if (FtlFile.processVariable(ftlVariable, processor, state, place)) continue;
            return false;
        }
        if (placeFile != null || this.isImplicitlyIncluded()) {
            return true;
        }
        for (FtlVariable variable : (List)this.myGlobalVars.getValue()) {
            if (FtlFile.processVariable(variable, processor, state, place)) continue;
            return false;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this);
        if (module == null) {
            return true;
        }
        for (FtlFile psiFile : FtlFile.getImplicitlyIncludedFiles(module)) {
            if (psiFile.processDeclarations(processor, state.put(FOR_FILE, (Object)this), null, place)) continue;
            return false;
        }
        return true;
    }

    private static boolean processVariable(FtlVariable ftlVariable, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        if (StringUtil.isEmpty((String)ftlVariable.getName())) {
            FtlType type = ftlVariable.getType();
            return type == null || type.processDeclarations(processor, place, state);
        }
        return processor.execute((PsiElement)ftlVariable, state);
    }

    public PsiElement getContext() {
        return this.myContext == null ? super.getContext() : this.myContext;
    }

    public static Collection<FtlFile> getImplicitlyIncludedFiles(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/freemarker/psi/files/FtlFile", "getImplicitlyIncludedFiles"));
        }
        final Project project = module.getProject();
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<Collection<FtlFile>>(){

            @Nullable
            public CachedValueProvider.Result<Collection<FtlFile>> compute() {
                return CachedValueProvider.Result.create(FtlFile.getImplicitlyIncludedFiles(project, GlobalSearchScope.moduleScope((Module)module)), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    public static Collection<FtlFile> getImplicitlyIncludedFiles(Project project, GlobalSearchScope filter) {
        Collection files = FileBasedIndex.getInstance().getContainingFiles(FtlFileIndex.NAME, (Object)FtlFileIndex.FtlIndexKey.IMPLICITLY_INCLUDED, filter);
        ArrayList<FtlFile> result = new ArrayList<FtlFile>(files.size());
        for (VirtualFile virtualFile : files) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (!(psiFile instanceof FtlFile)) continue;
            result.add((FtlFile)psiFile);
        }
        return result;
    }

    @Nullable
    public FtlImplicitVariable findImplicitVariable(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/freemarker/psi/files/FtlFile", "findImplicitVariable"));
        }
        return FtlFile.findImplicitVariable(comment, ContainerUtil.concat(((Map)this.myTopLevelVars.getValue()).values(), (Function)new Function<Map<String, FtlImplicitVariable>, Collection<? extends FtlImplicitVariable>>(){

            public Collection<? extends FtlImplicitVariable> fun(Map<String, FtlImplicitVariable> map) {
                return map.values();
            }
        }));
    }

    @Nullable
    private static FtlImplicitVariable findImplicitVariable(PsiComment comment, Collection<FtlImplicitVariable> variables) {
        for (FtlImplicitVariable variable : variables) {
            if (variable.getNavigationElement() != comment) continue;
            FtlImplicitVariable child = FtlFile.findImplicitVariable(comment, variable.getSubVariables());
            if (child != null) {
                return child;
            }
            return variable;
        }
        return null;
    }

    public FtlDirectiveStyle getDirectiveStyle() {
        return FtlLexer.guessDirectiveStyle(this.getText());
    }

    public void setContext(PsiElement context) {
        this.myContext = context;
    }
}

