/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.Repository;

public class RepoProject
implements Comparable<RepoProject> {
    private final String name;
    private final String path;
    private final String revision;
    private final String remote;
    private final Set<String> groups;
    private final List<CopyFile> copyfiles;
    private String url;
    private String defaultRevision;

    public RepoProject(String name, String path, String revision, String remote, String groups) {
        this.name = name;
        this.path = path != null ? path : name;
        this.revision = revision;
        this.remote = remote;
        this.groups = new HashSet<String>();
        if (groups != null && groups.length() > 0) {
            this.groups.addAll(Arrays.asList(groups.split(",")));
        }
        this.copyfiles = new ArrayList<CopyFile>();
    }

    public RepoProject setUrl(String url) {
        this.url = url;
        return this;
    }

    public RepoProject setDefaultRevision(String defaultRevision) {
        this.defaultRevision = defaultRevision;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getRevision() {
        return this.revision == null ? this.defaultRevision : this.revision;
    }

    public List<CopyFile> getCopyFiles() {
        return Collections.unmodifiableList(this.copyfiles);
    }

    public String getUrl() {
        return this.url;
    }

    public String getRemote() {
        return this.remote;
    }

    public boolean inGroup(String group) {
        return this.groups.contains(group);
    }

    public void addCopyFile(CopyFile copyfile) {
        this.copyfiles.add(copyfile);
    }

    public void addCopyFiles(Collection<CopyFile> copyfiles) {
        this.copyfiles.addAll(copyfiles);
    }

    private String getPathWithSlash() {
        if (this.path.endsWith("/")) {
            return this.path;
        }
        return this.path + "/";
    }

    public boolean isAncestorOf(RepoProject that) {
        return that.getPathWithSlash().startsWith(this.getPathWithSlash());
    }

    public boolean equals(Object o) {
        if (o instanceof RepoProject) {
            RepoProject that = (RepoProject)o;
            return this.getPathWithSlash().equals(that.getPathWithSlash());
        }
        return false;
    }

    public int hashCode() {
        return this.getPathWithSlash().hashCode();
    }

    @Override
    public int compareTo(RepoProject that) {
        return this.getPathWithSlash().compareTo(that.getPathWithSlash());
    }

    public static class CopyFile {
        final Repository repo;
        final String path;
        final String src;
        final String dest;

        public CopyFile(Repository repo, String path, String src, String dest) {
            this.repo = repo;
            this.path = path;
            this.src = src;
            this.dest = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copy() throws IOException {
            File srcFile = new File(this.repo.getWorkTree(), this.path + "/" + this.src);
            File destFile = new File(this.repo.getWorkTree(), this.dest);
            FileInputStream input = new FileInputStream(srcFile);
            try {
                FileOutputStream output = new FileOutputStream(destFile);
                try {
                    FileChannel channel = input.getChannel();
                    output.getChannel().transferFrom(channel, 0L, channel.size());
                }
                finally {
                    output.close();
                }
            }
            finally {
                input.close();
            }
        }
    }
}

