/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.WDBundle;
import java.awt.EventQueue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTransferUtil {
    private static final Logger LOG = Logger.getInstance((String)FileTransferUtil.class.getName());
    private static final int BUFFER_SIZE = 1024;

    private FileTransferUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyContent(FileObject srcFile, FileObject destFile, ExecutionContext context) throws IOException {
        OutputStream outstr = destFile.getContent().getOutputStream();
        try {
            FileTransferUtil.writeContent(srcFile, outstr, context);
        }
        finally {
            outstr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContent(FileObject file, OutputStream outstr, ExecutionContext context) throws IOException {
        LOG.assertTrue(!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode(), (Object)"No remote server interactions in dispatch thread!");
        context.setCurrentFileFraction(0.0);
        InputStream instr = file.getContent().getInputStream();
        try {
            int nread;
            long size = file.getContent().getSize();
            long read = 0L;
            boolean readMoreThanSizeWarning = false;
            boolean sizeChangedWarning = false;
            byte[] buffer = new byte[1024];
            while ((nread = instr.read(buffer)) >= 0) {
                outstr.write(buffer, 0, nread);
                if ((read += (long)nread) > size) {
                    String fileName = context.isServerSideModification() ? DeploymentPathUtils.getLocalPath(file) : context.getServer().getPresentablePath(file);
                    long newSize = file.getContent().getSize();
                    if (newSize > size && newSize > read) {
                        if (!sizeChangedWarning) {
                            context.console(WDBundle.message("warning.file.0.was.changed.on.server.while.retrying.to.copy.from.it", fileName), ConsoleViewContentType.SYSTEM_OUTPUT);
                            LOG.warn("Changed size: file '" + file.getName().getPath() + "', is read " + read + ", size " + newSize);
                            sizeChangedWarning = true;
                        }
                        size = newSize;
                    } else {
                        if (!readMoreThanSizeWarning) {
                            context.console(WDBundle.message("warning.while.copying.file.0.got.more.content.than.file.size", fileName), ConsoleViewContentType.SYSTEM_OUTPUT);
                            LOG.warn("More content than file size: file '" + file.getName().getPath() + "', is read " + read + ", size " + newSize);
                            readMoreThanSizeWarning = true;
                        }
                        size = read;
                    }
                }
                context.setCurrentFileFraction((float)read / (float)size);
            }
        }
        finally {
            instr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(FileObject file, @Nullable ProgressIndicator pi) throws IOException {
        LOG.assertTrue(!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode(), (Object)"No remote server interactions in dispatch thread!");
        if (pi == null) {
            return FileUtil.getContent((FileObject)file);
        }
        FileContent content = file.getContent();
        int size = (int)content.getSize();
        byte[] buf = new byte[size];
        InputStream in = content.getInputStream();
        try {
            int read = 0;
            for (int pos = 0; pos < size && read >= 0; pos += read) {
                read = in.read(buf, pos, size - pos);
            }
        }
        finally {
            in.close();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContent(@NotNull byte[] source, OutputStream outstr, ExecutionContext context) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/plugins/webDeployment/FileTransferUtil", "writeContent"));
        }
        LOG.assertTrue(!EventQueue.isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode(), (Object)"No remote server interactions in dispatch thread!");
        context.setCurrentFileFraction(0.0);
        ByteArrayInputStream instr = new ByteArrayInputStream(source);
        try {
            int nread;
            long size = source.length;
            long read = 0L;
            byte[] buffer = new byte[1024];
            while ((nread = instr.read(buffer)) >= 0) {
                outstr.write(buffer, 0, nread);
                context.setCurrentFileFraction((float)(read += (long)nread) / (float)size);
            }
        }
        finally {
            ((InputStream)instr).close();
        }
    }
}

