/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.roots.ToolbarPanel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.actions.ToggleRemoteExclusionAction;
import com.jetbrains.plugins.webDeployment.actions.createproject.ActionTypeDescription;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseRemotePathStep;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeContext;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeViewOptions;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.WebServerTreeBuilder;
import icons.WebDeploymentIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerTreeForm
implements Disposable {
    public static final Icon PROJECT_ICON = IconLoader.getIcon((String)ApplicationInfoEx.getInstanceEx().getSmallIconUrl());
    private JPanel myContentPane;
    private ServerTree myTree;
    private JBScrollPane myScrollPane;
    private WebServerTreeBuilder myTreeBuilder;
    private WebServerConfig myServer;
    private PublishConfig myConfig;
    private final MultiMap<String, WebServerConfig.RemotePath> myActionPaths;
    private final EventDispatcher<RootChangedListener> myEventDispatcher;

    public ServerTreeForm() {
        this.$$$setupUI$$$();
        this.myActionPaths = new MultiMap();
        this.myEventDispatcher = EventDispatcher.create(RootChangedListener.class);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction((AnAction)new SetRootFolderAction());
        actionGroup.addAction((AnAction)new ToggleRemoteExclusionAction(WebDeploymentIcons.ExcludeFromDownload));
        for (ActionTypeDescription.Remote actionTypeDescription : ChooseRemotePathStep.REMOTE_ACTION_TYPE_DESCRIPTIONS) {
            actionGroup.addAction((AnAction)new ParametrizedAction(actionTypeDescription));
        }
        this.myContentPane.add((Component)new ToolbarPanel((JComponent)this.myScrollPane, (ActionGroup)actionGroup), "Center");
    }

    private void createUIComponents() {
        this.myTree = new ServerTree(null, null, null);
        this.myTree.getSelectionModel().setSelectionMode(1);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("RemoteHostViewPopupMenu");
        for (AnAction action : group.getChildActionsOrStubs()) {
            if (action instanceof ToggleRemoteExclusionAction || action instanceof ActionStub && ToggleRemoteExclusionAction.class.getName().equals(((ActionStub)action).getClassName())) {
                actionGroup.addSeparator();
                SetRootFolderAction setRootFolderAction = new SetRootFolderAction();
                actionGroup.add((AnAction)setRootFolderAction);
                setRootFolderAction.registerCustomShortcutSet(setRootFolderAction.getShortcutSet(), (JComponent)((Object)this.myTree), this);
                ToggleRemoteExclusionAction excludeFolderAction = new ToggleRemoteExclusionAction();
                excludeFolderAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(68, 512), null)}), (JComponent)((Object)this.myTree), this);
                actionGroup.add((AnAction)excludeFolderAction);
                ParametrizedAction resourceRootAction = new ParametrizedAction(ActionTypeDescription.REMOTE_RESOURCE_ROOTS_ACTION_DESCRIPTION);
                actionGroup.add((AnAction)resourceRootAction);
                resourceRootAction.registerCustomShortcutSet(resourceRootAction.getShortcutSet(), (JComponent)((Object)this.myTree), this);
                ParametrizedAction excludeAction = new ParametrizedAction(ActionTypeDescription.REMOTE_EXCLUDE_FOLDERS_ACTION_DESCRIPTION);
                actionGroup.add((AnAction)excludeAction);
                excludeAction.registerCustomShortcutSet(excludeAction.getShortcutSet(), (JComponent)((Object)this.myTree), this);
                continue;
            }
            actionGroup.add(action);
        }
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTree), (ActionGroup)actionGroup, (String)"RemoteHostDialogPopup", (ActionManager)ActionManager.getInstance());
    }

    public void initialize(final WebServerConfig server, boolean foldersOnly, PublishConfig config, @Nullable WebServerConfig.RemotePath initialPath) {
        ServerTreeNode selection;
        this.myConfig = config;
        this.myServer = server;
        ServerTreeViewOptions options = new ServerTreeViewOptions(){

            @Override
            public boolean isShowSize() {
                return false;
            }

            @Override
            public boolean isShowTimestamp() {
                return false;
            }

            @Override
            public boolean isShowPermissions() {
                return false;
            }

            @Override
            public boolean isShowPermissionsAsNumber() {
                return false;
            }

            @Override
            public boolean isHighlightSymlinks() {
                return false;
            }

            @Override
            public boolean isHighlightMappings() {
                return true;
            }

            @Override
            public boolean isHidden(FileName name) {
                return false;
            }
        };
        DecoratedServerTreeNode root = new DecoratedServerTreeNode(null, ConnectionOwnerFactory.createConnectionOwner(this.myContentPane), server, config, foldersOnly, options);
        this.myTreeBuilder = WebServerTreeBuilder.createInstance(root, (JTree)((Object)this.myTree));
        this.myTree.setServer(server);
        this.myTree.setConfig(config);
        this.registerActionShortcut("$Delete");
        this.registerActionShortcut("$Cut");
        this.registerActionShortcut("$Paste");
        if (initialPath != null && (selection = root.createForSelection(initialPath)) != null) {
            this.myTreeBuilder.select((Object)selection);
        }
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.SERVER_TREE, (Object)new ServerTreeContentListener(){

            @Override
            public void refreshSubtree(WebServerConfig s, Collection<WebServerConfig.RemotePath> roots, boolean resync, @Nullable WebServerConfig.RemotePath selectAfterRefresh, @Nullable Object requestor) {
                if (!server.getFileTransferConfig().getRootUri().equals(s.getFileTransferConfig().getRootUri())) {
                    return;
                }
                try {
                    ServerTreeForm.this.myTreeBuilder.refreshSubtree(roots, resync, ServerTreeForm.this.myTree == requestor ? selectAfterRefresh : null);
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        });
    }

    private void registerActionShortcut(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        action.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)((Object)this.myTree), (Disposable)this);
    }

    @Nullable
    private WebServerConfig.RemotePath getSelectedPath() {
        if (this.myTreeBuilder == null) {
            return null;
        }
        Set selection = this.myTreeBuilder.getSelectedElements();
        if (selection.isEmpty()) {
            return null;
        }
        Object o = selection.iterator().next();
        return o instanceof ServerTreeNode ? ((ServerTreeNode)((Object)o)).getPath() : null;
    }

    public void dispose() {
        if (this.myTreeBuilder == null || this.myTreeBuilder.isDisposed()) {
            return;
        }
        ((ServerTreeNode)((Object)this.myTreeBuilder.getTreeStructure().getRootElement())).releaseConnectionIfOpen();
        Disposer.dispose((Disposable)this.myTreeBuilder);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private boolean isSelectionMapped(WebServerConfig.RemotePath path) {
        if (path == null || path.path == null) {
            return false;
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)this.getTempMapping().getFirst();
        if (mapping == null || StringUtil.isEmpty((String)mapping.getDeployPath())) {
            return false;
        }
        return this.myConfig.getNearestMappingDeploy2Local(path, false, this.myServer).getFirst() != null;
    }

    @Nullable
    public String getProjectRootPath() {
        if (this.myConfig == null) {
            return null;
        }
        String deployPath = ((DeploymentPathMapping)this.getTempMapping().getFirst()).getDeployPath();
        if (deployPath == null) {
            return null;
        }
        if (!this.myServer.getFileTransferConfig().getAccessType().isProtocolBased()) {
            return DeploymentPathUtils.join(this.myServer.getFileTransferConfig().getMountedFolder(), deployPath, File.separatorChar);
        }
        return deployPath;
    }

    public void addStateChangedListener(RootChangedListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public MultiMap<String, WebServerConfig.RemotePath> getActionPaths() {
        return this.myActionPaths;
    }

    public static String getMountedServerRelativePath(String path, WebServerConfig serverConfig) {
        String pathToCheck = path;
        if (!serverConfig.getFileTransferConfig().getAccessType().isProtocolBased() && "".equals(pathToCheck = DeploymentPathUtils.getPathRemainder(serverConfig.getFileTransferConfig().getMountedFolder(), path, serverConfig.isCaseSensitive()))) {
            pathToCheck = File.separator;
        }
        return pathToCheck;
    }

    @NotNull
    Pair<DeploymentPathMapping, List<DeploymentPathMapping>> getTempMapping() {
        ChooseRemotePathStep.TempDeploymentPathMapping tempMapping = null;
        List<DeploymentPathMapping> pathMappings = this.myConfig.getPathMappings(this.myServer.getId());
        for (DeploymentPathMapping mapping : pathMappings) {
            if (!(mapping instanceof ChooseRemotePathStep.TempDeploymentPathMapping)) continue;
            tempMapping = (ChooseRemotePathStep.TempDeploymentPathMapping)mapping;
        }
        assert (tempMapping != null);
        Pair pair = Pair.create(tempMapping, pathMappings);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/createproject/ServerTreeForm", "getTempMapping"));
        }
        return pair;
    }

    private void commitTempMapping(List<DeploymentPathMapping> mappings) {
        this.myConfig.setPathMappings(this.myServer.getId(), mappings);
    }

    private boolean isActionApplied(ActionTypeDescription.Remote desc, WebServerConfig.RemotePath path) {
        if (desc.isRecursive) {
            for (WebServerConfig.RemotePath remotePath : this.myActionPaths.get((Object)desc.key)) {
                if (!DeploymentPathUtils.isAncestor(remotePath.path, path.path, this.myServer.isCaseSensitive())) continue;
                return true;
            }
        } else if (this.myActionPaths.get((Object)desc.key).contains(path)) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        ServerTree serverTree = this.myTree;
        jBScrollPane.setViewportView((Component)((Object)serverTree));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface RootChangedListener
    extends EventListener {
        public void rootChanged();
    }

    private class DecoratedServerTreeNode
    extends ServerTreeNode {
        public DecoratedServerTreeNode(@NotNull Project project, ConnectionOwner connectionOwner, @Nullable WebServerConfig serverConfig, PublishConfig publishConfig, @NotNull boolean foldersOnly, ServerTreeViewOptions viewOptions) {
            if (connectionOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/actions/createproject/ServerTreeForm$DecoratedServerTreeNode", "<init>"));
            }
            if (viewOptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewOptions", "com/jetbrains/plugins/webDeployment/actions/createproject/ServerTreeForm$DecoratedServerTreeNode", "<init>"));
            }
            super(project, connectionOwner, serverConfig, publishConfig, foldersOnly, FileTransferConfig.Origin.Default, viewOptions);
        }

        private DecoratedServerTreeNode(@NotNull ServerTreeNode parent, FileObject file, @NotNull FileType fileType, ServerTreeContext treeContext) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/actions/createproject/ServerTreeForm$DecoratedServerTreeNode", "<init>"));
            }
            if (treeContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeContext", "com/jetbrains/plugins/webDeployment/actions/createproject/ServerTreeForm$DecoratedServerTreeNode", "<init>"));
            }
            super(parent, file, fileType, treeContext);
        }

        @Override
        protected void update(PresentationData presentation) {
            super.update(presentation);
            WebServerConfig.RemotePath path = this.getPath();
            String rootPath = ServerTreeForm.this.getProjectRootPath();
            if (rootPath != null && "".equals(DeploymentPathUtils.getPathRemainder(path.path, rootPath, ServerTreeForm.this.myServer.isCaseSensitive()))) {
                presentation.setIcon(PROJECT_ICON);
                return;
            }
            if (!ServerTreeForm.this.isSelectionMapped(path)) {
                return;
            }
            for (ActionTypeDescription.Remote desc : ChooseRemotePathStep.REMOTE_ACTION_TYPE_DESCRIPTIONS) {
                if (!ServerTreeForm.this.isActionApplied(desc, path)) continue;
                presentation.setIcon(desc.closedIcon);
                return;
            }
        }

        @Override
        public SimpleNode[] getChildren() {
            SimpleNode[] parentNodes = super.getChildren();
            SimpleNode[] result = new SimpleNode[parentNodes.length];
            for (int i = 0; i < parentNodes.length; ++i) {
                SimpleNode parentNode = parentNodes[i];
                if (parentNode instanceof ServerTreeNode) {
                    ServerTreeNode node = (ServerTreeNode)parentNode;
                    result[i] = new DecoratedServerTreeNode(this, node.getFileObject(), node.getFileType(), node.getTreeContext());
                    continue;
                }
                result[i] = parentNode;
            }
            return result;
        }
    }

    private class ParametrizedAction
    extends ToggleAction {
        private final ActionTypeDescription.Remote myDescription;

        private ParametrizedAction(ActionTypeDescription.Remote description) {
            super(description.title, description.description, description.closedIcon);
            this.myDescription = description;
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(description.keystroke, 512), null)}));
        }

        public void update(AnActionEvent e) {
            super.update(e);
            boolean underRoot = ServerTreeForm.this.isSelectionMapped(ServerTreeForm.this.getSelectedPath());
            e.getPresentation().setEnabled(underRoot);
        }

        public boolean isSelected(AnActionEvent e) {
            WebServerConfig.RemotePath path = ServerTreeForm.this.getSelectedPath();
            if (!ServerTreeForm.this.isSelectionMapped(ServerTreeForm.this.getSelectedPath())) {
                return false;
            }
            return ServerTreeForm.this.isActionApplied(this.myDescription, path);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ArrayList<WebServerConfig.RemotePath> selectedPaths = new ArrayList<WebServerConfig.RemotePath>();
            for (Object o : ServerTreeForm.this.myTreeBuilder.getSelectedElements()) {
                if (!(o instanceof ServerTreeNode)) continue;
                selectedPaths.add(((ServerTreeNode)((Object)o)).getPath());
            }
            if (state) {
                Collection paths = ServerTreeForm.this.myActionPaths.get((Object)this.myDescription.key);
                for (WebServerConfig.RemotePath path : selectedPaths) {
                    if (paths.contains(path)) continue;
                    ServerTreeForm.this.myActionPaths.putValue((Object)this.myDescription.key, (Object)path);
                }
            } else {
                for (WebServerConfig.RemotePath path : selectedPaths) {
                    ServerTreeForm.this.myActionPaths.remove((Object)this.myDescription.key, (Object)path);
                }
            }
            ServerTreeForm.this.myTreeBuilder.refreshSubtree(selectedPaths, false, null);
        }

        public boolean displayTextInToolbar() {
            return true;
        }
    }

    private class SetRootFolderAction
    extends ToggleAction {
        private SetRootFolderAction() {
            super(WDBundle.message("project.root.action.text", new Object[0]), WDBundle.message("project.root.action.description", new Object[0]), PROJECT_ICON);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(74, 512), null)}));
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(ServerTreeForm.this.myTreeBuilder != null && ServerTreeForm.this.myTreeBuilder.getSelectedElements().size() == 1);
        }

        public boolean isSelected(AnActionEvent e) {
            WebServerConfig.RemotePath path = ServerTreeForm.this.getSelectedPath();
            if (path == null) {
                return false;
            }
            String pathToCheck = ServerTreeForm.getMountedServerRelativePath(path.path, ServerTreeForm.this.myServer);
            DeploymentPathMapping tempMapping = (DeploymentPathMapping)ServerTreeForm.this.getTempMapping().getFirst();
            return !StringUtil.isEmpty((String)tempMapping.getDeployPath()) && "".equals(DeploymentPathUtils.getPathRemainder(tempMapping.getDeployPath(), pathToCheck, ServerTreeForm.this.myServer.isCaseSensitive()));
        }

        public void setSelected(AnActionEvent e, boolean state) {
            WebServerConfig.RemotePath path = ServerTreeForm.this.getSelectedPath();
            if (path == null) {
                return;
            }
            String pathToCheck = ServerTreeForm.getMountedServerRelativePath(path.path, ServerTreeForm.this.myServer);
            Pair<DeploymentPathMapping, List<DeploymentPathMapping>> tempMapping = ServerTreeForm.this.getTempMapping();
            if (tempMapping.getFirst() != null && "".equals(DeploymentPathUtils.getPathRemainder(((DeploymentPathMapping)tempMapping.getFirst()).getDeployPath(), pathToCheck, ServerTreeForm.this.myServer.isCaseSensitive()))) {
                if (state) {
                    return;
                }
                ((DeploymentPathMapping)tempMapping.getFirst()).setDeployPath(null);
                ServerTreeForm.this.commitTempMapping((List)tempMapping.getSecond());
                ServerTreeForm.this.myTreeBuilder.refreshSubtree(Collections.singleton(path), false, path);
                ((RootChangedListener)ServerTreeForm.this.myEventDispatcher.getMulticaster()).rootChanged();
            }
            if (state) {
                String oldPath = ((DeploymentPathMapping)tempMapping.getFirst()).getDeployPath();
                if (oldPath != null && !ServerTreeForm.this.myServer.getFileTransferConfig().getAccessType().isProtocolBased()) {
                    oldPath = DeploymentPathUtils.join(ServerTreeForm.this.myServer.getFileTransferConfig().getMountedFolder(), oldPath, File.separatorChar);
                }
                ((DeploymentPathMapping)tempMapping.getFirst()).setDeployPath(pathToCheck);
                ServerTreeForm.this.commitTempMapping((List)tempMapping.getSecond());
                ArrayList<WebServerConfig.RemotePath> pathsToRefresh = new ArrayList<WebServerConfig.RemotePath>(2);
                pathsToRefresh.add(path);
                pathsToRefresh.add(new WebServerConfig.RemotePath(oldPath));
                ServerTreeForm.this.myTreeBuilder.refreshSubtree(pathsToRefresh, false, null);
                ((RootChangedListener)ServerTreeForm.this.myEventDispatcher.getMulticaster()).rootChanged();
            }
        }

        public boolean displayTextInToolbar() {
            return true;
        }
    }
}

