/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@Tag(value="mapping")
public class DeploymentPathMapping
implements Cloneable {
    @NonNls
    public static final String MAPPING_TAG = "mapping";
    @NonNls
    public static final String DEPLOY_PATH_ATTRIBUTE = "deploy";
    @NonNls
    public static final String WEB_PATH_ATTRIBUTE = "web";
    private static final Logger LOG = Logger.getInstance((String)DeploymentPathMapping.class.getName());
    private static final String NOMACROS = "nomacros://";
    private String myLocalPath;
    private String myDeployPath;
    private String myWebPath;

    @Attribute(value="local")
    public String getSerializedLocalPath() {
        return this.myLocalPath != null ? FileUtil.toSystemIndependentName((String)this.myLocalPath) : null;
    }

    public void setSerializedLocalPath(String localPath) {
        this.setLocalPath(localPath);
    }

    @Transient
    public String getLocalPath() {
        return this.myLocalPath;
    }

    public void setLocalPath(String localPath) {
        this.myLocalPath = localPath;
    }

    public String getPresentableLocalPath() {
        return this.myLocalPath != null ? FileUtil.toSystemDependentName((String)this.myLocalPath) : null;
    }

    @Transient
    public String getDeployPath() {
        return this.myDeployPath;
    }

    public void setDeployPath(String deployPath) {
        this.myDeployPath = deployPath;
    }

    @Attribute(value="deploy")
    public String getSerializedDeployPath() {
        return this.getDeployPath();
    }

    public void setSerializedDeployPath(String deployPath) {
        if (deployPath != null) {
            deployPath = StringUtil.trimStart((String)deployPath, (String)NOMACROS);
        }
        this.setDeployPath(deployPath);
    }

    @Attribute(value="web")
    public String getWebPath() {
        return this.myWebPath;
    }

    public void setWebPath(String webPath) {
        this.myWebPath = webPath;
    }

    public boolean isDegenerate() {
        return StringUtil.isEmpty((String)this.myLocalPath) && StringUtil.isEmpty((String)this.myDeployPath) && StringUtil.isEmpty((String)this.myWebPath);
    }

    public DeploymentPathMapping clone() {
        try {
            return (DeploymentPathMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)o;
        if (!Comparing.equal((String)StringUtil.notNullize((String)this.myDeployPath), (String)StringUtil.notNullize((String)mapping.myDeployPath))) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.notNullize((String)this.myLocalPath), (String)StringUtil.notNullize((String)mapping.myLocalPath))) {
            return false;
        }
        return Comparing.equal((String)StringUtil.notNullize((String)this.myWebPath), (String)StringUtil.notNullize((String)mapping.myWebPath));
    }

    public int hashCode() {
        int result = this.myLocalPath != null ? this.myLocalPath.hashCode() : 0;
        result = 31 * result + (this.myDeployPath != null ? this.myDeployPath.hashCode() : 0);
        result = 31 * result + (this.myWebPath != null ? this.myWebPath.hashCode() : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "DeploymentPathMapping{localPath='" + this.myLocalPath + '\'' + ", deployPath='" + this.myDeployPath + '\'' + ", webPath='" + this.myWebPath + '\'' + '}';
    }

    public boolean isParentForLocalPath(String localPath, boolean strict) {
        if (!this.isLocalPathValid() || StringUtil.isEmpty((String)localPath)) {
            return false;
        }
        String remainder = this.getPathRemainderForLocal(localPath);
        return remainder != null && (!strict || remainder.length() > 0);
    }

    public boolean isChildForLocalPath(String localPath, boolean strict) {
        if (!this.isLocalPathValid()) {
            return false;
        }
        String remainder = DeploymentPathUtils.getPathRemainder(localPath, this.myLocalPath, SystemInfo.isFileSystemCaseSensitive);
        return remainder != null && (!strict || remainder.length() > 0);
    }

    @Nullable
    public String getPathRemainderForLocal(String childLocalPath) {
        return DeploymentPathUtils.getPathRemainder(this.myLocalPath, childLocalPath, SystemInfo.isFileSystemCaseSensitive);
    }

    public boolean isParentForDeployPath(FileName deployPath, boolean strict, WebServerConfig server) {
        String remainder = this.getPathRemainderForDeploy(deployPath, server);
        return remainder != null && (!strict || remainder.length() > 0);
    }

    public boolean isParentForDeployPath(WebServerConfig.RemotePath deployPath, boolean strict, WebServerConfig server) {
        String remainder = this.getPathRemainderForDeploy(deployPath, server);
        return remainder != null && (!strict || remainder.length() > 0);
    }

    public boolean isChildForDeployPath(FileName deployPath, boolean strict, WebServerConfig server) {
        String remainder;
        boolean isProtocolBased = server.getFileTransferConfig().getAccessType().isProtocolBased();
        if (!this.isDeployPathValid(isProtocolBased)) {
            return false;
        }
        if (isProtocolBased) {
            remainder = DeploymentPathUtils.getPathRemainder(deployPath.getPath(), this.myDeployPath, server.isCaseSensitive());
        } else {
            String fullDeployPath = DeploymentPathUtils.join(server.getFileTransferConfig().getMountedFolder(), this.myDeployPath);
            remainder = DeploymentPathUtils.getPathRemainder(DeploymentPathUtils.getLocalPath(deployPath), fullDeployPath, server.isCaseSensitive());
        }
        return remainder != null && (!strict || remainder.length() > 0);
    }

    @Nullable
    private String getPathRemainderForDeploy(FileName childDeployPath, WebServerConfig server) {
        return DeploymentPathMapping.getPathRemainderForRemotePath(childDeployPath, server, this.myDeployPath);
    }

    public static String getPathRemainderForRemotePath(FileName childDeployPath, WebServerConfig server, String remotePath) {
        boolean isProtocolBased = server.getFileTransferConfig().getAccessType().isProtocolBased();
        if (DeploymentPathMapping.validateDeployPath(remotePath, isProtocolBased) != null) {
            return null;
        }
        if (isProtocolBased) {
            return DeploymentPathUtils.getPathRemainder(DeploymentPathMapping.ensureRelative(remotePath), childDeployPath.getPath(), server.isCaseSensitive());
        }
        String fullDeployPath = DeploymentPathUtils.join(server.getFileTransferConfig().getMountedFolder(), remotePath);
        return DeploymentPathUtils.getPathRemainder(fullDeployPath, DeploymentPathUtils.getLocalPath(childDeployPath), server.isCaseSensitive());
    }

    @Nullable
    private String getPathRemainderForDeploy(WebServerConfig.RemotePath childDeployPath, WebServerConfig server) {
        return DeploymentPathMapping.getPathRemainderForRemotePath(childDeployPath, server, this.myDeployPath);
    }

    public static String getPathRemainderForRemotePath(WebServerConfig.RemotePath childDeployPath, WebServerConfig server, String remotePath) {
        boolean isProtocolBased = server.getFileTransferConfig().getAccessType().isProtocolBased();
        if (DeploymentPathMapping.validateDeployPath(remotePath, isProtocolBased) != null) {
            return null;
        }
        if (isProtocolBased) {
            return DeploymentPathUtils.getPathRemainder(DeploymentPathMapping.ensureRelative(remotePath), childDeployPath.path, server.isCaseSensitive());
        }
        String fullDeployPath = DeploymentPathUtils.join(server.getFileTransferConfig().getMountedFolder(), remotePath);
        return DeploymentPathUtils.getPathRemainder(fullDeployPath, childDeployPath.path, server.isCaseSensitive());
    }

    public String mapToWebPath(String localPath) {
        LOG.assertTrue(this.isWebPathValid(), (Object)("web path is invalid for " + this));
        String remainder = this.getPathRemainderForLocal(localPath);
        return DeploymentPathUtils.join(this.myWebPath, remainder);
    }

    public WebServerConfig.RemotePath mapToDeployPath(FileObject local, WebServerConfig server) {
        return this.mapToDeployPath(DeploymentPathUtils.getLocalPath(local), server);
    }

    public WebServerConfig.RemotePath mapToDeployPath(String localPath, WebServerConfig server) {
        boolean isProtocolBased = server.getFileTransferConfig().getAccessType().isProtocolBased();
        LOG.assertTrue(this.isDeployPathValid(isProtocolBased), (Object)("deploy path is invalid for " + this));
        String remainder = StringUtil.notNullize((String)this.getPathRemainderForLocal(localPath));
        if (isProtocolBased) {
            return new WebServerConfig.RemotePath(DeploymentPathUtils.join(DeploymentPathMapping.ensureRelative(this.myDeployPath), remainder));
        }
        String fullDeployPath = DeploymentPathUtils.join(server.getFileTransferConfig().getMountedFolder(), this.myDeployPath);
        String fullPath = DeploymentPathUtils.join(fullDeployPath, remainder);
        return new WebServerConfig.RemotePath(FileUtil.toSystemDependentName((String)fullPath));
    }

    public WebServerConfig.RemotePath getFullDeployPath(WebServerConfig server) {
        boolean isProtocolBased = server.getFileTransferConfig().getAccessType().isProtocolBased();
        if (isProtocolBased) {
            return new WebServerConfig.RemotePath(DeploymentPathMapping.ensureRelative(this.myDeployPath));
        }
        String path = DeploymentPathUtils.join(server.getFileTransferConfig().getMountedFolder(), this.myDeployPath);
        return new WebServerConfig.RemotePath(FileUtil.toSystemDependentName((String)path));
    }

    public String mapToLocalPath(FileObject deploy, WebServerConfig server) {
        return this.mapToLocalPath(deploy.getName(), server);
    }

    public FileObject mapToLocalFile(FileObject deploy, WebServerConfig server) throws FileSystemException {
        return DeploymentPathUtils.getLocalFile(this.mapToLocalPath(deploy, server));
    }

    public String mapToLocalPath(FileName deployedFileName, WebServerConfig server) {
        LOG.assertTrue(this.isLocalPathValid(), (Object)("local path is invalid for " + this));
        String remainder = this.getPathRemainderForDeploy(deployedFileName, server);
        if (remainder == null) {
            LOG.error("Empty remainder. Filename " + server.getPresentablePath(deployedFileName) + ", deploy path " + this.myDeployPath + ", server type " + (Object)((Object)server.getFileTransferConfig().getAccessType()));
        }
        return DeploymentPathUtils.join(this.myLocalPath, remainder);
    }

    public String mapToLocalPath(WebServerConfig.RemotePath remotePath, WebServerConfig server) {
        LOG.assertTrue(this.isLocalPathValid(), (Object)("local path is invalid for " + this));
        String remainder = this.getPathRemainderForDeploy(remotePath, server);
        return DeploymentPathUtils.join(this.myLocalPath, remainder);
    }

    public boolean isLocalPathValid() {
        return StringUtil.isNotEmpty((String)this.getLocalPath());
    }

    public boolean isWebPathValid() {
        return StringUtil.isNotEmpty((String)this.getWebPath());
    }

    public boolean isDeployPathValid(boolean isProtocolBased) {
        return DeploymentPathMapping.validateDeployPath(this.getDeployPath(), isProtocolBased) == null;
    }

    public boolean isEffectivelyEmpty(Project project) {
        String basePath;
        if (!StringUtil.isEmptyOrSpaces((String)this.getDeployPath())) {
            return false;
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.getWebPath()) && !"/".equals(this.getWebPath())) {
            return false;
        }
        return project == null || (basePath = project.getBasePath()) == null || basePath.equals(this.getLocalPath());
    }

    @Nullable
    public static String validateDeployPath(String path, boolean isProtocolBased) {
        if (StringUtil.isEmpty((String)path)) {
            return WDBundle.message("deploy.path.is.empty", "");
        }
        if (!isProtocolBased && SystemInfo.isWindows) {
            if (path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
                return WDBundle.message("deploy.path.is.not.relative", path);
            }
            if (SystemInfo.isWindows && path.startsWith("\\\\")) {
                return WDBundle.message("unc.path.not.supported", path);
            }
        }
        return null;
    }

    public boolean isParentByDeployPath(DeploymentPathMapping mapping, boolean caseSensitive) {
        return DeploymentPathUtils.getPathRemainder(this.getDeployPath(), mapping.getDeployPath(), caseSensitive) != null;
    }

    @Nullable
    public String getPathRemainderForWeb(String childWebPath) {
        if (StringUtil.isEmpty((String)childWebPath)) {
            return null;
        }
        return DeploymentPathUtils.getPathRemainder(this.myWebPath, childWebPath, false);
    }

    public boolean isParentForWebPath(String webPath, boolean strict) {
        if (!this.isWebPathValid()) {
            return false;
        }
        String remainder = this.getPathRemainderForWeb(webPath);
        return remainder != null && (!strict || remainder.length() > 0);
    }

    public boolean isParentByWebPath(DeploymentPathMapping mapping) {
        return DeploymentPathUtils.getPathRemainder(this.getWebPath(), mapping.getWebPath(), false) != null;
    }

    public String mapWebToLocalPath(String webPath) {
        LOG.assertTrue(this.isLocalPathValid(), (Object)("local path is invalid for " + this));
        String remainder = this.getPathRemainderForWeb(webPath);
        return FileUtil.toSystemDependentName((String)DeploymentPathUtils.join(this.myLocalPath, remainder));
    }

    private static String ensureRelative(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }
}

