/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.FlexibleSemaphore;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RemoteConnectionPool {
    private static final Logger LOG = Logger.getInstance((String)RemoteConnection.class.getName());
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    private static final int INITIAL_WAITING_RCONNECT_TIMEOUT_SECONDS = 3;
    private final Collection<RemoteConnection> myConnections;
    private final FlexibleSemaphore mySemaphore;
    private final WebServerConfig myServer;
    @NotNull
    private final String myTitle;
    private final FileTransferConfig.Origin myOrigin;
    @NotNull
    private final ConnectionOwner myConnectionOwner;

    public synchronized void close() {
        for (RemoteConnection connection : this.myConnections) {
            connection.release();
            connection.close();
        }
    }

    RemoteConnectionPool(@NotNull WebServerConfig server, @NotNull ConnectionOwner connectionOwner, @NotNull String title, FileTransferConfig.Origin origin) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool", "<init>"));
        }
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool", "<init>"));
        }
        this.myConnections = new ArrayList<RemoteConnection>();
        this.myServer = server.clone();
        this.myConnectionOwner = connectionOwner;
        this.myTitle = title;
        this.myOrigin = origin;
        this.mySemaphore = new FlexibleSemaphore(this.myServer.getFileTransferConfig().getAdvancedOptions().getMaxConnections());
    }

    public synchronized void updateMaxConnections(@NotNull WebServerConfig server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/connections/RemoteConnectionPool", "updateMaxConnections"));
        }
        if (this.myServer.getId() != null && this.myServer.getId().equals(server.getId())) {
            int maxConnections = server.getFileTransferConfig().getAdvancedOptions().getMaxConnections();
            this.mySemaphore.setAvailable(maxConnections);
        }
    }

    public synchronized RemoteConnection createConnection(@Nullable EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> forceDisconnectDispatcher, @Nullable ProgressIndicator pi) throws FileSystemException {
        if (!this.myConnections.isEmpty()) {
            LOG.debug("Reusing connection to " + this.myServer.getFileTransferConfig().getRootUri());
            RemoteConnection existing = this.myConnections.iterator().next();
            return existing.clone();
        }
        LOG.debug("Opening connection to " + this.myServer.getFileTransferConfig().getRootUri());
        FileSystemManager manager = PublishUtils.getManager();
        FileObject root = null;
        FileSystemException exception = null;
        int iteration = 0;
        while (iteration == 0 || iteration < 5 && RemoteConnectionPool.shouldRetryConnecting(exception)) {
            try {
                RemoteConnectionPool.waitBeforeNextAttempt(pi, ++iteration);
                RemoteConnectionPool.setProgressSecondText(pi, WDBundle.message("connecting", new Object[0]));
                root = manager.resolveFile(this.myServer.getFileTransferConfig().getRootUri(), this.myServer.getConnectionOptions(this.myConnectionOwner, this.myTitle, this.myOrigin, forceDisconnectDispatcher, pi));
                root.getChild(".");
                exception = null;
                break;
            }
            catch (FileSystemException e) {
                LOG.warn("Retrying connecting to " + this.myServer.getFileTransferConfig().getRootUri() + ": " + iteration + " iterations", (Throwable)e);
                exception = e;
            }
        }
        RemoteConnectionPool.setProgressSecondText(pi, null);
        if (exception != null) {
            if (root != null) {
                PublishUtils.getManager().closeFileSystem(root.getFileSystem());
            }
            throw exception;
        }
        RemoteConnectionImpl connection = new RemoteConnectionImpl(root);
        this.myConnections.add(connection);
        return connection;
    }

    private static void waitBeforeNextAttempt(@Nullable ProgressIndicator pi, int iteration) {
        int timeout;
        RemoteConnectionPool.checkProgressCancelled(pi);
        if (iteration == 1) {
            return;
        }
        RemoteConnectionPool.setProgressSecondText(pi, WDBundle.message("attempt.0.failed.to.connect.waiting.for.1.to.retry", iteration, RemoteConnectionPool.getPresentableTime(timeout)));
        if (pi != null) {
            for (timeout = pi == null ? 3 : (int)Math.pow(3.0, iteration); timeout > 0; --timeout) {
                RemoteConnectionPool.checkProgressCancelled(pi);
                RemoteConnectionPool.setProgressSecondText(pi, WDBundle.message("attempt.0.failed.to.connect.waiting.for.1.to.retry", iteration, RemoteConnectionPool.getPresentableTime(timeout)));
                RemoteConnectionPool.sleep(1);
            }
        } else {
            RemoteConnectionPool.sleep(timeout);
        }
        RemoteConnectionPool.checkProgressCancelled(pi);
    }

    private static String getPresentableTime(int timeout) {
        if (timeout > 120) {
            return WDBundle.message("0.minutes", timeout / 60);
        }
        if (timeout > 60) {
            return WDBundle.message("a.minute", new Object[0]);
        }
        if (timeout == 1) {
            return WDBundle.message("a.second", new Object[0]);
        }
        return WDBundle.message("0.seconds", timeout);
    }

    private static void sleep(int timeout) {
        try {
            TimeUnit.SECONDS.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void setProgressSecondText(@Nullable ProgressIndicator pi, @Nls String text) {
        if (pi != null) {
            pi.setText2(text);
        }
    }

    private static void checkProgressCancelled(@Nullable ProgressIndicator pi) {
        if (pi != null) {
            pi.checkCanceled();
        }
    }

    private static boolean shouldRetryConnecting(FileSystemException exception) {
        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ConnectException) && !(cause instanceof FTPConnectionClosedException)) continue;
            return true;
        }
        return false;
    }

    private synchronized void releaseConnection(RemoteConnection connection, Throwable previousCaller) {
        if (!this.myConnections.contains(connection)) {
            Throwable throwable = new Throwable("Connection already released in ", previousCaller);
            LOG.error(throwable);
        }
        LOG.debug("Releasing one of the connections to " + this.myServer.getFileTransferConfig().getRootUri());
        this.myConnections.remove(connection);
        if (this.myConnections.isEmpty()) {
            LOG.debug("Disconnecting from " + this.myServer.getFileTransferConfig().getRootUri());
            connection.close();
        }
    }

    public String toString() {
        return "Pool for " + this.myServer.getFileTransferConfig().getRootUri();
    }

    private class RemoteConnectionImpl
    extends RemoteConnection {
        private final AtomicBoolean myIsReleased;
        private Throwable myPreviousCaller;

        protected RemoteConnectionImpl(FileObject root) {
            super(root);
            this.myIsReleased = new AtomicBoolean(false);
        }

        protected RemoteConnectionImpl(FileSystem fileSystem, FileName rootName) {
            super(fileSystem, rootName);
            this.myIsReleased = new AtomicBoolean(false);
        }

        @Override
        public void release() {
            this.myIsReleased.set(true);
            final Throwable previousCaller = this.myPreviousCaller;
            this.myPreviousCaller = new Throwable();
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    RemoteConnectionImpl remoteConnectionImpl = RemoteConnectionImpl.this;
                    synchronized (remoteConnectionImpl) {
                        RemoteConnectionPool.this.releaseConnection(RemoteConnectionImpl.this, previousCaller);
                    }
                }
            });
        }

        @Override
        public void releaseIfOpen() {
            if (this.myIsReleased.compareAndSet(false, true)) {
                this.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized <T> T executeServerOperation(ThrowableComputable<T, FileSystemException> computable, @Nullable ProgressIndicator pi) throws FileSystemException {
            if (this.myIsReleased.get()) {
                if (pi != null) {
                    pi.cancel();
                }
                throw new ProcessCanceledException();
            }
            String originalText = pi != null ? pi.getText() : null;
            try {
                if (pi != null) {
                    pi.setText(WDBundle.message("waiting.for.free.connection", new Object[0]));
                }
                RemoteConnectionPool.this.mySemaphore.take();
            }
            finally {
                if (pi != null) {
                    pi.setText(originalText);
                }
            }
            try {
                Object object = computable.compute();
                return (T)object;
            }
            finally {
                RemoteConnectionPool.this.mySemaphore.release();
            }
        }

        @Override
        public RemoteConnection clone() {
            RemoteConnectionImpl result = new RemoteConnectionImpl(this.getFileSystem(), this.getRootName());
            RemoteConnectionPool.this.myConnections.add(result);
            return result;
        }
    }
}

