/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class AdvancedOptionsForm {
    private JCheckBox myShowHiddenFilesCheckBox;
    private JPanel myContentPane;
    private JCheckBox myPassiveModeCheckBox;
    private JCheckBox myMaxConnectionsCheckBox;
    private JTextField myMaxConnectionsTextField;
    private JLabel myMessageLabel;
    private JComboBox myTimestampsCombo;
    private JLabel myTimestampsLabel;
    private JCheckBox myCompatibilityModeCheckBox;
    private JLabel myDataProtectionLevelLabel;
    private JComboBox myDataProtectionLevelComboBox;
    private JTextField myControlEncodingTextField;
    private JLabel myControlEncodingLabel;
    private JBCheckBox myMuteSftpMessagesCheckBox;
    private JBCheckBox myForceListCommandCheckBox;
    private final AdvancedOptionsConfig myConfig;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public AdvancedOptionsForm(AdvancedOptionsConfig config, AccessType accessType) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        ArrayList<String> timestampsComboValues = new ArrayList<String>();
        for (AdvancedOptionsConfig.AccurateTimestamps v : AdvancedOptionsConfig.AccurateTimestamps.values()) {
            timestampsComboValues.add(WDBundle.message("accurate.timestamps.option." + (Object)((Object)v), new Object[0]));
        }
        this.myTimestampsCombo.setModel(new DefaultComboBoxModel<Object>(timestampsComboValues.toArray()));
        this.myDataProtectionLevelComboBox.setModel(new EnumComboBoxModel(AdvancedOptionsConfig.DataChannelProtectionLevel.class));
        this.myDataProtectionLevelComboBox.setRenderer(new ListCellRendererWrapper<AdvancedOptionsConfig.DataChannelProtectionLevel>(){

            public void customize(JList list, AdvancedOptionsConfig.DataChannelProtectionLevel value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentableValue());
            }
        });
        this.myConfig = config;
        this.reset();
        this.myShowHiddenFilesCheckBox.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myPassiveModeCheckBox.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myTimestampsLabel.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myTimestampsCombo.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myCompatibilityModeCheckBox.setVisible(accessType == AccessType.FTP);
        this.myDataProtectionLevelLabel.setVisible(accessType == AccessType.FTPS);
        this.myDataProtectionLevelComboBox.setVisible(accessType == AccessType.FTPS);
        this.myControlEncodingLabel.setVisible(accessType == AccessType.SFTP || accessType == AccessType.FTP);
        this.myControlEncodingTextField.setVisible(accessType == AccessType.SFTP || accessType == AccessType.FTP);
        this.myMuteSftpMessagesCheckBox.setVisible(accessType == AccessType.SFTP);
        this.myForceListCommandCheckBox.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
    }

    private void reset() {
        this.myShowHiddenFilesCheckBox.setSelected(this.myConfig.isShowHiddenFiles());
        this.myPassiveModeCheckBox.setSelected(this.myConfig.isPassiveMode());
        this.myTimestampsCombo.setSelectedIndex(this.myConfig.getAccurateTimestamps().ordinal());
        if (this.myConfig.getMaxConnections() != Integer.MAX_VALUE) {
            this.myMaxConnectionsCheckBox.setSelected(true);
            this.myMaxConnectionsTextField.setText(String.valueOf(this.myConfig.getMaxConnections()));
            this.myMaxConnectionsTextField.setEnabled(true);
        } else {
            this.myMaxConnectionsCheckBox.setSelected(false);
            this.myMaxConnectionsTextField.setText("");
            this.myMaxConnectionsTextField.setEnabled(false);
        }
        this.myMaxConnectionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AdvancedOptionsForm.this.myMaxConnectionsCheckBox.isSelected()) {
                    AdvancedOptionsForm.this.myMaxConnectionsTextField.setEnabled(true);
                    IdeFocusManager.findInstanceByComponent((Component)AdvancedOptionsForm.this.myContentPane).requestFocus((Component)AdvancedOptionsForm.this.myMaxConnectionsTextField, false);
                } else {
                    AdvancedOptionsForm.this.myMaxConnectionsTextField.setText("");
                    AdvancedOptionsForm.this.myMaxConnectionsTextField.setEnabled(false);
                }
                ((ChangeListener)AdvancedOptionsForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        });
        this.myMaxConnectionsTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((ChangeListener)AdvancedOptionsForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
            }
        });
        this.myCompatibilityModeCheckBox.setSelected(this.myConfig.isCompatibilityMode());
        this.myDataProtectionLevelComboBox.setSelectedIndex(this.myConfig.getDataChannelProtectionLevel().ordinal());
        this.myControlEncodingTextField.setText(this.myConfig.getControlEncoding());
        this.myMuteSftpMessagesCheckBox.setSelected(this.myConfig.isMuteSftpMessages());
        this.myForceListCommandCheckBox.setSelected(this.myConfig.isForceListCommand());
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public void apply() {
        this.myConfig.setShowHiddenFiles(this.myShowHiddenFilesCheckBox.isSelected());
        this.myConfig.setPassiveMode(this.myPassiveModeCheckBox.isSelected());
        this.myConfig.setAccurateTimestamps(AdvancedOptionsConfig.AccurateTimestamps.values()[this.myTimestampsCombo.getSelectedIndex()]);
        String s = this.myMaxConnectionsTextField.getText();
        this.myConfig.setMaxConnections(StringUtil.isEmpty((String)s) ? Integer.MAX_VALUE : Integer.parseInt(s));
        this.myConfig.setCompatibilityMode(this.myCompatibilityModeCheckBox.isSelected());
        this.myConfig.setDataChannelProtectionLevel((AdvancedOptionsConfig.DataChannelProtectionLevel)((Object)this.myDataProtectionLevelComboBox.getSelectedItem()));
        this.myConfig.setControlEncoding(this.myControlEncodingTextField.getText());
        this.myConfig.setMuteSftpMessages(this.myMuteSftpMessagesCheckBox.isSelected());
        this.myConfig.setForceListCommand(this.myForceListCommandCheckBox.isSelected());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPassiveModeCheckBox.isVisible() ? this.myPassiveModeCheckBox : this.myMaxConnectionsCheckBox;
    }

    public void setMessage(String warning) {
        if (warning != null) {
            this.myMessageLabel.setText(warning);
            this.myMessageLabel.setVisible(true);
        } else {
            this.myMessageLabel.setVisible(false);
        }
    }

    @Nullable
    public String getErrorMessage() {
        if (!this.myMaxConnectionsCheckBox.isSelected()) {
            return null;
        }
        String text = this.myMaxConnectionsTextField.getText();
        if (StringUtil.isEmpty((String)text)) {
            return WDBundle.message("empty.max.connections", new Object[0]);
        }
        try {
            if (Integer.parseInt(text) < 1) {
                return WDBundle.message("invalid.max.connections", new Object[0]);
            }
        }
        catch (NumberFormatException e) {
            return WDBundle.message("invalid.max.connections", new Object[0]);
        }
        return null;
    }

    public void addListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JLabel jLabel;
        JTextField jTextField;
        JComboBox jComboBox;
        JLabel jLabel2;
        JCheckBox jCheckBox;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JLabel jLabel3;
        JComboBox jComboBox2;
        JLabel jLabel4;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myShowHiddenFilesCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Show and process hidden files");
        jCheckBox4.setMnemonic('S');
        jCheckBox4.setDisplayedMnemonicIndex(0);
        jCheckBox4.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myPassiveModeCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Passive mode");
        jCheckBox3.setMnemonic('P');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myMessageLabel = jLabel4 = new JLabel();
        jLabel4.setText("Label");
        jPanel.add((Component)jLabel4, new GridConstraints(9, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myTimestampsCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myTimestampsLabel = jLabel3 = new JLabel();
        jLabel3.setText("Retrieve accurate files timestamps:");
        jLabel3.setDisplayedMnemonic('R');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMaxConnectionsCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Limit concurrent connections:");
        jCheckBox2.setMnemonic('L');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMaxConnectionsTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(100, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCompatibilityModeCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Compatibility mode");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDataProtectionLevelLabel = jLabel2 = new JLabel();
        jLabel2.setText("Protect data channel:");
        jLabel2.setDisplayedMnemonic('D');
        jLabel2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDataProtectionLevelComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(5, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myControlEncodingTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(100, -1), null));
        this.myControlEncodingLabel = jLabel = new JLabel();
        jLabel.setText("Control encoding:");
        jLabel.setDisplayedMnemonic('E');
        jLabel.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMuteSftpMessagesCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Ignore info messages");
        jBCheckBox2.setMnemonic('G');
        jBCheckBox2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBCheckBox2, new GridConstraints(7, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myForceListCommandCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Always use LIST command");
        jBCheckBox.setMnemonic('U');
        jBCheckBox.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBCheckBox, new GridConstraints(8, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        jLabel3.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

