/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.ide.diff.BackgroundOperatingDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.jetbrains.plugins.webDeployment.CompareLocalVsRemoteTask;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.SyncLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.RemoteDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.SyncLoadComponent;
import com.jetbrains.plugins.webDeployment.ui.SyncUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalItemDiffElement
extends VirtualFileDiffElement
implements BackgroundOperatingDiffElement {
    private static final Logger LOG = Logger.getInstance((String)LocalItemDiffElement.class.getName());
    private static final int UNKNOWN_VALUE = -1;
    private static final LocalItemDiffElement[] EMPTY = new LocalItemDiffElement[0];
    private final AtomicBoolean myOperationRunning;
    private final AtomicInteger myCurrentDiffComponentVersion;
    private volatile boolean myIsDiffComponentDisposed;
    private PublishConfig myConfig;
    private WebServerConfig myServer;
    private final boolean myProvideFullPaths;
    private final boolean myIsRoot;
    private final DirDiffSettings mySettings;
    private final boolean myExcluded;
    private final Project myProject;
    private DiffPanel myOwnDiffPanel;
    private final DeploymentPathMapping myMapping;
    private FileEditor myOwnFileEditor;
    private FileEditorProvider myOwnEditorProvider;

    public LocalItemDiffElement(@NotNull VirtualFile file, @NotNull DeploymentPathMapping mapping, PublishConfig config, @NotNull WebServerConfig server, boolean excluded, DirDiffSettings settings, boolean provideFullPaths, Project project, boolean isRoot) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "<init>"));
        }
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "<init>"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "<init>"));
        }
        super(file);
        this.myOperationRunning = new AtomicBoolean(false);
        this.myCurrentDiffComponentVersion = new AtomicInteger(0);
        this.myIsDiffComponentDisposed = true;
        this.myMapping = mapping;
        this.myConfig = config;
        this.myServer = server;
        this.myExcluded = excluded;
        this.mySettings = settings;
        this.myProvideFullPaths = provideFullPaths;
        this.myProject = project;
        this.myIsRoot = isRoot;
    }

    public LocalItemDiffElement[] getChildren() {
        if (this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return EMPTY;
        }
        if (this.getValue().is(VFileProperty.SYMLINK)) {
            return EMPTY;
        }
        VirtualFile[] files = this.getValue().getChildren();
        ArrayList<LocalItemDiffElement> elements = new ArrayList<LocalItemDiffElement>();
        for (VirtualFile file : files) {
            boolean isExcluded = SyncUtils.isExcludedLocalOrCorresponding(file.getPath(), this.myMapping, this.myServer, this.myConfig, this.mySettings);
            if (isExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings) || FileTypeManager.getInstance().isFileIgnored(file)) continue;
            elements.add(new LocalItemDiffElement(file, this.myMapping, this.myConfig, this.myServer, isExcluded, this.mySettings, false, this.myProject, false));
        }
        return elements.toArray(new LocalItemDiffElement[elements.size()]);
    }

    public JComponent getDiffComponent(DiffElement element, final Project project, final Window parentWindow, final Disposable disposableParent) throws FilesTooBigForDiffException {
        LOG.assertTrue(element instanceof RemoteItemDiffElement);
        LOG.assertTrue(!SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings) || !this.isExcluded());
        this.myIsDiffComponentDisposed = false;
        final int version = this.myCurrentDiffComponentVersion.incrementAndGet();
        final RemoteItemDiffElement remoteElement = (RemoteItemDiffElement)element;
        if (RemoteItemDiffElement.isTooBig(remoteElement)) {
            this.myIsDiffComponentDisposed = true;
            throw new FilesTooBigForDiffException(0);
        }
        JPanel result = new JPanel(new BorderLayout());
        byte[] cachedRemoteContent = remoteElement.getCachedRemoteContent();
        if (cachedRemoteContent != null) {
            DiffRequest request;
            try {
                request = this.createRequest(project, remoteElement, cachedRemoteContent);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                RemoteItemDiffElement.setErrorReportingComponent(e, null, result);
                return result;
            }
            this.setDiffComponent(request, parentWindow, project, remoteElement, null, result, disposableParent, version);
            return result;
        }
        final JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), disposableParent);
        loadingPanel.startLoading();
        result.add((Component)loadingPanel, "Center");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                DiffRequest request;
                try {
                    request = LocalItemDiffElement.this.createRequest(project, remoteElement);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    RemoteItemDiffElement.setErrorReportingComponent(e, loadingPanel, (JComponent)loadingPanel);
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LocalItemDiffElement.this.setDiffComponent(request, parentWindow, project, remoteElement, loadingPanel, (JComponent)loadingPanel, disposableParent, version);
                    }
                });
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDiffComponent(DiffRequest request, Window parentWindow, Project project, RemoteItemDiffElement remoteElement, @Nullable JBLoadingPanel loadingPanel, JComponent container, Disposable disposableParent, int version) {
        AtomicInteger atomicInteger = this.myCurrentDiffComponentVersion;
        synchronized (atomicInteger) {
            if (this.myIsDiffComponentDisposed || version < this.myCurrentDiffComponentVersion.get()) {
                return;
            }
            this.disposeDiffComponent(false);
            if (request != null) {
                this.myOwnDiffPanel = DiffManager.getInstance().createDiffPanel(parentWindow, project, disposableParent, null);
                this.myOwnDiffPanel.setRequestFocus(false);
                this.myOwnDiffPanel.setDiffRequest(request);
                this.myOwnDiffPanel.setTitle1(this.getName());
                this.myOwnDiffPanel.setTitle2(remoteElement.getName());
                if (loadingPanel != null) {
                    loadingPanel.stopLoading();
                }
                if (!this.myIsDiffComponentDisposed) {
                    container.add((Component)this.myOwnDiffPanel.getComponent(), "Center");
                } else {
                    this.disposeDiffComponent(false);
                }
            } else {
                if (loadingPanel != null) {
                    loadingPanel.stopLoading();
                }
                container.add((Component)new JLabel(WDBundle.message("unknown.or.binary.file.type", new Object[0]), 0), "Center");
            }
        }
    }

    @Nullable
    protected DiffRequest createRequest(Project project, DiffElement element) throws IOException {
        return this.createRequest(project, element, null);
    }

    @Nullable
    protected DiffRequest createRequest(Project project, DiffElement element, @Nullable byte[] elementContent) throws IOException {
        LOG.assertTrue(element instanceof RemoteItemDiffElement);
        LOG.assertTrue(!this.isExcluded() || !SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings));
        VirtualFile src = this.getValue();
        DiffContent srcContent = this.createEditableDiffContent(project);
        DiffContent trgContent = CompareLocalVsRemoteTask.createRemoteContent(elementContent == null ? element.getContent() : elementContent, src, project, ((RemoteItemDiffElement)element).getValue());
        SimpleDiffRequest request = new SimpleDiffRequest(project, "");
        request.setContents(srcContent, trgContent);
        Object title = this.mySettings.customSettings.get("recursive compare window title");
        request.setWindowTitle(title == null ? null : (String)title);
        return request;
    }

    private DiffContent createEditableDiffContent(Project project) {
        return new com.intellij.openapi.diff.FileContent(project, this.getValue());
    }

    public boolean isOperationsEnabled() {
        if (this.myIsRoot) {
            return true;
        }
        if (this.myExcluded || this.myOperationRunning.get()) {
            return false;
        }
        WebServerConfig.RemotePath remotePath = this.myMapping.mapToDeployPath(this.getValue().getPath(), this.myServer);
        return !this.myConfig.isExcludedByName(remotePath.path) && !PublishConfig.isRemotePathExcluded(remotePath, this.myServer, this.myConfig);
    }

    protected boolean isExcluded() {
        return this.myExcluded;
    }

    public long getSize() {
        if (this.isExcluded() && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return -1L;
        }
        try {
            return super.getSize();
        }
        catch (InvalidVirtualFileAccessException e) {
            return -1L;
        }
    }

    public long getTimeStamp() {
        long result;
        if (this.isExcluded() && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            result = -1L;
        } else {
            try {
                result = super.getTimeStamp();
            }
            catch (InvalidVirtualFileAccessException e) {
                LOG.warn((Throwable)e);
                result = -1L;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp of " + this.getValue().getPath() + " is " + result);
        }
        return result;
    }

    @Nullable
    public byte[] getContent() throws IOException {
        if (this.isExcluded() && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return null;
        }
        if (RemoteItemDiffElement.isTooBig((DiffElement)this)) {
            return null;
        }
        try {
            return super.getContent();
        }
        catch (InvalidVirtualFileAccessException e) {
            return null;
        }
    }

    public VirtualFileDiffElement copyTo(DiffElement container, String relativePath) {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.copyTo()");
    }

    public boolean delete() {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.delete()");
    }

    public void copyTo(DiffElement container, final Ref<String> errorMessage, final Ref<DiffElement> diffElement, final Runnable onFinish, final DiffElement targetElement, String path) {
        if (this.myExcluded) {
            return;
        }
        LOG.assertTrue(container instanceof RemoteDiffElement);
        final RemoteDiffElement remoteElement = (RemoteDiffElement)container;
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getPresentablePath());
            return;
        }
        this.saveDocument();
        SyncLoadComponent component = (SyncLoadComponent)this.mySettings.customSettings.get("syncLoadComponent");
        WebServerConfig.RemotePath remotePath = this.myMapping.mapToDeployPath(this.getValue().getPath(), this.myServer);
        TransferOperation.Copy operation = new TransferOperation.Copy(DeploymentPathUtils.getLocalFile(this.getValue().getPath()), remotePath){

            @Override
            public void execute(ExecutionContext context) throws FileSystemException {
                try {
                    context.setIgnoreOverwriting(this.promptOverwriteIgnoreNeeded(context));
                    super.execute(context);
                    if (this.mySuccessfullyFinished) {
                        diffElement.set((Object)new RemoteItemDiffElement(remoteElement.getConnection(), LocalItemDiffElement.this.myServer, this.myTarget, remoteElement.getProject(), LocalItemDiffElement.this.myConfig, false, LocalItemDiffElement.this.myMapping, LocalItemDiffElement.this.mySettings, false, LocalItemDiffElement.this.myIsRoot));
                    }
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    errorMessage.set((Object)WDBundle.message("failed.to.upload.file.0", LocalItemDiffElement.this.getPresentablePath()));
                    throw e;
                }
                finally {
                    context.setIgnoreOverwriting(false);
                    ApplicationManager.getApplication().invokeAndWait(onFinish, ModalityState.defaultModalityState());
                    LocalItemDiffElement.this.myOperationRunning.set(false);
                }
            }

            private boolean promptOverwriteIgnoreNeeded(final ExecutionContext context) {
                if (targetElement == null || context.getConfig().getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.NONE) {
                    return false;
                }
                LOG.assertTrue(targetElement instanceof RemoteItemDiffElement);
                final RemoteItemDiffElement remoteTargetElement = (RemoteItemDiffElement)targetElement;
                try {
                    return remoteTargetElement.getConnection().executeServerOperation(new ThrowableComputable<Boolean, FileSystemException>(){

                        public Boolean compute() throws FileSystemException {
                            FileObject remoteTargetFile = remoteTargetElement.getValue();
                            DeploymentPathUtils.refreshRemoteFile(remoteTargetFile, context);
                            FileContent content = remoteTargetFile.getContent();
                            switch (context.getConfig().getPromptOnRemoteOverwrite()) {
                                case CHECK_TIMESTAMP: {
                                    boolean unchanged = true;
                                    if (remoteTargetElement.getSize() != content.getSize()) {
                                        unchanged = false;
                                    }
                                    boolean accurateTimestamp = context.getServer().getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                                    long newTimestamp = content.getLastModifiedTime(accurateTimestamp);
                                    if (!(unchanged &= TransferOperation.areTimestampsEqual(remoteTargetElement.getTimeStamp(), newTimestamp, ((LocalItemDiffElement)LocalItemDiffElement.this).mySettings.compareTimestampAccuracy))) {
                                        remoteTargetElement.reset(content.getSize(), newTimestamp, null);
                                    }
                                    return unchanged;
                                }
                                case CHECK_CONTENT: {
                                    boolean unchanged = true;
                                    if (remoteTargetElement.getSize() != content.getSize()) {
                                        unchanged = false;
                                    }
                                    byte[] newContent = null;
                                    if (unchanged) {
                                        try {
                                            newContent = FileUtil.getContent((FileObject)remoteTargetFile);
                                            unchanged = Arrays.equals(remoteTargetElement.getContent(), newContent);
                                        }
                                        catch (IOException e) {
                                            LOG.warn((Throwable)e);
                                            return false;
                                        }
                                    }
                                    if (!unchanged) {
                                        boolean accurateTimestamp = context.getServer().getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                                        long newTimestamp = content.getLastModifiedTime(accurateTimestamp);
                                        unchanged = TransferOperation.areTimestampsEqual(remoteTargetElement.getTimeStamp(), newTimestamp, remoteTargetFile.getFileSystem().getLastModTimeAccuracy());
                                        remoteTargetElement.reset(content.getSize(), newTimestamp, newContent);
                                    }
                                    return unchanged;
                                }
                            }
                            return false;
                        }
                    }, null);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    return false;
                }
            }
        };
        component.offerTransferOperation(operation, true);
    }

    protected void saveDocument() {
        FileDocumentManager manager = FileDocumentManager.getInstance();
        Document document = manager.getDocument(this.getValue());
        if (document != null) {
            manager.saveDocument(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Ref<String> errorMessage, Runnable onFinish) {
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getPresentablePath());
            return;
        }
        if (this.myExcluded) {
            LOG.debug("Excluded " + this.getPresentablePath());
            return;
        }
        if (!this.getValue().exists()) {
            onFinish.run();
            this.myOperationRunning.set(false);
            return;
        }
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(((Object)((Object)this)).getClass());
        try {
            this.getValue().delete((Object)this);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            errorMessage.set((Object)WDBundle.message("failed.to.delete.local.file.0.1", this.getValue().getPath(), StringUtil.decapitalize((String)StringUtil.notNullize((String)e.getLocalizedMessage(), (String)WDBundle.message("unknown.reason", new Object[0])))));
        }
        finally {
            token.finish();
            onFinish.run();
            this.myOperationRunning.set(false);
        }
    }

    public LocalItemDiffElement createElement(VirtualFile file) {
        return LocalItemDiffElement.createLocalElement(file, this.myMapping, this.myConfig, this.myServer, this.mySettings, this.myProject);
    }

    static LocalItemDiffElement createLocalElement(VirtualFile file, DeploymentPathMapping mapping, PublishConfig config, WebServerConfig server, DirDiffSettings settings, Project project) {
        boolean excluded = SyncUtils.isExcludedLocalOrCorresponding(file.getPath(), mapping, server, config, settings);
        return new LocalItemDiffElement(file, mapping, config, server, excluded, settings, false, project, false);
    }

    public void disposeDiffComponent() {
        this.disposeDiffComponent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeDiffComponent(boolean external) {
        AtomicInteger atomicInteger = this.myCurrentDiffComponentVersion;
        synchronized (atomicInteger) {
            if (external) {
                this.myIsDiffComponentDisposed = true;
            }
            if (this.myOwnDiffPanel != null) {
                Disposer.dispose((Disposable)this.myOwnDiffPanel);
                this.myOwnDiffPanel = null;
            }
        }
    }

    public Callable<DiffElement<VirtualFile>> getElementChooser(Project project) {
        return null;
    }

    @NotNull
    public String getName() {
        if (this.myProvideFullPaths && this.isContainer()) {
            String localPath = this.getValue().getPath();
            String string = RemoteItemDiffElement.getRelativePathOfProjectFileInProject(localPath, this.myProject, localPath);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "getName"));
            }
            return string;
        }
        String string = super.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/LocalItemDiffElement", "getName"));
        }
        return string;
    }

    protected JComponent getFromProviders(Project project, DiffElement target) {
        Trinity<JComponent, FileEditor, FileEditorProvider> trinity = RemoteItemDiffElement.getFromProviders(this.getValue(), project);
        if (trinity.getSecond() != null) {
            this.myOwnFileEditor = (FileEditor)trinity.getSecond();
        }
        if (trinity.getThird() != null) {
            this.myOwnEditorProvider = (FileEditorProvider)trinity.getThird();
        }
        return (JComponent)trinity.getFirst();
    }

    public void disposeViewComponent() {
        super.disposeViewComponent();
        if (this.myOwnFileEditor != null && this.myOwnEditorProvider != null) {
            RemoteItemDiffElement.saveFileEditorState(this.myOwnFileEditor);
            this.myOwnEditorProvider.disposeEditor(this.myOwnFileEditor);
            this.myOwnFileEditor = null;
            this.myOwnEditorProvider = null;
        }
    }

    public DataProvider getDataProvider(final Project project) {
        return new DataProvider(){

            public Object getData(@NonNls String dataId) {
                if (CommonDataKeys.PROJECT.is(dataId)) {
                    return project;
                }
                if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                    return LocalItemDiffElement.this.myOwnFileEditor;
                }
                return null;
            }
        };
    }

    public String toString() {
        return "LocalItemDiffElement{name=" + this.getName() + '}';
    }
}

