/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;

public class OverwriteRemoteWarningDialog
extends DialogWrapper {
    private String myFilePath;
    private Action myOverwriteAction;
    private Action myMergeAction;
    private Action mySkipAction;
    private String myServerName;
    public static final int OVERWRITE_EXIT_CODE = 3;
    public static final int MERGE_EXIT_CODE = 4;
    public static final int SKIP_EXIT_CODE = 5;

    public static OverwriteRemoteWarningDialog createInstance(ConnectionOwner connectionOwner, FileObject file, WebServerConfig server) {
        Component component = connectionOwner.getComponentForDialogCreation();
        OverwriteRemoteWarningDialog dialog = component != null ? new OverwriteRemoteWarningDialog(component) : new OverwriteRemoteWarningDialog(connectionOwner.getProjectForDialogCreation());
        dialog.init(file, server);
        return dialog;
    }

    private OverwriteRemoteWarningDialog(Project project) {
        super(project, true);
    }

    private OverwriteRemoteWarningDialog(@NotNull Component parentComponent) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog", "<init>"));
        }
        super(parentComponent, true);
    }

    private void init(FileObject file, WebServerConfig server) {
        this.setTitle(WDBundle.message("overwrite.remote.dialog.title", server.getName()));
        this.myServerName = server.getName();
        this.myFilePath = server.getPresentablePath(file);
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file.getName().getBaseName());
        this.myMergeAction = fileType.isBinary() || fileType.isReadOnly() ? null : new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, WDBundle.message("overwrite.remote.dialog.merge.action.name", new Object[0]), 4);
        this.myOverwriteAction = new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, WDBundle.message("overwrite.remote.dialog.overwrite.action.name", new Object[0]), 3);
        this.mySkipAction = new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, WDBundle.message("overwrite.remote.dialog.skip.action.name", new Object[0]), 5);
        this.init();
    }

    public void setSkipActionTitle(String title) {
        this.mySkipAction.putValue("Name", title);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(WDBundle.message(this.myMergeAction != null ? "overwrite.remote.dialog.text" : "overwrite.remote.dialog.text.binary", this.myFilePath, this.myServerName));
        label.setIconTextGap(10);
        label.setIcon(Messages.getWarningIcon());
        panel.add((Component)label, "Center");
        panel.add(Box.createVerticalStrut(10), "South");
        return panel;
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myMergeAction != null) {
            Action[] actionArray = new Action[]{this.myOverwriteAction, this.myMergeAction, this.mySkipAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.myOverwriteAction, this.mySkipAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/OverwriteRemoteWarningDialog", "createActions"));
        }
        return actionArray;
    }
}

