/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.BackgroundOperatingDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TransferableFileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.CompareLocalVsRemoteTask;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.SyncLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.CompositeDiffElement;
import com.jetbrains.plugins.webDeployment.ui.LocalItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteReadOnlyVirtualFile;
import com.jetbrains.plugins.webDeployment.ui.SyncLoadComponent;
import com.jetbrains.plugins.webDeployment.ui.SyncUtils;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FilesCache;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteItemDiffElement
extends DiffElement<FileObject>
implements BackgroundOperatingDiffElement,
RemoteDiffElement {
    private static final Logger LOG = Logger.getInstance((String)RemoteItemDiffElement.class.getName());
    private static final RemoteItemDiffElement[] EMPTY = new RemoteItemDiffElement[0];
    public static final int UNKNOWN_VALUE = -1;
    private static final long MAX_SIZE = 0x100000L;
    private final AtomicBoolean myOperationRunning = new AtomicBoolean(false);
    private final AtomicInteger myCurrentViewVersion = new AtomicInteger(0);
    private volatile boolean myIsViewComponentDisposed = true;
    private final Project myProject;
    private final RemoteConnection myConnection;
    private final PublishConfig myConfig;
    private final WebServerConfig myServer;
    private final FileObject myFile;
    private final org.apache.commons.vfs2.FileType myFileType;
    private final DirDiffSettings mySettings;
    private final boolean myProvideFullPaths;
    private final boolean myIsRoot;
    private long mySize;
    private long myLastModified;
    private Editor myTextEditor;
    private FileEditor myFileEditor;
    private FileEditorProvider myEditorProvider;
    private boolean myExcluded;
    private final DeploymentPathMapping myMapping;
    private SoftReference<byte[]> myCachedContent;
    private RemoteItemDiffElement[] myCachedChildren;
    private RemoteItemDiffElement[] myCachedExcludedChildren;

    public RemoteItemDiffElement(RemoteConnection connection, WebServerConfig server, FileObject file, Project project, PublishConfig config, boolean excluded, DeploymentPathMapping mapping, DirDiffSettings settings, boolean provideFullPaths, boolean isRoot) throws FileSystemException {
        this.myConnection = connection;
        this.myServer = server;
        this.myFile = file;
        this.myProject = project;
        this.myExcluded = excluded;
        this.myMapping = mapping;
        this.myConfig = config;
        this.mySettings = settings;
        this.myProvideFullPaths = provideFullPaths;
        this.myIsRoot = isRoot;
        this.myFileType = ServerTreeNode.getFileType(file);
        if (org.apache.commons.vfs2.FileType.IMAGINARY != this.myFileType) {
            FileContent content = file.getContent();
            this.myLastModified = content.getLastModifiedTime(this.myServer.getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER);
            this.mySize = this.myFileType.hasContent() ? content.getSize() : 0L;
        } else {
            this.myLastModified = -1L;
            this.mySize = 0L;
        }
    }

    public String getPath() {
        return this.myServer.getPresentablePath(this.myFile);
    }

    public String getPresentablePath() {
        return WDBundle.message("remote.diff.title.0.on.server.1", this.getShortPresentablePath(), this.myServer.getName());
    }

    protected String getShortPresentablePath() {
        return this.myServer.getPresentablePath(this.myFile);
    }

    @NotNull
    public String getName() {
        if (this.myProvideFullPaths && this.isContainer()) {
            String localPath = this.myMapping.mapToLocalPath(this.myFile, this.myServer);
            localPath = FileUtil.toSystemIndependentName((String)localPath);
            String string = RemoteItemDiffElement.getRelativePathOfProjectFileInProject(localPath, this.myProject, localPath);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getName"));
            }
            return string;
        }
        String string = this.myFile.getName().getBaseName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getName"));
        }
        return string;
    }

    public long getSize() {
        if (this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return -1L;
        }
        return this.mySize;
    }

    public long getTimeStamp() {
        long result = this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings) ? -1L : this.myLastModified;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timestamp of " + this.myServer.getPresentablePath(this.myFile) + " is " + this.myLastModified);
        }
        return result;
    }

    public boolean isContainer() {
        return this.myFileType.hasChildren();
    }

    public RemoteItemDiffElement[] getChildren() throws IOException {
        boolean showExcluded;
        LOG.assertTrue(this.isContainer());
        if (this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return EMPTY;
        }
        boolean bl = showExcluded = !SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings);
        if (this.myCachedChildren == null || showExcluded && this.myCachedExcludedChildren == null) {
            FileObject[] children;
            if (this.myFile.isSymbolicLink()) {
                this.myCachedChildren = new RemoteItemDiffElement[0];
                this.myCachedExcludedChildren = new RemoteItemDiffElement[0];
                return EMPTY;
            }
            try {
                children = ServerTreeNode.getChildren(this.myFile, this.myServer, new ThrowableComputable<RemoteConnection, FileSystemException>(){

                    public RemoteConnection compute() throws FileSystemException {
                        return RemoteItemDiffElement.this.myConnection;
                    }
                });
            }
            catch (CustomFileSystemException e) {
                throw new IOException(e.getMessage(), (Throwable)((Object)e));
            }
            if (children.length == 0) {
                return EMPTY;
            }
            final ArrayList result = new ArrayList(children.length);
            final ArrayList excludedResult = new ArrayList(children.length);
            try {
                for (final FileObject child : children) {
                    this.myConnection.executeServerOperation(new ThrowableRunnable<FileSystemException>(){

                        public void run() throws FileSystemException {
                            boolean excluded = SyncUtils.isExcludedRemoteOrCorresponding(child, RemoteItemDiffElement.this.myMapping, RemoteItemDiffElement.this.myServer, RemoteItemDiffElement.this.myConfig, RemoteItemDiffElement.this.mySettings);
                            if (!excluded) {
                                result.add(new RemoteItemDiffElement(RemoteItemDiffElement.this.myConnection, RemoteItemDiffElement.this.myServer, child, RemoteItemDiffElement.this.myProject, RemoteItemDiffElement.this.myConfig, excluded, RemoteItemDiffElement.this.myMapping, RemoteItemDiffElement.this.mySettings, false, false));
                            } else if (showExcluded) {
                                excludedResult.add(new RemoteItemDiffElement(RemoteItemDiffElement.this.myConnection, RemoteItemDiffElement.this.myServer, child, RemoteItemDiffElement.this.myProject, RemoteItemDiffElement.this.myConfig, excluded, RemoteItemDiffElement.this.myMapping, RemoteItemDiffElement.this.mySettings, false, false));
                            }
                        }
                    }, null);
                }
            }
            catch (FileSystemException e) {
                throw new IOException(e.getMessage(), e);
            }
            this.myCachedChildren = result.toArray(new RemoteItemDiffElement[result.size()]);
            if (showExcluded) {
                this.myCachedExcludedChildren = excludedResult.toArray(new RemoteItemDiffElement[excludedResult.size()]);
            }
        }
        if (!showExcluded) {
            return this.myCachedChildren;
        }
        RemoteItemDiffElement[] result = new RemoteItemDiffElement[this.myCachedChildren.length + this.myCachedExcludedChildren.length];
        System.arraycopy(this.myCachedChildren, 0, result, 0, this.myCachedChildren.length);
        System.arraycopy(this.myCachedExcludedChildren, 0, result, this.myCachedChildren.length, this.myCachedExcludedChildren.length);
        return result;
    }

    @Nullable
    public byte[] getContent() throws IOException {
        if (this.myExcluded && SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings)) {
            return null;
        }
        if (this.myFileType == org.apache.commons.vfs2.FileType.IMAGINARY) {
            throw new IOException(WDBundle.message("file.0.can.not.be.found", this.myServer.getPresentablePath(this.myFile)));
        }
        if (RemoteItemDiffElement.isTooBig(this)) {
            return null;
        }
        byte[] result = this.getCachedRemoteContent();
        if (result == null) {
            Pair<byte[], IOException> resultPair = this.myConnection.executeServerOperation(new Computable<Pair<byte[], IOException>>(){

                public Pair<byte[], IOException> compute() {
                    try {
                        return new Pair((Object)FileTransferUtil.getContent(RemoteItemDiffElement.this.myFile, null), null);
                    }
                    catch (IOException e) {
                        return new Pair(null, (Object)e);
                    }
                }
            }, null);
            if (resultPair.getSecond() != null) {
                throw (IOException)resultPair.getSecond();
            }
            result = (byte[])resultPair.getFirst();
            this.myCachedContent = new SoftReference((Object)result);
            return result;
        }
        return result;
    }

    @NotNull
    protected DiffContent createDiffContent() throws IOException {
        LOG.assertTrue(!this.isExcluded() || !SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings));
        DiffContent diffContent = CompareLocalVsRemoteTask.createRemoteContent(this.getContent(), this.getCharset(), this.getFileType(), this.myProject, this.myFile);
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "createDiffContent"));
        }
        return diffContent;
    }

    public FileObject getValue() {
        return this.myFile;
    }

    public Icon getIcon() {
        Icon basicIcon;
        Icon icon = basicIcon = this.isContainer() ? PlatformIcons.FOLDER_ICON : this.getFileType().getIcon();
        if (this.myFileType == org.apache.commons.vfs2.FileType.IMAGINARY) {
            return new LayeredIcon(new Icon[]{basicIcon, AllIcons.General.WarningDecorator});
        }
        return basicIcon;
    }

    public JComponent getViewComponent(final Project project, @Nullable DiffElement target, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getViewComponent"));
        }
        LOG.assertTrue(!this.isExcluded() || !SyncLocalVsRemoteAction.isExcludedFileHidden(this.mySettings));
        assert (target == null || target instanceof LocalItemDiffElement);
        this.myIsViewComponentDisposed = false;
        final int version = this.myCurrentViewVersion.incrementAndGet();
        if (RemoteItemDiffElement.isTooBig(this)) {
            this.myIsViewComponentDisposed = true;
            return new JLabel(WDBundle.message("can.not.build.diff.for.file.0.file.is.too.big.and.there.are.too.many.changes", this.getPath()));
        }
        if (this.myFileType == org.apache.commons.vfs2.FileType.IMAGINARY) {
            this.myIsViewComponentDisposed = true;
            return new JLabel(WDBundle.message("can.not.provide.content.of.file.0.probably.it.s.a.recursive.symlink", this.getPath()));
        }
        final Charset charset = target != null ? ((LocalItemDiffElement)target).getValue().getCharset() : this.getCharset();
        final FileType fileType = this.getFileType();
        JPanel result = new JPanel(new BorderLayout());
        byte[] cachedContent = this.getCachedRemoteContent();
        if (cachedContent != null) {
            this.setViewComponentContent(cachedContent, project, fileType, null, result, charset, version);
            return result;
        }
        final JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), parentDisposable);
        loadingPanel.startLoading();
        result.add((Component)loadingPanel, "Center");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                byte[] content;
                try {
                    content = RemoteItemDiffElement.this.getContent();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    RemoteItemDiffElement.setErrorReportingComponent(e, loadingPanel, (JComponent)loadingPanel);
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RemoteItemDiffElement.this.setViewComponentContent(content, project, fileType, loadingPanel, (JComponent)loadingPanel, charset, version);
                    }
                });
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setViewComponentContent(byte[] content, Project project, @NotNull FileType fileType, @Nullable JBLoadingPanel loadingPanel, JComponent container, Charset charset, int version) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "setViewComponentContent"));
        }
        AtomicInteger atomicInteger = this.myCurrentViewVersion;
        synchronized (atomicInteger) {
            JComponent componentToSet;
            if (this.myIsViewComponentDisposed || version < this.myCurrentViewVersion.get()) {
                return;
            }
            this.disposeViewComponent(false);
            if (fileType.isBinary()) {
                VirtualFile vFile = this.getVirtualFile(content);
                Trinity<JComponent, FileEditor, FileEditorProvider> trinity = RemoteItemDiffElement.getFromProviders(vFile, project);
                if (trinity.getSecond() != null) {
                    this.myFileEditor = (FileEditor)trinity.getSecond();
                }
                if (trinity.getThird() != null) {
                    this.myEditorProvider = (FileEditorProvider)trinity.getThird();
                }
                componentToSet = (JComponent)trinity.getFirst();
            } else {
                EditorFactory editorFactory = EditorFactory.getInstance();
                Document document = editorFactory.createDocument((CharSequence)StringUtil.convertLineSeparators((String)new String(content, charset)));
                this.myTextEditor = editorFactory.createEditor(document, project, fileType, true);
                this.myTextEditor.getSettings().setFoldingOutlineShown(false);
                componentToSet = this.myTextEditor.getComponent();
            }
            if (loadingPanel != null) {
                loadingPanel.stopLoading();
            }
            if (!this.myIsViewComponentDisposed) {
                container.add((Component)componentToSet, "Center");
            } else {
                this.disposeViewComponent(false);
            }
        }
    }

    static Trinity<JComponent, FileEditor, FileEditorProvider> getFromProviders(VirtualFile vFile, Project project) {
        JComponent componentToSet;
        FileEditor fileEditor = null;
        FileEditorProvider editorProvider = null;
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(project, vFile);
        if (providers.length > 0) {
            fileEditor = providers[0].createEditor(project, vFile);
            editorProvider = providers[0];
            RemoteItemDiffElement.setCustomState(fileEditor);
            componentToSet = fileEditor.getComponent();
        } else {
            componentToSet = new JLabel(WDBundle.message("unknown.or.binary.file.type", new Object[0]));
        }
        return Trinity.create((Object)componentToSet, (Object)fileEditor, (Object)editorProvider);
    }

    private static void setCustomState(FileEditor editor) {
        FileEditorState state = editor.getState(FileEditorStateLevel.FULL);
        if (state instanceof TransferableFileEditorState) {
            TransferableFileEditorState editorState = (TransferableFileEditorState)state;
            String id = editorState.getEditorId();
            HashMap<String, String> options = new HashMap<String, String>();
            PropertiesComponent properties = PropertiesComponent.getInstance();
            for (String key : editorState.getTransferableOptions().keySet()) {
                String value = properties.getValue(RemoteItemDiffElement.getKey(id, key));
                if (value == null) continue;
                options.put(key, value);
            }
            editorState.setTransferableOptions(options);
            editor.setState((FileEditorState)editorState);
        }
    }

    static void saveFileEditorState(FileEditor editor) {
        FileEditorState state = editor.getState(FileEditorStateLevel.FULL);
        if (state instanceof TransferableFileEditorState) {
            TransferableFileEditorState editorState = (TransferableFileEditorState)state;
            String id = editorState.getEditorId();
            PropertiesComponent properties = PropertiesComponent.getInstance();
            Map options = editorState.getTransferableOptions();
            for (String key : options.keySet()) {
                properties.setValue(RemoteItemDiffElement.getKey(id, key), (String)options.get(key));
            }
        }
    }

    @NonNls
    private static String getKey(String editorId, String key) {
        return "sync.dir.diff.editor.options." + editorId + "." + key;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getProject"));
        }
        return project;
    }

    public void copyTo(DiffElement container, final Ref<String> errorMessage, final Ref<DiffElement> diffElement, final Runnable onFinish, final DiffElement targetElement, String path) {
        FileDocumentManager documentManager;
        Document document;
        if (this.myExcluded) {
            return;
        }
        LOG.assertTrue(container instanceof LocalItemDiffElement || container instanceof CompositeDiffElement.LocalCompositeDiffElement, container.getClass());
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getShortPresentablePath());
            return;
        }
        final String localPath = this.myMapping.mapToLocalPath(this.myFile, this.myServer);
        VirtualFile childFile = LocalFileSystem.getInstance().findFileByPath(localPath);
        if (childFile != null && (document = (documentManager = FileDocumentManager.getInstance()).getDocument(childFile)) != null) {
            documentManager.saveDocument(document);
        }
        SyncLoadComponent component = (SyncLoadComponent)this.mySettings.customSettings.get("syncLoadComponent");
        FileObject target = DeploymentPathUtils.getLocalFile(localPath);
        if (target == null) {
            LOG.warn("No child for download");
            String message = this.getErrorMessage();
            errorMessage.set((Object)message);
            component.reportSkipping(message);
            onFinish.run();
            this.myOperationRunning.set(false);
            return;
        }
        TransferOperation.Copy operation = new TransferOperation.Copy(this.myFile, target){

            @Override
            public void execute(ExecutionContext context) throws FileSystemException {
                try {
                    if (targetElement != null) {
                        context.setIgnoreOverwriting(true);
                    }
                    super.execute(context);
                    VirtualFile child = LocalFileSystem.getInstance().refreshAndFindFileByPath(localPath);
                    if (child == null) {
                        errorMessage.set((Object)WDBundle.message("failed.to.create.local.file.0", localPath));
                    } else {
                        LocalItemDiffElement element = LocalItemDiffElement.createLocalElement(child, RemoteItemDiffElement.this.myMapping, RemoteItemDiffElement.this.myConfig, RemoteItemDiffElement.this.myServer, RemoteItemDiffElement.this.mySettings, RemoteItemDiffElement.this.myProject);
                        diffElement.set((Object)element);
                    }
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    errorMessage.set((Object)WDBundle.message("failed.to.download.file.0", RemoteItemDiffElement.this.getPresentablePath()));
                    throw e;
                }
                finally {
                    context.setIgnoreOverwriting(false);
                    ApplicationManager.getApplication().invokeAndWait(onFinish, ModalityState.defaultModalityState());
                    RemoteItemDiffElement.this.myOperationRunning.set(false);
                }
            }
        };
        component.offerTransferOperation(operation, false);
    }

    private String getErrorMessage() {
        return WDBundle.message("failed.to.copy.file.0.1", this.getShortPresentablePath(), WDBundle.message("destination.differs.from.mapped.destination", new Object[0]));
    }

    public void delete(final Ref<String> errorMessage, final Runnable onFinish) {
        if (!this.myOperationRunning.compareAndSet(false, true)) {
            LOG.debug("Operation is still running on " + this.getShortPresentablePath());
            return;
        }
        if (this.myExcluded) {
            LOG.debug("Excluded " + this.getPresentablePath());
            return;
        }
        SyncLoadComponent component = (SyncLoadComponent)this.mySettings.customSettings.get("syncLoadComponent");
        TransferOperation.Delete operation = new TransferOperation.Delete(this.myFile, false, true){

            @Override
            public void execute(ExecutionContext context) throws FileSystemException {
                try {
                    super.execute(context);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    errorMessage.set((Object)WDBundle.message("failed.to.delete.remote.file.0", RemoteItemDiffElement.this.getPresentablePath()));
                    throw e;
                }
                finally {
                    ApplicationManager.getApplication().invokeAndWait(onFinish, ModalityState.defaultModalityState());
                    RemoteItemDiffElement.this.myOperationRunning.set(false);
                }
            }
        };
        component.offerTransferOperation(operation, true);
    }

    @Override
    @NotNull
    public RemoteConnection getConnection() {
        RemoteConnection remoteConnection = this.myConnection;
        if (remoteConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getConnection"));
        }
        return remoteConnection;
    }

    @Nullable
    public byte[] getCachedRemoteContent() {
        return (byte[])SoftReference.dereference(this.myCachedContent);
    }

    protected static void setErrorReportingComponent(IOException e, @Nullable JBLoadingPanel loadingPanel, JComponent container) {
        JLabel label = new JLabel(WDBundle.message("failed.to.load.content.0", StringUtil.decapitalize((String)PublishUtils.getMessage(e, true))));
        label.setIcon(UIUtil.getBalloonErrorIcon());
        if (loadingPanel != null) {
            loadingPanel.stopLoading();
        }
        container.add((Component)label, "North");
    }

    public void disposeViewComponent() {
        this.disposeViewComponent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeViewComponent(boolean isExternal) {
        AtomicInteger atomicInteger = this.myCurrentViewVersion;
        synchronized (atomicInteger) {
            if (isExternal) {
                this.myIsViewComponentDisposed = true;
            }
            if (this.myTextEditor != null) {
                EditorFactory.getInstance().releaseEditor(this.myTextEditor);
                this.myTextEditor = null;
            } else if (this.myFileEditor != null) {
                RemoteItemDiffElement.saveFileEditorState(this.myFileEditor);
                this.myEditorProvider.disposeEditor(this.myFileEditor);
                this.myEditorProvider = null;
                this.myFileEditor = null;
            }
        }
    }

    public boolean isOperationsEnabled() {
        if (this.myIsRoot) {
            return true;
        }
        if (this.myExcluded || this.myOperationRunning.get() || this.myFileType == org.apache.commons.vfs2.FileType.IMAGINARY) {
            return false;
        }
        String localPath = this.myMapping.mapToLocalPath(this.myFile, this.myServer);
        return !this.myConfig.isExcludedByName(localPath) && !PublishConfig.isLocalPathExcluded(localPath, this.myServer, this.myConfig) && !SyncUtils.isLocalPathExcludedFromProject(localPath, this.mySettings);
    }

    public DiffElement<?> copyTo(DiffElement container, String relativePath) {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.copyTo()");
    }

    public boolean delete() {
        throw new UnsupportedOperationException("Use BackgroundOperatingDiffElement.delete()");
    }

    protected boolean isExcluded() {
        return this.myExcluded;
    }

    public void refresh(boolean userInitiated) throws IOException {
        if (userInitiated && this.myFileType != org.apache.commons.vfs2.FileType.IMAGINARY) {
            try {
                this.myConnection.executeServerOperation(new ThrowableRunnable<FileSystemException>(){

                    public void run() throws FileSystemException {
                        FilesCache cache = PublishUtils.getManager().getFilesCache();
                        FileSystem fs = RemoteItemDiffElement.this.myFile.getFileSystem();
                        RemoteItemDiffElement.clearFileSystemCache(RemoteItemDiffElement.this, cache, fs);
                        RemoteItemDiffElement.this.myFile.refresh();
                        FileContent content = RemoteItemDiffElement.this.myFile.getContent();
                        RemoteItemDiffElement.this.myLastModified = content.getLastModifiedTime(RemoteItemDiffElement.this.myServer.getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER);
                        RemoteItemDiffElement.this.mySize = RemoteItemDiffElement.this.myFileType.hasContent() ? content.getSize() : 0L;
                        RemoteItemDiffElement.access$1402(RemoteItemDiffElement.this, null);
                        RemoteItemDiffElement.access$1502(RemoteItemDiffElement.this, null);
                        RemoteItemDiffElement.this.myCachedContent = null;
                        RemoteItemDiffElement.this.myExcluded = Boolean.TRUE.booleanValue() == RemoteItemDiffElement.this.myConfig.isExcludedByName(RemoteItemDiffElement.this.myServer.getPresentablePath(RemoteItemDiffElement.this.myFile));
                    }
                }, null);
            }
            catch (FileSystemException e) {
                LOG.warn((Throwable)e);
                throw new IOException(PublishUtils.getMessage(e, true), e);
            }
        }
    }

    private static void clearFileSystemCache(RemoteItemDiffElement element, FilesCache cache, FileSystem fileSystem) {
        cache.removeFile(fileSystem, element.getValue().getName());
        if (element.isContainer() && element.myCachedChildren != null) {
            for (RemoteItemDiffElement child : element.myCachedChildren) {
                RemoteItemDiffElement.clearFileSystemCache(child, cache, fileSystem);
            }
        }
    }

    public void reset(long size, long timestamp, @Nullable byte[] content) {
        this.mySize = size;
        this.myLastModified = timestamp;
        this.myCachedContent = content != null ? new SoftReference((Object)content) : null;
        this.myCachedChildren = null;
        this.myCachedExcludedChildren = null;
    }

    public DataProvider getDataProvider(Project project) {
        return new DataProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getData(@NonNls String dataId) {
                if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                    AtomicInteger atomicInteger = RemoteItemDiffElement.this.myCurrentViewVersion;
                    synchronized (atomicInteger) {
                        return RemoteItemDiffElement.this.myFileEditor;
                    }
                }
                return null;
            }
        };
    }

    private VirtualFile getVirtualFile(byte[] content) {
        return new RemoteReadOnlyVirtualFile(this.myFile, content, false);
    }

    @NotNull
    static String getRelativePathOfProjectFileInProject(@NotNull String localPath, Project project, @NotNull String defaultPath) {
        VirtualFile[] contentRoots;
        String path;
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getRelativePathOfProjectFileInProject"));
        }
        if (defaultPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPath", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getRelativePathOfProjectFileInProject"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && (path = DeploymentPathUtils.getPathRemainder(baseDir.getPath(), localPath, SystemInfo.isFileSystemCaseSensitive)) != null) {
            if (path.isEmpty()) {
                String string = baseDir.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getRelativePathOfProjectFileInProject"));
                }
                return string;
            }
            String string = path;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getRelativePathOfProjectFileInProject"));
            }
            return string;
        }
        for (VirtualFile root : contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            path = DeploymentPathUtils.getPathRemainder(root.getPath(), localPath, SystemInfo.isFileSystemCaseSensitive);
            if (path == null) continue;
            String name = root.getName();
            for (VirtualFile contentRoot : contentRoots) {
                if (!name.equals(contentRoot.getName()) || contentRoot.equals(root)) continue;
                String string = localPath;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getRelativePathOfProjectFileInProject"));
                }
                return string;
            }
            String string = path.isEmpty() ? WDBundle.message("0.in.angle.brackets", root.getName()) : WDBundle.message("path.in.root.0.1", root.getName(), path);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getRelativePathOfProjectFileInProject"));
            }
            return string;
        }
        String string = defaultPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/RemoteItemDiffElement", "getRelativePathOfProjectFileInProject"));
        }
        return string;
    }

    public static boolean isTooBig(DiffElement element) {
        return element.getSize() > 0x100000L;
    }

    public String toString() {
        return "RemoteItemDiffElement{name=" + this.getName() + '}';
    }

    static /* synthetic */ RemoteItemDiffElement[] access$1402(RemoteItemDiffElement x0, RemoteItemDiffElement[] x1) {
        x0.myCachedChildren = x1;
        return x1;
    }

    static /* synthetic */ RemoteItemDiffElement[] access$1502(RemoteItemDiffElement x0, RemoteItemDiffElement[] x1) {
        x0.myCachedExcludedChildren = x1;
        return x1;
    }
}

