/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.AddServerDialog;
import com.jetbrains.plugins.webDeployment.ui.UiConstants;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerCombo
extends ComboboxWithBrowseButton {
    private final boolean myRemoteServersOnly;
    private final int myEditServerTab;
    private final boolean myKeepNoneItem;
    private Project myProject;
    private ItemComparator myComparator;
    @Nullable
    private Condition<WebServerConfig> myWebServerFilter = null;
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);
    private static final Item ITEM_NONE = new Item("");

    public WebServerCombo(boolean remoteServersOnly, int editServerTab, boolean keepNoneItem) {
        super((JComboBox)new ComboBox());
        this.myRemoteServersOnly = remoteServersOnly;
        this.myEditServerTab = editServerTab;
        this.myKeepNoneItem = keepNoneItem;
        final ComboBox comboBox = this.getComboBox();
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Item>(){

            public void customize(JList list, Item item, int index, boolean selected, boolean hasFocus) {
                if (item == null || item == ITEM_NONE) {
                    this.setText(WDBundle.message("empty.server", new Object[0]));
                    this.setToolTipText(null);
                } else {
                    item.render(this, WebServerCombo.this.myProject);
                }
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServerCombo.this.removeInvalidItems();
                WebServerCombo.this.updateTooltip();
                WebServerCombo.this.fireChanged();
            }
        });
        this.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebServerCombo.this.getSomeValidItem() == null) {
                    AddServerDialog d = new AddServerDialog((Component)((Object)WebServerCombo.this), WebServerCombo.this.myRemoteServersOnly, WebServerCombo.this.myProject);
                    if (d.showAndGet()) {
                        WebServerConfig newServer = d.getResult();
                        DeploymentConfigurable.show(newServer, true, WebServerCombo.this.myProject, 0);
                        WebServerConfig newSelection = WebServersConfigManager.getInstance(WebServerCombo.this.myProject).findServer(newServer.getId());
                        if (newSelection != null) {
                            WebServerCombo.this.selectServer(newSelection);
                        }
                        WebServerCombo.this.fireChanged();
                    }
                } else {
                    Item newSelection;
                    WebServerConfig currentSelection = WebServerCombo.this.getSelectedServer();
                    DeploymentConfigurable.show(currentSelection, false, WebServerCombo.this.myProject, WebServerCombo.this.myEditServerTab);
                    if (currentSelection == null && (newSelection = WebServerCombo.this.getSomeValidItem()) != null) {
                        comboBox.setSelectedItem((Object)newSelection);
                    }
                    WebServerCombo.this.fireChanged();
                }
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                WebServerCombo.this.reset(WebServerCombo.this.getSelectedIdAndName());
            }

            @Override
            public void optionsChanged() {
            }

            @Override
            public void excludedPathsChanged() {
            }
        });
    }

    private void fireChanged() {
        ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
    }

    private void updateTooltip() {
        Item selectedItem = this.getSelectedItem();
        if (selectedItem != null && !selectedItem.isValid()) {
            this.getComboBox().setToolTipText(selectedItem.getErrorMessage());
        } else {
            this.getComboBox().setToolTipText(null);
        }
    }

    public void setWebServerFilter(@Nullable Condition<WebServerConfig> webServerFilter) {
        this.myWebServerFilter = webServerFilter;
    }

    public void setProject(Project project) {
        this.myProject = project;
        this.myComparator = new ItemComparator(project);
    }

    public void selectServer(WebServerConfig select) {
        if (this.getSelectedServer() == select) {
            return;
        }
        for (int i = 0; i < this.getComboBox().getModel().getSize(); ++i) {
            Item item = (Item)this.getComboBox().getModel().getElementAt(i);
            if (item.server != select) continue;
            this.getComboBox().setSelectedItem((Object)item);
        }
    }

    public void reset(@Nullable Pair<String, String> selection) {
        ArrayList<Item> items = new ArrayList<Item>();
        if (this.myKeepNoneItem) {
            items.add(ITEM_NONE);
        }
        Item select = null;
        for (WebServerConfig server : WebServersConfigManager.getInstance(this.myProject).getServers(this.myRemoteServersOnly)) {
            if (this.myWebServerFilter != null && !this.myWebServerFilter.value((Object)server)) continue;
            Item item = new Item(server, true);
            items.add(item);
            if (selection == null || !server.getId().equals(selection.first)) continue;
            select = item;
        }
        if (selection == null && this.myKeepNoneItem) {
            select = ITEM_NONE;
        }
        if (select == null && selection != null && selection.second != null) {
            select = new Item((String)selection.second);
            items.add(select);
        }
        Collections.sort(items, this.myComparator);
        this.getComboBox().setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)select));
        this.updateTooltip();
    }

    @Nullable
    private Item getSelectedItem() {
        return (Item)this.getComboBox().getSelectedItem();
    }

    @Nullable
    public WebServerConfig getSelectedServer() {
        Item selectedItem = this.getSelectedItem();
        return selectedItem != null ? selectedItem.server : null;
    }

    @Nullable
    public Pair<String, String> getSelectedIdAndName() {
        Item selectedItem = this.getSelectedItem();
        return selectedItem != null ? selectedItem.getIdAndName() : null;
    }

    @Nullable
    public String getSelectedErrorMessage() {
        Item selectedItem = this.getSelectedItem();
        return selectedItem != null ? selectedItem.getErrorMessage() : null;
    }

    @Nullable
    private Item getSomeValidItem() {
        Item someItem = null;
        for (int i = 0; i < this.getComboBox().getModel().getSize(); ++i) {
            Item item = (Item)this.getComboBox().getModel().getElementAt(i);
            if (item.server == null) continue;
            if (Comparing.equal((String)((String)PublishConfig.getInstance((Project)this.myProject).getDefaultServerIdAndName().first), (String)item.server.getId())) {
                return item;
            }
            someItem = item;
        }
        return someItem;
    }

    public void addChangeListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public ComboBox getComboBox() {
        return (ComboBox)super.getComboBox();
    }

    private void removeInvalidItems() {
        Item newSelection = (Item)this.getComboBox().getSelectedItem();
        if (newSelection == null || newSelection.server == null) {
            return;
        }
        ArrayList<Item> newItems = new ArrayList<Item>();
        for (int i = 0; i < this.getComboBox().getModel().getSize(); ++i) {
            Item item = (Item)this.getComboBox().getModel().getElementAt(i);
            if (item.server == null && item != ITEM_NONE) continue;
            newItems.add(item);
        }
        Collections.sort(newItems, this.myComparator);
        this.getComboBox().setModel((ComboBoxModel)new CollectionComboBoxModel(newItems, (Object)newSelection));
    }

    private static class ItemComparator
    implements Comparator<Item> {
        private final PublishConfig myConfig;

        private ItemComparator(Project project) {
            this.myConfig = PublishConfig.getInstance(project);
        }

        @Override
        public int compare(Item o1, Item o2) {
            boolean isDefined2;
            boolean isDefined1 = o1.server != null;
            boolean bl = isDefined2 = o2.server != null;
            if (!isDefined1 && !isDefined2) {
                return o1.getServerName().compareTo(o2.getServerName());
            }
            if (!isDefined1) {
                return 1;
            }
            if (!isDefined2) {
                return -1;
            }
            return this.myConfig.compareServers(o1.server, o2.server);
        }
    }

    private static class Item {
        @Nullable
        public final WebServerConfig server;
        @Nullable
        private final String serverName;
        @Nullable
        private final String errorMessage;

        public Item(@NotNull WebServerConfig server, boolean validateUrl) {
            if (server == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/WebServerCombo$Item", "<init>"));
            }
            this.server = server;
            this.serverName = null;
            this.errorMessage = validateUrl ? server.validateFast() : server.getFileTransferConfig().validateFast();
        }

        public Item(@NotNull String serverName) {
            if (serverName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverName", "com/jetbrains/plugins/webDeployment/ui/WebServerCombo$Item", "<init>"));
            }
            this.server = null;
            this.serverName = serverName;
            this.errorMessage = WDBundle.message("server.not.exists", serverName);
        }

        @Nullable
        protected String getErrorMessage() {
            return this.errorMessage;
        }

        public void render(ListCellRendererWrapper wrapper, Project project) {
            PublishConfig config = PublishConfig.getInstance(project);
            if (config.isDefault(this.server)) {
                wrapper.setText("<html><b>" + StringUtil.escapeXml((String)this.getServerName()) + "</b></html>");
            } else {
                wrapper.setText(this.getServerName());
            }
            if (this.server == null) {
                wrapper.setIcon(UIUtil.getBalloonWarningIcon());
                wrapper.setToolTipText(this.getErrorMessage());
            } else {
                String msg = this.getErrorMessage();
                Icon icon = this.server.getFileTransferConfig().getIcon();
                if (msg != null) {
                    icon = new LayeredIcon(new Icon[]{icon, AllIcons.General.WarningDecorator});
                }
                wrapper.setIcon(icon);
                wrapper.setToolTipText(msg);
            }
            if (config.isConfigured(this.server, true)) {
                wrapper.setBackground(UiConstants.NodeAttributes.MAPPED_BACKGROUND);
            }
        }

        public String toString() {
            return this.getServerName();
        }

        public boolean isValid() {
            return this.getErrorMessage() == null;
        }

        public Pair<String, String> getIdAndName() {
            return Pair.create((Object)(this.server != null ? this.server.getId() : null), (Object)this.getServerName());
        }

        @NotNull
        public String getServerName() {
            String string = this.server != null ? this.server.getName() : this.serverName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/WebServerCombo$Item", "getServerName"));
            }
            return string;
        }
    }
}

