/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ThrowableComputable;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeViewOptions;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerTreeContext {
    private static final RemoteConnection DISPOSED = new RemoteConnection(null, null){

        @Override
        public void release() {
        }

        @Override
        public void releaseIfOpen() {
        }

        @Override
        public <T> T executeServerOperation(ThrowableComputable<T, FileSystemException> computable, @Nullable ProgressIndicator pi) throws FileSystemException {
            return (T)computable.compute();
        }

        @Override
        public RemoteConnection clone() {
            return this;
        }
    };
    final boolean myFoldersOnly;
    final FileTransferConfig.Origin myOrigin;
    final WebServerConfig myServer;
    @Nullable
    final PublishConfig myPublishConfig;
    @NotNull
    final ServerTreeViewOptions myViewOptions;
    private final AtomicReference<RemoteConnection> myConnection;
    @NotNull
    public final ConnectionOwner myConnectionOwner;

    public ServerTreeContext(boolean foldersOnly, WebServerConfig server, @Nullable PublishConfig publishConfig, ServerTreeViewOptions viewOptions, FileTransferConfig.Origin origin, @NotNull ConnectionOwner connectionOwner) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/ServerTreeContext", "<init>"));
        }
        this.myConnection = new AtomicReference();
        this.myFoldersOnly = foldersOnly;
        this.myServer = server;
        this.myPublishConfig = publishConfig;
        this.myViewOptions = viewOptions;
        this.myOrigin = origin;
        this.myConnectionOwner = connectionOwner;
    }

    public boolean isUnderMapping(WebServerConfig.RemotePath path) {
        return this.myPublishConfig != null && this.myPublishConfig.getNearestMappingDeploy2Local(path, false, this.myServer).getFirst() != null;
    }

    @Nullable
    public RemoteConnection getConnection() throws FileSystemException {
        RemoteConnection openConnection = this.getOpenConnection();
        if (openConnection != null) {
            return openConnection;
        }
        RemoteConnection newConnection = RemoteConnectionManager.getInstance().openConnection(this.myConnectionOwner, WDBundle.message("browse.server", this.myServer.getName()), this.myServer, this.myOrigin, null, null);
        if (this.myConnection.compareAndSet(null, newConnection)) {
            return newConnection;
        }
        newConnection.release();
        return null;
    }

    public void releaseConnectionIfOpen() {
        RemoteConnection openConnection = this.myConnection.getAndSet(DISPOSED);
        if (openConnection != null) {
            openConnection.releaseIfOpen();
        }
    }

    @Nullable
    public RemoteConnection getOpenConnection() {
        return this.myConnection.get();
    }

    public boolean isHidden(FileName name) {
        return this.myViewOptions.isHidden(name);
    }
}

