/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd;

import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ObjectUtils;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.WebServerTreeBuilder;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.DnDTask;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.MoveMessageDialog;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteMoveProvider {
    private static final Key<Collection<WebServerConfig.RemotePath>> REMOTE_PATHS_KEY = new Key("Deployment.dnd.remotePaths");
    private static final Key<ServerTree> REMOTE_SERVER_TREE_KEY = new Key("Deployment.dnd.remoteServerTree");

    private RemoteMoveProvider() {
    }

    public static boolean checkNotEmpty(ServerTreeNode[] nodesToMove, boolean rootAllowed) {
        if (nodesToMove == null || nodesToMove.length == 0) {
            return false;
        }
        if (rootAllowed) {
            return true;
        }
        for (ServerTreeNode selectedNode : nodesToMove) {
            if (!selectedNode.isRoot()) continue;
            return false;
        }
        return true;
    }

    public static boolean isRemoteTargetValid(@Nullable Collection<WebServerConfig.RemotePath> source, WebServerConfig.RemotePath targetNode, boolean isCaseSensitive) {
        if (source == null || source.isEmpty()) {
            return false;
        }
        for (WebServerConfig.RemotePath path : source) {
            if (!DeploymentPathUtils.isAncestor(path.path, targetNode.path, isCaseSensitive)) continue;
            return false;
        }
        return true;
    }

    public static String getFilesDescription(@NotNull Collection<FileObject> files, WebServerConfig server, boolean needQuotes, boolean remote) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/RemoteMoveProvider", "getFilesDescription"));
        }
        int size = files.size();
        if (size > 1) {
            return WDBundle.message("items", size, size);
        }
        return RemoteMoveProvider.getFileDescription(files.iterator().next(), server, needQuotes, remote);
    }

    public static String getFileDescription(@NotNull FileObject file, WebServerConfig server, boolean needQuotes, boolean remote) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/RemoteMoveProvider", "getFileDescription"));
        }
        String path = remote ? server.getPresentablePath(file) : DeploymentPathUtils.getLocalPath(file);
        return needQuotes ? "'" + path + "'" : path;
    }

    public static void performRemoteToRemotePaste(PsiElement elementWithData, ServerTreeNode targetNode) {
        ServerTree tree = (ServerTree)((Object)REMOTE_SERVER_TREE_KEY.get((UserDataHolder)elementWithData));
        if (tree == null) {
            return;
        }
        Collection paths = (Collection)REMOTE_PATHS_KEY.get((UserDataHolder)elementWithData);
        if (paths == null) {
            return;
        }
        RemoteMoveProvider.performRemoteToRemotePaste(paths, targetNode, tree, tree.getProject(), tree.getServer());
    }

    public static void performRemoteToRemotePaste(Collection<WebServerConfig.RemotePath> sourcePaths, ServerTreeNode targetNode, ServerTree tree, Project project, WebServerConfig serverConfig) {
        if (targetNode == null) {
            return;
        }
        if (!targetNode.isDirectory() && (targetNode = ServerTree.getServerTreeNode(tree.getPath((PresentableNodeDescriptor)targetNode).getParentPath())) == null) {
            return;
        }
        Collection<ServerTreeNode> sourceNodes = RemoteMoveProvider.getServerNodes(sourcePaths, (JTree)((Object)tree));
        if (sourceNodes.isEmpty()) {
            return;
        }
        FileObject targetFile = targetNode.getFileObject();
        ArrayList<FileObject> sourceFilesCollection = new ArrayList<FileObject>();
        for (ServerTreeNode node : sourceNodes) {
            sourceFilesCollection.add(node.getFileObject());
        }
        MoveMessageDialog d = new MoveMessageDialog((Component)((Object)tree), sourceFilesCollection, targetFile, serverConfig, sourceNodes.iterator().next().isDirectory(), true);
        if (!d.showAndGet()) {
            return;
        }
        new DnDTask(project, tree, serverConfig, sourceFilesCollection, targetFile, true, true, true).queue();
    }

    public static void performRemoteToLocalPaste(PsiElement fileWithData, PsiElement target, boolean moving) {
        ServerTree tree = (ServerTree)((Object)REMOTE_SERVER_TREE_KEY.get((UserDataHolder)fileWithData));
        if (tree == null) {
            return;
        }
        Collection paths = (Collection)REMOTE_PATHS_KEY.get((UserDataHolder)fileWithData);
        if (paths == null) {
            return;
        }
        if (target == null) {
            return;
        }
        PsiDirectory dir = null;
        if (target instanceof PsiDirectory) {
            dir = (PsiDirectory)target;
        } else {
            PsiFile file = target.getContainingFile();
            if (file != null) {
                dir = file.getContainingDirectory();
            }
        }
        if (dir == null) {
            return;
        }
        Collection<ServerTreeNode> sourceNodes = RemoteMoveProvider.getServerNodes(paths, (JTree)((Object)tree));
        if (sourceNodes.isEmpty()) {
            return;
        }
        FileObject targetFile = DeploymentPathUtils.getLocalFile(dir.getVirtualFile().getPath());
        ArrayList<FileObject> sourceFilesCollection = new ArrayList<FileObject>();
        for (ServerTreeNode node : sourceNodes) {
            sourceFilesCollection.add(node.getFileObject());
        }
        new DnDTask(tree.getProject(), tree, tree.getServer(), sourceFilesCollection, targetFile, true, false, moving).queue();
    }

    public static void performLocalToRemotePaste(Collection<VirtualFile> sourceFiles, ServerTreeNode targetNode, ServerTree tree, Project project, WebServerConfig serverConfig, boolean moving) {
        if (targetNode == null || sourceFiles.isEmpty()) {
            return;
        }
        if (!targetNode.isDirectory() && (targetNode = ServerTree.getServerTreeNode(tree.getPath((PresentableNodeDescriptor)targetNode).getParentPath())) == null) {
            return;
        }
        FileObject targetFile = targetNode.getFileObject();
        ArrayList<FileObject> sourceFilesCollection = new ArrayList<FileObject>();
        for (VirtualFile file : sourceFiles) {
            FileObject fileObject = DeploymentPathUtils.getLocalFile(file.getPath());
            if (fileObject == null) continue;
            sourceFilesCollection.add(fileObject);
        }
        MoveMessageDialog d = new MoveMessageDialog((Component)((Object)tree), sourceFilesCollection, targetFile, serverConfig, sourceFiles.iterator().next().isDirectory(), false);
        if (!d.showAndGet()) {
            return;
        }
        new DnDTask(project, tree, serverConfig, sourceFilesCollection, targetFile, false, true, moving).queue();
    }

    public static Collection<ServerTreeNode> getServerNodes(Collection<WebServerConfig.RemotePath> remotePaths, JTree tree) {
        LinkedList<ServerTreeNode> sourceNodes = new LinkedList<ServerTreeNode>();
        WebServerTreeBuilder webServerTreeBuilder = (WebServerTreeBuilder)AbstractTreeBuilder.getBuilderFor((JTree)tree);
        for (WebServerConfig.RemotePath sourcePath : remotePaths) {
            ServerTreeNode node = webServerTreeBuilder.findNode(sourcePath);
            if (node == null) continue;
            sourceNodes.add(node);
        }
        return sourceNodes;
    }

    public static boolean isValidLocalTarget(PsiElement psiElement, PsiElement[] sources) {
        if (!(psiElement instanceof PsiDirectory) && !(psiElement instanceof PsiFile)) {
            return false;
        }
        if (sources.length == 0 || sources[0].getProject() != psiElement.getProject()) {
            return false;
        }
        return RemoteMoveProvider.isValidRemoteSource(sources);
    }

    public static boolean isValidRemoteSource(PsiElement[] sources) {
        return sources.length == 1 && RemoteMoveProvider.getPaths(sources[0]) != null;
    }

    private static TreeNode[] getTreeNodes(ServerTree serverTree) {
        PsiElement element = RemoteMoveProvider.createPsiElementWithData(serverTree);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(element);
        return new TreeNode[]{node};
    }

    @NotNull
    static PsiElement createPsiElementWithData(ServerTree serverTree) {
        DistinctRootsCollections.ServerTreeNodes nodes = new DistinctRootsCollections.ServerTreeNodes(serverTree.getSelectedNodes(), serverTree.getServer().isCaseSensitive());
        ArrayList<WebServerConfig.RemotePath> paths = new ArrayList<WebServerConfig.RemotePath>();
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            ServerTreeNode node = (ServerTreeNode)((Object)iterator.next());
            paths.add(node.getPath());
        }
        Project project = serverTree.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("tempRemote", (Language)PlainTextLanguage.INSTANCE, (CharSequence)"");
        PsiElement element = PsiTreeUtil.firstChild((PsiElement)file);
        element.putUserData(REMOTE_PATHS_KEY, paths);
        element.putUserData(REMOTE_SERVER_TREE_KEY, (Object)serverTree);
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/RemoteMoveProvider", "createPsiElementWithData"));
        }
        return psiElement;
    }

    private static boolean isPsiFileFromRemoteHost(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/RemoteMoveProvider", "isPsiFileFromRemoteHost"));
        }
        return element.getUserData(REMOTE_PATHS_KEY) != null;
    }

    @Nullable
    public static PsiElement getPsiElementWithData(@Nullable boolean[] copied) {
        PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(copied);
        if (elements == null || elements.length != 1) {
            return null;
        }
        PsiElement element = elements[0];
        if (element.getUserData(REMOTE_PATHS_KEY) == null) {
            return null;
        }
        return element;
    }

    @Nullable
    public static PsiElement getCutPsiElementWithData() {
        boolean[] copied = new boolean[1];
        PsiElement element = RemoteMoveProvider.getPsiElementWithData(copied);
        if (copied[0]) {
            return null;
        }
        return element;
    }

    @Nullable
    public static Collection<WebServerConfig.RemotePath> getPaths(PsiElement fileWithData) {
        return (Collection)REMOTE_PATHS_KEY.get((UserDataHolder)fileWithData);
    }

    @Nullable
    public static ServerTree getTree(PsiElement elementWithData) {
        return (ServerTree)((Object)REMOTE_SERVER_TREE_KEY.get((UserDataHolder)elementWithData));
    }

    static boolean isFromRemotePasteEnabled(DataContext dataContext, boolean isToRemote) {
        PsiElement element = RemoteMoveProvider.getCutPsiElementWithData();
        if (element == null) {
            return false;
        }
        ServerTree tree = (ServerTree)((Object)REMOTE_SERVER_TREE_KEY.get((UserDataHolder)element));
        if (tree == null) {
            return false;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != element.getProject()) {
            return false;
        }
        Collection remoteSourcePaths = (Collection)REMOTE_PATHS_KEY.get((UserDataHolder)element);
        if (remoteSourcePaths == null || remoteSourcePaths.isEmpty()) {
            return false;
        }
        if (!isToRemote) {
            return true;
        }
        ServerTreeNode[] treeNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext);
        if (treeNodes == null || treeNodes.length != 1) {
            return false;
        }
        return RemoteMoveProvider.isRemoteTargetValid(remoteSourcePaths, treeNodes[0].getPath(), tree.getServer().isCaseSensitive());
    }

    @Nullable
    static TreeNode[] extractNodes(DnDEvent event) {
        Object attachedObject = event.getAttachedObject();
        if (!(attachedObject instanceof TransferableWrapper)) {
            return null;
        }
        return ((TransferableWrapper)attachedObject).getTreeNodes();
    }

    @Nullable
    public static Collection<WebServerConfig.RemotePath> extractPaths(TreeNode[] nodes, Project project) {
        if (nodes == null || nodes.length == 0 || !(nodes[0] instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)nodes[0]).getUserObject();
        if (!(userObject instanceof PsiElement)) {
            return null;
        }
        PsiElement element = (PsiElement)userObject;
        if (element.getProject() != project) {
            return null;
        }
        return (Collection)element.getUserData(REMOTE_PATHS_KEY);
    }

    @Nullable
    public static Collection<VirtualFile> extractVirtualFiles(TreeNode[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (TreeNode node : nodes) {
            if (!(node instanceof DefaultMutableTreeNode)) {
                return null;
            }
            PsiElement psiElement = (PsiElement)ObjectUtils.tryCast((Object)AbstractProjectViewPane.extractUserObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)node)), PsiElement.class);
            if (psiElement == null || RemoteMoveProvider.isPsiFileFromRemoteHost(psiElement)) {
                return null;
            }
            Object item = psiElement instanceof PsiFileSystemItem ? (PsiFileSystemItem)psiElement : psiElement.getContainingFile();
            VirtualFile file = PsiUtilBase.asVirtualFile((PsiElement)item);
            if (file == null || !file.isValid()) {
                return null;
            }
            result.add(file);
        }
        return result;
    }

    static DnDDragStartBean createDragBean(Point dragOrigin, final ServerTree tree) {
        TransferableWrapper wrapper = new TransferableWrapper(){

            @Nullable
            public TreeNode[] getTreeNodes() {
                return RemoteMoveProvider.getTreeNodes(tree);
            }

            @Nullable
            public PsiElement[] getPsiElements() {
                return new PsiElement[0];
            }

            @Nullable
            public List<File> asFileList() {
                return null;
            }
        };
        return new DnDDragStartBean((Object)wrapper, dragOrigin);
    }

    public static boolean isValidLocalSource(@Nullable Collection<VirtualFile> elements) {
        if (elements == null || elements.isEmpty()) {
            return false;
        }
        for (VirtualFile element : elements) {
            if (element.isInLocalFileSystem()) continue;
            return false;
        }
        return true;
    }
}

