/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudbees.cloud;

import com.intellij.javaee.cloudbees.cloud.CBDeploymentConfiguration;
import com.intellij.javaee.cloudbees.cloud.CBServerConfiguration;
import com.intellij.javaee.cloudbees.cloud.CBServerRuntimeInstance;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryDescription;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import com.intellij.util.ThrowableRunnable;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CBConnector
extends ServerConnector<CBDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance(CBConnector.class);
    public static final ClientLibraryDescription LIBRARY_DESCRIPTION = new ClientLibraryDescription("cloudbees", CBConnector.class.getResource("/resources/CBClientLib.xml"));
    private final CBServerConfiguration myConfiguration;
    private final ServerTaskExecutor myTasksExecutor;

    public CBConnector(@NotNull CBServerConfiguration configuration, @NotNull ServerTaskExecutor tasksExecutor) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javaee/cloudbees/cloud/CBConnector", "<init>"));
        }
        if (tasksExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasksExecutor", "com/intellij/javaee/cloudbees/cloud/CBConnector", "<init>"));
        }
        this.myConfiguration = configuration;
        this.myTasksExecutor = tasksExecutor;
    }

    public void connect(final @NotNull ServerConnector.ConnectionCallback<CBDeploymentConfiguration> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/cloudbees/cloud/CBConnector", "connect"));
        }
        this.myTasksExecutor.submit((ThrowableRunnable)new ThrowableRunnable<Throwable>(){

            public void run() throws Throwable {
                List libraryFiles;
                try {
                    libraryFiles = ClientLibraryManager.getInstance().download(LIBRARY_DESCRIPTION);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    callback.errorOccurred("Failed to download client libraries: " + e.getMessage());
                    return;
                }
                new CBServerRuntimeInstance(CBConnector.this.myConfiguration, CBConnector.this.myTasksExecutor, libraryFiles).connect((ServerConnector.ConnectionCallback<CBDeploymentConfiguration>)callback);
            }
        }, callback);
    }
}

