/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.actions.GwtCreateActionBase;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.module.model.GwtServlet;
import com.intellij.gwt.rpc.GwtServletUtil;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateGwtRemoteServiceAction
extends GwtCreateActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.actions.CreateGwtRemoteServiceAction");
    @NonNls
    private static final String QUALIFIED_SERVICE_NAME_PROPERTY = "QUALIFIED_SERVICE_NAME";
    @NonNls
    private static final String SERVICE_NAME_PROPERTY = "SERVICE_NAME";
    @NonNls
    private static final String SERVLET_PATH_PROPERTY = "SERVLET_PATH";
    @NonNls
    private static final String RELATIVE_PATH_PROPERTY = "RELATIVE_SERVLET_PATH";
    @NonNls
    private static final String SERVER_PACKAGE = "server";

    public CreateGwtRemoteServiceAction() {
        super(GwtBundle.message("new.service.menu.action.text", new Object[0]), GwtBundle.message("new.service.menu.action.description", new Object[0]));
    }

    @Override
    protected boolean requireGwtModule() {
        return true;
    }

    @Override
    protected String getDialogPrompt() {
        return GwtBundle.message("new.service.dlg.prompt", new Object[0]);
    }

    @Override
    protected String getDialogTitle() {
        return GwtBundle.message("new.service.dlg.title", new Object[0]);
    }

    @Override
    protected PsiFile[] getAffectedFiles(GwtModule gwtModule) {
        WebApp webApp;
        WebFacet webFacet;
        XmlFile xmlFile = gwtModule.getModuleXmlFile();
        if (xmlFile != null && (webFacet = WebUtil.getWebFacet((PsiElement)xmlFile)) != null && (webApp = webFacet.getRoot()) != null) {
            return new PsiFile[]{xmlFile, DomUtil.getFile((DomElement)webApp)};
        }
        return new PsiFile[]{xmlFile};
    }

    @Override
    @NotNull
    protected PsiElement[] doCreate(String serviceName, PsiDirectory directory, GwtModule gwtModule) throws Exception {
        WebApp webApp;
        ArrayList<PsiClass> res = new ArrayList<PsiClass>(0);
        String servletPath = GwtServletUtil.getDefaultServletPath(gwtModule, serviceName);
        GwtFacet gwtFacet = GwtFacet.getInstance(gwtModule);
        LOG.assertTrue(gwtFacet != null);
        String templateName = gwtFacet.getSdkVersion().getGwtServiceJavaTemplate();
        PsiClass serviceClass = CreateGwtRemoteServiceAction.createClassFromTemplate(directory, serviceName, templateName, SERVLET_PATH_PROPERTY, servletPath, RELATIVE_PATH_PROPERTY, servletPath.substring(1));
        res.add(serviceClass);
        res.add(CreateGwtRemoteServiceAction.createClassFromTemplate(directory, serviceName + "Async", "GwtAppServiceAsync.java", new Object[0]));
        PsiClass servletImpl = CreateGwtRemoteServiceAction.generateServletClass(serviceName, directory, gwtModule, serviceClass);
        if (servletImpl == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtRemoteServiceAction", "doCreate"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        XmlFile xml = gwtModule.getModuleXmlFile();
        if (xml == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtRemoteServiceAction", "doCreate"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        GwtServlet gwtServlet = gwtModule.addServlet();
        gwtServlet.getPath().setValue((Object)servletPath);
        gwtServlet.getServletClass().setValue((Object)servletImpl.getQualifiedName());
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)xml);
        if (webFacet != null && (webApp = webFacet.getRoot()) != null) {
            GwtServletUtil.registerServletForService(gwtFacet, gwtModule, webApp, servletImpl, serviceName);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(res);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtRemoteServiceAction", "doCreate"));
        }
        return psiElementArray;
    }

    protected String getCommandName() {
        return GwtBundle.message("new.service.command.name", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return GwtBundle.message("new.service.progress.text", newName);
    }

    @Nullable
    private static PsiClass generateServletClass(String name, PsiDirectory directory, GwtModule gwtModule, PsiClass serviceClass) throws IncorrectOperationException {
        VirtualFile dir = directory.getVirtualFile();
        ArrayList<String> pathFromClient = new ArrayList<String>();
        while (gwtModule.isSourceFile(dir)) {
            String dirName = dir.getName();
            if (!gwtModule.isSourceFile(dir = dir.getParent())) continue;
            pathFromClient.add(dirName);
        }
        Collections.reverse(pathFromClient);
        PsiDirectory serverDir = directory.getManager().findDirectory(dir);
        if (serverDir == null) {
            return null;
        }
        pathFromClient.add(0, SERVER_PACKAGE);
        for (String dirName : pathFromClient) {
            PsiDirectory nextDir = serverDir.findSubdirectory(dirName);
            if (nextDir == null) {
                nextDir = serverDir.createSubdirectory(dirName);
            }
            serverDir = nextDir;
        }
        return CreateGwtRemoteServiceAction.createClassFromTemplate(serverDir, name + "Impl", "GwtAppServiceImpl.java", SERVICE_NAME_PROPERTY, serviceClass.getName(), QUALIFIED_SERVICE_NAME_PROPERTY, serviceClass.getQualifiedName());
    }
}

