/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.actions.GwtCreateActionBase;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.ide.IdeView;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateGwtTestCaseAction
extends GwtCreateActionBase {
    @NonNls
    private static final String GWT_MODULE_PARAMETER = "GWT_MODULE_NAME";

    public CreateGwtTestCaseAction() {
        super(GwtBundle.message("action.name.create.gwt.test.case", new Object[0]), GwtBundle.message("action.description.creates.new.gwt.test.case", new Object[0]));
    }

    @Override
    @NotNull
    protected PsiElement[] doCreate(String newName, PsiDirectory directory, GwtModule gwtModule) throws Exception {
        Module module = gwtModule.getModule();
        if (module != null) {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            PsiClass testCaseClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("junit.framework.TestCase", scope);
            if (testCaseClass == null) {
                String url = VfsUtil.getUrlForLibraryRoot((File)new File(JavaSdkUtil.getJunit3JarPath()));
                ModuleRootModificationUtil.addModuleLibrary((Module)module, (String)url);
            }
        }
        PsiElement[] psiElementArray = new PsiElement[]{CreateGwtTestCaseAction.createClassFromTemplate(directory, newName, "GwtTestCase.java", GWT_MODULE_PARAMETER, gwtModule.getQualifiedName())};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtTestCaseAction", "doCreate"));
        }
        return psiElementArray;
    }

    protected boolean isAvailable(DataContext dataContext) {
        PsiDirectory[] directories;
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null || project == null) {
            return false;
        }
        for (PsiDirectory psiDirectory : directories = view.getDirectories()) {
            VirtualFile directory = psiDirectory.getVirtualFile();
            if (!ProjectRootsUtil.isInTestSource((VirtualFile)directory, (Project)project)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean requireGwtModule() {
        return true;
    }

    @Override
    protected String getDialogPrompt() {
        return GwtBundle.message("dialog.promt.enter.name.for.gwt.test.case", new Object[0]);
    }

    @Override
    protected String getDialogTitle() {
        return GwtBundle.message("dialog.title.new.gwt.test.case", new Object[0]);
    }

    protected String getCommandName() {
        return GwtBundle.message("command.name.create.gwt.test.case", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return GwtBundle.message("action.progress.creating.gwt.test.case.0", newName);
    }
}

