/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.gwt.inspections.GwtUiHandlerErrorsInspection;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenerateUiHandlerMethodHandler
extends GenerateMembersHandlerBase {
    public GenerateUiHandlerMethodHandler() {
        super("Choose Fields to Generate Handler for");
    }

    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        ArrayList<UiFieldClassMember> members = new ArrayList<UiFieldClassMember>();
        PsiClassType baseWidgetInterface = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createTypeByFQClassName("com.google.gwt.user.client.ui.IsWidget", aClass.getResolveScope());
        PsiClassType hasHandlersInterface = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createTypeByFQClassName("com.google.gwt.event.shared.HasHandlers", aClass.getResolveScope());
        for (PsiField field : aClass.getFields()) {
            PsiType type = field.getType();
            if (!UiBinderUtil.isUiField(field) || !TypeConversionUtil.isAssignable((PsiType)baseWidgetInterface, (PsiType)type) && !TypeConversionUtil.isAssignable((PsiType)hasHandlersInterface, (PsiType)type)) continue;
            members.add(new UiFieldClassMember(field));
        }
        return members.toArray(new ClassMember[members.size()]);
    }

    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        PsiClass gwtEventClass = JavaPsiFacade.getInstance((Project)project).findClass("com.google.gwt.event.shared.GwtEvent", aClass.getResolveScope());
        if (gwtEventClass == null) {
            Messages.showErrorDialog((Project)project, (String)"com.google.gwt.event.shared.GwtEvent class not found.", (String)CommonBundle.getErrorTitle());
            return null;
        }
        PsiTypeParameter[] typeParameters = gwtEventClass.getTypeParameters();
        if (typeParameters.length != 1) {
            Messages.showErrorDialog((Project)project, (String)"com.google.gwt.event.shared.GwtEvent class is strange.", (String)CommonBundle.getErrorTitle());
            return null;
        }
        ClassMember[] members = super.chooseOriginalMembers(aClass, project);
        if (members == null) {
            return null;
        }
        ArrayList<PsiType> fieldTypes = new ArrayList<PsiType>();
        for (ClassMember member : members) {
            fieldTypes.add(((PsiField)((UiFieldClassMember)member).getElement()).getType());
        }
        TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)project);
        TreeClassChooser chooser = factory.createNoInnerClassesScopeChooser("Select Event Type", aClass.getResolveScope(), (ClassFilter)new EventTypeFilter(gwtEventClass, typeParameters[0], fieldTypes), null);
        chooser.showDialog();
        PsiClass eventClass = chooser.getSelected();
        if (eventClass == null) {
            return null;
        }
        for (ClassMember member : members) {
            ((UiFieldClassMember)member).setEventClass(eventClass);
        }
        return members;
    }

    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        Project project = aClass.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiClass eventClass = ((UiFieldClassMember)members[0]).getEventClass();
        PsiMethod method = factory.createMethod("handle" + StringUtil.trimEnd((String)eventClass.getName(), (String)"Event"), (PsiType)PsiType.VOID);
        PsiModifierList modifierList = method.getModifierList();
        modifierList.setModifierProperty("private", false);
        StringBuilder annotationParameters = new StringBuilder();
        if (members.length == 1) {
            annotationParameters.append('\"').append(((PsiField)((UiFieldClassMember)members[0]).getElement()).getName()).append('\"');
        } else {
            annotationParameters.append('{');
            for (int i = 0; i < members.length; ++i) {
                if (i > 0) {
                    annotationParameters.append(',');
                }
                annotationParameters.append('\"').append(((PsiField)((UiFieldClassMember)members[i]).getElement()).getName()).append('\"');
            }
            annotationParameters.append('}');
        }
        PsiAnnotation annotation = factory.createAnnotationFromText("@com.google.gwt.uibinder.client.UiHandler(" + annotationParameters + ")", (PsiElement)aClass);
        PsiElement first = modifierList.getFirstChild();
        if (first != null) {
            modifierList.addBefore((PsiElement)annotation, first);
        } else {
            modifierList.add((PsiElement)annotation);
        }
        method.getParameterList().add((PsiElement)factory.createParameter("event", (PsiType)factory.createType(eventClass)));
        PsiMethod formatted = (PsiMethod)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)method);
        List<PsiGenerationInfo> list = Collections.singletonList(new PsiGenerationInfo((PsiMember)formatted));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/GenerateUiHandlerMethodHandler", "generateMemberPrototypes"));
        }
        return list;
    }

    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    private static class UiFieldClassMember
    extends PsiFieldMember {
        private PsiClass myEventClass;

        private UiFieldClassMember(PsiField field) {
            super(field);
        }

        public PsiClass getEventClass() {
            return this.myEventClass;
        }

        public void setEventClass(PsiClass eventClass) {
            this.myEventClass = eventClass;
        }
    }

    private static class EventTypeFilter
    implements ClassFilter {
        private final PsiClass myGwtEventClass;
        private final PsiTypeParameter myGwtEventTypeParameter;
        private final List<PsiType> myFieldTypes;
        private final PsiClassType myHandlerRegistrationType;

        public EventTypeFilter(PsiClass gwtEventClass, PsiTypeParameter typeParameter, List<PsiType> fieldTypes) {
            this.myGwtEventClass = gwtEventClass;
            this.myGwtEventTypeParameter = typeParameter;
            this.myFieldTypes = fieldTypes;
            this.myHandlerRegistrationType = JavaPsiFacade.getElementFactory((Project)this.myGwtEventClass.getProject()).createTypeByFQClassName("com.google.gwt.event.shared.HandlerRegistration", this.myGwtEventClass.getResolveScope());
        }

        public boolean isAccepted(PsiClass aClass) {
            if (!aClass.isInheritor(this.myGwtEventClass, true)) {
                return false;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.myGwtEventClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiType handlerType = substitutor.substitute(this.myGwtEventTypeParameter);
            if (handlerType == null || !(handlerType instanceof PsiClassType)) {
                return false;
            }
            PsiClass handlerClass = ((PsiClassType)handlerType).resolve();
            if (handlerClass == null || handlerClass instanceof PsiTypeParameter || handlerClass.getMethods().length != 1) {
                return false;
            }
            for (PsiType fieldType : this.myFieldTypes) {
                List<String> methods;
                if (!(fieldType instanceof PsiClassType) || (methods = GwtUiHandlerErrorsInspection.findAddHandlerMethods((PsiClassType)fieldType, handlerType, (PsiType)this.myHandlerRegistrationType)).size() == 1) continue;
                return false;
            }
            return true;
        }
    }
}

