/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle.css.language;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.gwt.clientBundle.css.language.psi.GwtCssExternal;
import com.intellij.gwt.clientBundle.css.language.psi.impl.GwtCssDeclarationElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssRulesetWrappingElement;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.formatter.FormatterUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GwtCssFormattingModelBuilder
extends CssFormattingModelBuilder {
    protected CssFormattingModelBuilder.CssFormattingExtension createExtension() {
        return new CssFormattingModelBuilder.CssFormattingExtension(){

            public boolean addSubBlocks(PsiElement element, CssCodeStyleSettings settings, int maxPropertyLength, List<Block> result) {
                ASTNode node = element.getNode();
                if (element instanceof GwtCssDeclarationElementBase || element instanceof GwtCssExternal) {
                    result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(node, settings, Indent.getNoneIndent(), maxPropertyLength, (CssFormattingModelBuilder.CssFormattingExtension)this));
                    return true;
                }
                if (element instanceof CssRulesetWrappingElement) {
                    result.add((Block)new RulesetWrapperElementBlock(node, settings, Indent.getNoneIndent(), maxPropertyLength, this));
                    return true;
                }
                return false;
            }
        };
    }

    private static class RulesetWrapperElementBlock
    extends CssFormattingModelBuilder.CssFormatterBlock {
        private ArrayList<Block> mySubBlocks;

        private RulesetWrapperElementBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
            super(_node, settings, indent, maxPropertyLength, extension);
        }

        @NotNull
        public List<Block> getSubBlocks() {
            if (this.mySubBlocks == null) {
                this.mySubBlocks = new ArrayList();
                this.myNode.getPsi().acceptChildren((PsiElementVisitor)new CssElementVisitor(){

                    public void visitCssRuleset(CssRuleset ruleset) {
                        RulesetWrapperElementBlock.this.mySubBlocks.add(new CssFormattingModelBuilder.CssRulesetBlock(ruleset.getNode(), RulesetWrapperElementBlock.this.getSettings(), Indent.getNormalIndent(), RulesetWrapperElementBlock.this.myMaxPropertyLength, RulesetWrapperElementBlock.this.myExtension, null));
                    }

                    public void visitCssRulesetList(CssRulesetList rulesetList) {
                        rulesetList.acceptChildren((PsiElementVisitor)this);
                    }

                    public void visitElement(PsiElement element) {
                        ASTNode node = element.getNode();
                        if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)node)) {
                            RulesetWrapperElementBlock.this.mySubBlocks.add(new CssFormattingModelBuilder.LeafBlock(node, Indent.getNoneIndent()));
                        }
                    }
                });
            }
            ArrayList<Block> arrayList = this.mySubBlocks;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/css/language/GwtCssFormattingModelBuilder$RulesetWrapperElementBlock", "getSubBlocks"));
            }
            return arrayList;
        }

        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/gwt/clientBundle/css/language/GwtCssFormattingModelBuilder$RulesetWrapperElementBlock", "getSpacing"));
            }
            return null;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/css/language/GwtCssFormattingModelBuilder$RulesetWrapperElementBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }
}

