/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.gwt.codeInsight.navigation.GutterIconMultipleNavigationHandler;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;

public class MultipleNavigationLineMarkerFactory {
    private MultipleNavigationLineMarkerFactory() {
    }

    public static <S extends NavigatablePsiElement> RelatedItemLineMarkerInfo<S> create(S element, TextRange range, Icon icon, List<? extends GotoRelatedItem> targets, GutterIconMultipleNavigationHandler<S> handler, int pass) {
        MultipleNavigationTooltipProvider<S> tooltipProvider = new MultipleNavigationTooltipProvider<S>(handler, element, targets);
        MultipleNavigationHandler<S> navigateHandler = new MultipleNavigationHandler<S>(handler, element, targets);
        return new RelatedItemLineMarkerInfo(element, range, icon, pass, tooltipProvider, navigateHandler, GutterIconRenderer.Alignment.CENTER, targets);
    }

    private static class MultipleNavigationTooltipProvider<S extends PsiElement>
    implements Function<S, String> {
        private final GutterIconMultipleNavigationHandler<S> myHandler;
        private final S mySource;
        private final List<? extends GotoRelatedItem> myTargets;

        public MultipleNavigationTooltipProvider(GutterIconMultipleNavigationHandler<S> handler, S source, List<? extends GotoRelatedItem> targets) {
            this.myHandler = handler;
            this.mySource = source;
            this.myTargets = targets;
        }

        public String fun(S s) {
            return this.myHandler.getGutterTooltip(this.mySource, this.myTargets);
        }
    }

    private static class MultipleNavigationHandler<S extends PsiElement>
    implements GutterIconNavigationHandler<S> {
        private final GutterIconMultipleNavigationHandler<S> myGutterIconNavigationHandler;
        private final S mySource;
        private final List<? extends GotoRelatedItem> myTargets;

        public MultipleNavigationHandler(GutterIconMultipleNavigationHandler<S> gutterIconNavigationHandler, S source, List<? extends GotoRelatedItem> targets) {
            this.myGutterIconNavigationHandler = gutterIconNavigationHandler;
            this.mySource = source;
            this.myTargets = targets;
        }

        public void navigate(MouseEvent e, S elt) {
            if (this.myTargets.size() == 1) {
                this.myTargets.get(0).navigate();
            } else {
                String title = this.myGutterIconNavigationHandler.getPopupChooserTitle(this.mySource, this.myTargets);
                JBPopup popup = NavigationUtil.getRelatedItemsPopup(this.myTargets, (String)title);
                popup.show(new RelativePoint(e));
            }
        }
    }
}

