/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.gwt.facet.GwtFacetEditor;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.gwt.sdk.GwtSdkType;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtJavaScriptOutputStyle;
import org.jetbrains.jps.gwt.model.impl.GwtModuleExtensionProperties;
import org.jetbrains.jps.gwt.model.impl.GwtModulePackagingProperties;

public class GwtFacetConfiguration
implements FacetConfiguration,
PersistentStateComponent<GwtModuleExtensionProperties> {
    private GwtModuleExtensionProperties myState = new GwtModuleExtensionProperties();
    private final Map<String, GwtModulePackagingProperties> myPackagingStates = new HashMap<String, GwtModulePackagingProperties>();

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        return new FacetEditorTab[]{new GwtFacetEditor(editorContext, validatorsManager, this)};
    }

    public void readExternal(Element element) throws InvalidDataException {
    }

    public void writeExternal(Element element) throws WriteExternalException {
    }

    public void loadState(GwtModuleExtensionProperties state) {
        this.myState = state;
        this.myPackagingStates.clear();
        for (GwtModulePackagingProperties packagingState : state.myPackagingStates) {
            this.myPackagingStates.put(packagingState.myName, packagingState);
        }
    }

    public GwtModuleExtensionProperties getState() {
        this.myState.myPackagingStates.clear();
        Object[] names = ArrayUtil.toStringArray(this.myPackagingStates.keySet());
        Arrays.sort(names);
        for (Object name : names) {
            GwtModulePackagingProperties packagingState = this.myPackagingStates.get(name);
            if (packagingState.myPath == null && packagingState.myEnabled) continue;
            this.myState.myPackagingStates.add(packagingState);
        }
        return this.myState;
    }

    public String getGwtSdkPath() {
        return FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)this.myState.mySdkUrl));
    }

    public void setGwtSdkUrlAndType(String gwtUrl) {
        this.setGwtSdkUrl(gwtUrl);
        GwtSdkType type = GwtSdkManager.getInstance().detectSdkType(this.myState.mySdkUrl);
        this.setGwtSdkType(type != null ? type.getId() : null);
    }

    public void setGwtSdkUrl(String gwtUrl) {
        this.myState.mySdkUrl = gwtUrl;
    }

    @NotNull
    public GwtSdk getSdk() {
        GwtSdk gwtSdk = GwtSdkManager.getInstance().getGwtSdk(this.getGwtSdkUrl(), this.getGwtSdkType());
        if (gwtSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetConfiguration", "getSdk"));
        }
        return gwtSdk;
    }

    public String getGwtSdkUrl() {
        return this.myState.mySdkUrl;
    }

    public String getGwtSdkType() {
        return this.myState.mySdkType;
    }

    public void setGwtSdkType(String gwtSdkType) {
        this.myState.mySdkType = gwtSdkType;
    }

    public String getCompilerParameters() {
        return this.myState.myCompilerParameters;
    }

    public void setCompilerParameters(String compilerParameters) {
        this.myState.myCompilerParameters = compilerParameters;
    }

    public String getAdditionalCompilerVMParameters() {
        return this.myState.myAdditionalCompilerVMParameters;
    }

    public void setAdditionalCompilerVMParameters(String additionalCompilerVMParameters) {
        this.myState.myAdditionalCompilerVMParameters = additionalCompilerVMParameters;
    }

    public int getCompilerMaxHeapSize() {
        return this.myState.myCompilerMaxHeapSize > 0 ? this.myState.myCompilerMaxHeapSize : 1024;
    }

    public void setCompilerMaxHeapSize(int compilerMaxHeapSize) {
        this.myState.myCompilerMaxHeapSize = compilerMaxHeapSize;
    }

    @NotNull
    public GwtJavaScriptOutputStyle getOutputStyle() {
        GwtJavaScriptOutputStyle gwtJavaScriptOutputStyle = this.myState.myOutputStyle != null ? this.myState.myOutputStyle : GwtJavaScriptOutputStyle.DETAILED;
        if (gwtJavaScriptOutputStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetConfiguration", "getOutputStyle"));
        }
        return gwtJavaScriptOutputStyle;
    }

    public void setOutputStyle(GwtJavaScriptOutputStyle outputStyle) {
        this.myState.myOutputStyle = outputStyle;
    }

    public void setWebFacetName(String webFacetName) {
        this.myState.myWebFacetName = webFacetName;
    }

    @Nullable
    public String getWebFacetName() {
        return this.myState.myWebFacetName;
    }

    @NotNull
    public String getPackagingRelativePath(@NotNull GwtModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/facet/GwtFacetConfiguration", "getPackagingRelativePath"));
        }
        GwtModulePackagingProperties state = this.myPackagingStates.get(module.getQualifiedName());
        if (state != null && state.myPath != null) {
            String string = state.myPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetConfiguration", "getPackagingRelativePath"));
            }
            return string;
        }
        String string = GwtFacetConfiguration.getDefaultPackagingPath(module);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtFacetConfiguration", "getPackagingRelativePath"));
        }
        return string;
    }

    public boolean isModuleCompilationEnabled(@NotNull GwtModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/facet/GwtFacetConfiguration", "isModuleCompilationEnabled"));
        }
        GwtModulePackagingProperties state = this.myPackagingStates.get(module.getQualifiedName());
        return state == null || state.myEnabled;
    }

    public static String getDefaultPackagingPath(GwtModule module) {
        return "/" + module.getOutputName();
    }

    public void setPackagingRelativePath(@NotNull String moduleName, @Nullable String path) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/gwt/facet/GwtFacetConfiguration", "setPackagingRelativePath"));
        }
        this.getOrCreateState((String)moduleName).myPath = path;
    }

    public void setModuleCompilationEnabled(@NotNull String moduleName, boolean enable) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/gwt/facet/GwtFacetConfiguration", "setModuleCompilationEnabled"));
        }
        this.getOrCreateState((String)moduleName).myEnabled = enable;
    }

    private GwtModulePackagingProperties getOrCreateState(String moduleName) {
        GwtModulePackagingProperties state = this.myPackagingStates.get(moduleName);
        if (state == null) {
            state = new GwtModulePackagingProperties();
            state.myName = moduleName;
            this.myPackagingStates.put(moduleName, state);
        }
        return state;
    }
}

