/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.CommonBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.rpc.GwtServletUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.web.GwtWebUtil;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class GwtSampleApplicationCreator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.facet.GwtSampleApplicationCreator");
    @NonNls
    private static final String WAR_STRING = "/war/";
    @NonNls
    private static final String JAVA_STRING = "/java/";
    private final GwtFacet myFacet;
    private final ModifiableRootModel myRootModel;
    private final String myAppName;
    private final Module myModule;
    private final String myAppPackageName;

    public GwtSampleApplicationCreator(GwtFacet facet, String qualifiedAppName, ModifiableRootModel rootModel) {
        this.myFacet = facet;
        this.myRootModel = rootModel;
        this.myAppName = StringUtil.getShortName((String)qualifiedAppName);
        String packageName = StringUtil.getPackageName((String)qualifiedAppName);
        this.myModule = this.myFacet.getModule();
        this.myAppPackageName = StringUtil.getQualifiedName((String)packageName, (String)StringUtil.decapitalize((String)this.myAppName));
    }

    public String getAppName() {
        return this.myAppName;
    }

    public void create() {
        final Ref exc = Ref.create(null);
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/facet/GwtSampleApplicationCreator$1", "run"));
                }
                try {
                    GwtSampleApplicationCreator.this.doCreate();
                }
                catch (IOException e) {
                    exc.set((Object)e);
                }
            }
        }.execute();
        if (!exc.isNull()) {
            LOG.info((Throwable)exc.get());
            Messages.showErrorDialog((String)("Cannot create sample GWT application: " + ((IOException)exc.get()).getMessage()), (String)CommonBundle.getErrorTitle());
        }
    }

    private void doCreate() throws IOException {
        ContentEntry[] contentEntries;
        VirtualFile contentRoot = null;
        VirtualFile sourceRoot = null;
        for (ContentEntry contentEntry : contentEntries = this.myRootModel.getContentEntries()) {
            String path;
            SourceFolder folder = (SourceFolder)ContainerUtil.getFirstItem((List)contentEntry.getSourceFolders((JpsModuleSourceRootType)JavaSourceRootType.SOURCE));
            if (folder == null) continue;
            contentRoot = GwtSampleApplicationCreator.getOrCreateContentRoot(contentEntry);
            sourceRoot = folder.getFile();
            if (sourceRoot != null || (sourceRoot = VfsUtil.createDirectoryIfMissing((String)(path = VfsUtil.urlToPath((String)folder.getUrl())))) != null) continue;
            throw new IOException("Cannot create source root " + path);
        }
        if (sourceRoot == null) {
            if (contentEntries.length == 0) {
                throw new IOException("Module does not have content roots");
            }
            ContentEntry entry = contentEntries[0];
            contentRoot = GwtSampleApplicationCreator.getOrCreateContentRoot(entry);
            sourceRoot = this.findOrCreateChildDirectory(contentRoot, "src");
            entry.addSourceFolder(sourceRoot, false);
        }
        VirtualFile javaDirectory = sourceRoot;
        for (String dirName : StringUtil.split((String)this.myAppPackageName, (String)".")) {
            javaDirectory = this.findOrCreateChildDirectory(javaDirectory, dirName);
        }
        final VirtualFile finalContentRoot = contentRoot;
        final VirtualFile finalJavaDirectory = javaDirectory;
        StartupManager.getInstance((Project)this.myModule.getProject()).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                new WriteCommandAction(GwtSampleApplicationCreator.this.myModule.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/facet/GwtSampleApplicationCreator$2$1", "run"));
                        }
                        GwtVersion gwtVersion = GwtSampleApplicationCreator.this.myFacet.getSdkVersion();
                        if (gwtVersion.isHostedModeRequiresWebXml() && GwtSampleApplicationCreator.this.myFacet.getWebFacet() == null) {
                            GwtWebUtil.createWebFacet(GwtSampleApplicationCreator.this.myFacet, finalContentRoot);
                        }
                        GwtSampleApplicationCreator.this.generateFiles(finalContentRoot, finalJavaDirectory, gwtVersion);
                    }
                }.execute();
            }
        });
    }

    @NotNull
    private static VirtualFile getOrCreateContentRoot(ContentEntry contentEntry) throws IOException {
        String path;
        VirtualFile contentRoot = contentEntry.getFile();
        if (contentRoot == null && (contentRoot = VfsUtil.createDirectoryIfMissing((String)(path = VfsUtil.urlToPath((String)contentEntry.getUrl())))) == null) {
            throw new IOException("Cannot create content root " + path);
        }
        VirtualFile virtualFile = contentRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/facet/GwtSampleApplicationCreator", "getOrCreateContentRoot"));
        }
        return virtualFile;
    }

    private void generateFiles(VirtualFile contentRoot, VirtualFile javaDirectory, GwtVersion gwtVersion) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("NAME", this.myAppName);
        properties.put("PACKAGE_NAME", this.myAppPackageName);
        properties.put("RELATIVE_SERVLET_PATH", this.myAppPackageName + "." + this.myAppName + "/" + this.myAppName + "Service");
        String serviceName = this.myAppName + "Service";
        properties.put("SHORT_SERVLET_PATH", serviceName);
        properties.put("GWT_MODULE_DOCTYPE", gwtVersion.getGwtModuleDocTypeString());
        Project project = this.myModule.getProject();
        GwtModule gwtModule = null;
        PsiClass servletImpl = null;
        for (String templatePath : this.myFacet.getSdkVersion().getGwtSampleAppTemplates()) {
            InputStream stream = this.getClass().getResourceAsStream(templatePath);
            LOG.assertTrue(stream != null, (Object)(templatePath + " template not found"));
            try {
                VirtualFile parent;
                String relativePath;
                String text = StreamUtil.readText((InputStream)stream);
                int i = templatePath.indexOf(JAVA_STRING);
                if (i != -1) {
                    relativePath = templatePath.substring(i + JAVA_STRING.length());
                    parent = javaDirectory;
                } else {
                    i = templatePath.indexOf(WAR_STRING);
                    relativePath = templatePath.substring(i + WAR_STRING.length());
                    LOG.assertTrue(i != -1, (Object)("incorrect template path: " + templatePath));
                    WebFacet webFacet = this.myFacet.getWebFacet();
                    LOG.assertTrue(webFacet != null);
                    List webRoots = webFacet.getWebRoots();
                    if (webRoots.isEmpty()) {
                        parent = this.findOrCreateChildDirectory(contentRoot, "web");
                        webFacet.addWebRoot(parent, "/");
                    } else {
                        parent = ((WebRoot)webRoots.get(0)).getFile();
                    }
                }
                String[] names = relativePath.split("\\/");
                for (int j = 0; j < names.length - 1; ++j) {
                    parent = this.findOrCreateChildDirectory(parent, names[j]);
                }
                String fileName = StringUtil.trimEnd((String)StringUtil.replace((String)names[names.length - 1], (String)"App", (String)this.myAppName), (String)".ft");
                VirtualFile file = parent.createChildData((Object)this, fileName);
                for (Map.Entry entry : properties.entrySet()) {
                    text = StringUtil.replace((String)text, (String)("${" + (String)entry.getKey() + "}"), (String)((String)entry.getValue()));
                }
                VfsUtil.saveText((VirtualFile)file, (String)text);
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
                if (fileName.endsWith(".gwt.xml")) {
                    gwtModule = GwtModulesManager.getInstance(project).getGwtModuleByXmlFile(psiFile);
                    continue;
                }
                if (!fileName.endsWith("ServiceImpl.java")) continue;
                servletImpl = ((PsiJavaFile)psiFile).getClasses()[0];
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myFacet.getSdkVersion().isHostedModeRequiresWebXml()) {
            String urlPattern = "/" + this.myAppName + "/" + serviceName;
            WebApp root = this.myFacet.getWebFacet().getRoot();
            if (root != null) {
                GwtServletUtil.registerServletForService(gwtModule, root, servletImpl, serviceName, urlPattern);
            }
        }
    }

    private VirtualFile findOrCreateChildDirectory(VirtualFile parent, String name) throws IOException {
        VirtualFile child = parent.findChild(name);
        if (child != null) {
            return child;
        }
        return parent.createChildDirectory((Object)this, name);
    }
}

