/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateCssClassLocalQuickFix
extends BaseGwtLocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.CreateCssClassLocalQuickFix");
    private final CssFile myCssFile;
    private final String myClassName;

    public CreateCssClassLocalQuickFix(CssFile cssFile, String className) {
        super(GwtBundle.message("quick.fix.create.css.class.name", className));
        this.myCssFile = cssFile;
        this.myClassName = className;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/CreateCssClassLocalQuickFix", "applyFix"));
        }
        VirtualFile virtualFile = this.myCssFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{virtualFile}).hasReadonlyFiles()) {
            return;
        }
        try {
            CssStylesheet stylesheet = this.myCssFile.getStylesheet();
            CssRuleset cssRuleset = CssElementFactory.getInstance((Project)project).createRuleset("." + this.myClassName + "{\n\n}\n", this.myCssFile.getFileType());
            stylesheet.addRuleset(cssRuleset);
            CssRuleset[] rulesets = stylesheet.getRulesets();
            CssRuleset added = rulesets[rulesets.length - 1];
            OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, virtualFile, added.getBlock().getTextOffset());
            FileEditorManager.getInstance((Project)project).openEditor(fileDescriptor, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

