/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.rpc.GwtGenericsUtil;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtObsoleteTypeArgsJavadocTagInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtObsoleteTypeArgsJavadocTagInspection");

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtObsoleteTypeArgsJavadocTagInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtObsoleteTypeArgsJavadocTagInspection", "checkClass"));
        }
        GwtFacet gwtFacet = GwtObsoleteTypeArgsJavadocTagInspection.getFacet((PsiElement)aClass);
        if (gwtFacet == null || !gwtFacet.getSdkVersion().isGenericsSupported()) {
            return null;
        }
        if (RemoteServiceUtil.isRemoteServiceInterface(aClass)) {
            return GwtObsoleteTypeArgsJavadocTagInspection.checkRemoteServiceInterface(aClass, manager, gwtFacet.getSdkVersion(), isOnTheFly);
        }
        return null;
    }

    private static ProblemDescriptor[] checkRemoteServiceInterface(PsiClass aClass, InspectionManager manager, GwtVersion gwtVersion, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (PsiMethod method : aClass.getMethods()) {
            PsiDocTag[] tags;
            PsiDocComment comment = method.getDocComment();
            if (comment == null || (tags = comment.findTagsByName("gwt.typeArgs")).length <= 0) continue;
            GenerifyServiceMethodFix fix = new GenerifyServiceMethodFix(method, gwtVersion);
            String message = GwtBundle.message("problem.description.gwt.type.args.tag.is.obsolete.in.gwt.1.5", new Object[0]);
            problems.add(manager.createProblemDescriptor((PsiElement)comment, message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.obsolete.gwt.type.args.tag.in.javadoc.comments", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtObsoleteTypeArgsJavadocTagInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtObsoleteTypeArgsJavadocTagInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getShortName() {
        if ("GwtObsoleteTypeArgsJavadocTag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtObsoleteTypeArgsJavadocTagInspection", "getShortName"));
        }
        return "GwtObsoleteTypeArgsJavadocTag";
    }

    private static class GenerifyServiceMethodFix
    extends BaseGwtLocalQuickFix {
        private final PsiMethod myMethod;
        private final GwtVersion myGwtVersion;

        protected GenerifyServiceMethodFix(PsiMethod method, GwtVersion gwtVersion) {
            super(GwtBundle.message("quickfix.name.generify.types.in.method.0.instead.of.using.gwt.type.args.tags", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2)));
            this.myMethod = method;
            this.myGwtVersion = gwtVersion;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtObsoleteTypeArgsJavadocTagInspection$GenerifyServiceMethodFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtObsoleteTypeArgsJavadocTagInspection$GenerifyServiceMethodFix", "applyFix"));
            }
            try {
                String returnTypeParameters = GwtGenericsUtil.getReturnTypeParametersString(this.myMethod);
                PsiType newReturnType = returnTypeParameters != null ? GenerifyServiceMethodFix.appendTypeParameters(this.myMethod.getReturnType(), returnTypeParameters, (PsiElement)this.myMethod) : null;
                TIntObjectHashMap newParameterTypes = new TIntObjectHashMap();
                PsiParameter[] parameters = this.myMethod.getParameterList().getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    PsiParameter parameter = parameters[i];
                    String typeParametersString = GwtGenericsUtil.getTypeParametersString(this.myMethod, parameter.getName());
                    if (typeParametersString == null) continue;
                    PsiType type = GenerifyServiceMethodFix.appendTypeParameters(parameter.getType(), typeParametersString, (PsiElement)this.myMethod);
                    newParameterTypes.put(i, (Object)type);
                }
                if (newReturnType == null && newParameterTypes.isEmpty()) {
                    return;
                }
                List<PsiMethod> methods = this.findImplementations(project);
                if (methods == null) {
                    return;
                }
                methods.add(0, this.myMethod);
                HashSet<VirtualFile> affectedFiles = new HashSet<VirtualFile>();
                for (PsiMethod method : methods) {
                    affectedFiles.add(method.getContainingFile().getVirtualFile());
                }
                PsiClass async = RemoteServiceUtil.findAsynchronousInterface(this.myMethod.getContainingClass());
                PsiMethod asyncMethod = null;
                if (async != null) {
                    asyncMethod = RemoteServiceUtil.findAsynchronousMethod(this.myMethod);
                    affectedFiles.add(async.getContainingFile().getVirtualFile());
                }
                if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(VfsUtil.toVirtualFileArray(affectedFiles)).hasReadonlyFiles()) {
                    return;
                }
                SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)this.myMethod);
                for (PsiMethod method : methods) {
                    GenerifyServiceMethodFix.updateSignature(method, newReturnType, (TIntObjectHashMap<PsiType>)newParameterTypes);
                }
                PsiMethod newMethod = (PsiMethod)pointer.getElement();
                if (newMethod != null) {
                    if (asyncMethod != null) {
                        asyncMethod.delete();
                        RemoteServiceUtil.copyMethodToAsync(newMethod, async, this.myGwtVersion);
                    }
                    GwtGenericsUtil.removeTypeArgsJavadocTags(newMethod);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static void updateSignature(PsiMethod method, PsiType newReturnType, TIntObjectHashMap<PsiType> newParameterTypes) throws IncorrectOperationException {
            PsiTypeElement returnTypeElement;
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
            if (newReturnType != null && (returnTypeElement = method.getReturnTypeElement()) != null) {
                returnTypeElement.replace((PsiElement)elementFactory.createTypeElement(newReturnType));
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            for (int i : newParameterTypes.keys()) {
                parameters[i].getTypeElement().replace((PsiElement)elementFactory.createTypeElement((PsiType)newParameterTypes.get(i)));
            }
        }

        @Nullable
        private List<PsiMethod> findImplementations(Project project) {
            final ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    Collection elements = DefinitionsScopedSearch.search((PsiElement)GenerifyServiceMethodFix.this.myMethod).findAll();
                    for (PsiElement element : elements) {
                        if (!(element instanceof PsiMethod)) continue;
                        methods.add((PsiMethod)element);
                    }
                }
            }, GwtBundle.message("gwt.searching.for.implementations", new Object[0]), true, project)) {
                return null;
            }
            return methods;
        }

        private static PsiType appendTypeParameters(@NotNull PsiType type, @NotNull String typeParametersString, @NotNull PsiElement context) throws IncorrectOperationException {
            PsiClassType classType;
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/gwt/inspections/GwtObsoleteTypeArgsJavadocTagInspection$GenerifyServiceMethodFix", "appendTypeParameters"));
            }
            if (typeParametersString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParametersString", "com/intellij/gwt/inspections/GwtObsoleteTypeArgsJavadocTagInspection$GenerifyServiceMethodFix", "appendTypeParameters"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/inspections/GwtObsoleteTypeArgsJavadocTagInspection$GenerifyServiceMethodFix", "appendTypeParameters"));
            }
            if (type instanceof PsiClassType && (classType = (PsiClassType)type).isRaw()) {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
                return elementFactory.createTypeFromText(type.getCanonicalText() + typeParametersString, context);
            }
            return type;
        }
    }
}

