/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.references.GwtToHtmlTagReference;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtToHtmlTagReferencesInspection
extends BaseGwtInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/gwt/inspections/GwtToHtmlTagReferencesInspection", "buildVisitor"));
        }
        if (!GwtToHtmlTagReferencesInspection.hasGwtFacets(holder.getManager().getProject())) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtToHtmlTagReferencesInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                PsiReference[] references;
                for (PsiReference reference : references = expression.getReferences()) {
                    if (!(reference instanceof GwtToHtmlTagReference) || reference.resolve() != null) continue;
                    holder.registerProblem((PsiElement)expression, GwtBundle.message("problem.description.html.tag.with.id.0.is.not.found", expression.getValue()), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtToHtmlTagReferencesInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.unresolved.references.to.html.tags", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtToHtmlTagReferencesInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("GwtToHtmlReferences" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtToHtmlTagReferencesInspection", "getShortName"));
        }
        return "GwtToHtmlReferences";
    }
}

