/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodCallPattern;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantSetServiceEntryPointMethodCallsInspection
extends BaseGwtInspection {
    private static final Key<String> SERVICE_PATH_KEY = Key.create((String)"GWT_SERVICE_PATH");
    private static final Key<PsiClass> GWT_ASYNC_SERVICE_CLASS_KEY = Key.create((String)"GWT_ASYNC_SERVICE_CLASS");
    private static final PsiMethodCallPattern SET_SERVICE_ENTRY_POINTS_CALL_PATTERN;

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/RedundantSetServiceEntryPointMethodCallsInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/RedundantSetServiceEntryPointMethodCallsInspection", "checkFile"));
        }
        GwtFacet facet = RedundantSetServiceEntryPointMethodCallsInspection.getFacet((PsiElement)file);
        if (facet == null || !facet.getSdkVersion().isGenericsSupported()) {
            return null;
        }
        final ArrayList problems = new ArrayList();
        file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitDocComment(PsiDocComment comment) {
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                ProcessingContext context = new ProcessingContext();
                if (SET_SERVICE_ENTRY_POINTS_CALL_PATTERN.accepts((Object)expression, context)) {
                    String servicePath = (String)context.get(SERVICE_PATH_KEY);
                    PsiClass asyncInterface = (PsiClass)context.get(GWT_ASYNC_SERVICE_CLASS_KEY);
                    PsiClass serviceInterface = RemoteServiceUtil.findSynchronousInterface(asyncInterface);
                    if (serviceInterface != null) {
                        RedundantSetServiceEntryPointMethodCallsInspection.checkSetServiceEntryPointCall(expression, servicePath, serviceInterface, problems, manager, isOnTheFly);
                    }
                }
                super.visitMethodCallExpression(expression);
            }
        });
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkSetServiceEntryPointCall(PsiMethodCallExpression expression, String servicePath, PsiClass serviceInterface, List<ProblemDescriptor> problems, InspectionManager manager, boolean onTheFly) {
        PsiAnnotation annotation;
        String message = GwtBundle.message("error.message.set.service.entry.point.method.call.can.be.replaced.by.remote.service.relative.path.annotation", new Object[0]);
        PsiModifierList list = serviceInterface.getModifierList();
        boolean addAnnotation = true;
        if (list != null && (annotation = list.findAnnotation("com.google.gwt.user.client.rpc.RemoteServiceRelativePath")) != null) {
            PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
            if (attributes.length != 1) return;
            PsiAnnotationMemberValue value = attributes[0].getValue();
            if (!(value instanceof PsiLiteralExpression) || !servicePath.equals(((PsiLiteralExpression)value).getValue())) return;
            message = GwtBundle.message("error.message.set.service.entry.point.method.call.is.redundant", new Object[0]);
            addAnnotation = false;
        }
        ReplaceByAnnotationQuickFix fix = new ReplaceByAnnotationQuickFix(expression, addAnnotation, serviceInterface, servicePath);
        problems.add(manager.createProblemDescriptor((PsiElement)expression, message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.redundant.set.service.entry.point.methods.calls", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/RedundantSetServiceEntryPointMethodCallsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GwtSetServiceEntryPointCalls" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/RedundantSetServiceEntryPointMethodCallsInspection", "getShortName"));
        }
        return "GwtSetServiceEntryPointCalls";
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/RedundantSetServiceEntryPointMethodCallsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    static {
        PsiMethodPattern setEntryPointMethod = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("setServiceEntryPoint")).definedInClass("com.google.gwt.user.client.rpc.ServiceDefTarget");
        PsiMethodCallPattern getModuleBaseUrlCall = PsiJavaPatterns.psiExpression().methodCall((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("getModuleBaseURL")).definedInClass("com.google.gwt.core.client.GWT"));
        SET_SERVICE_ENTRY_POINTS_CALL_PATTERN = (PsiMethodCallPattern)PsiJavaPatterns.psiExpression().methodCall((ElementPattern)setEntryPointMethod).withArguments(new ElementPattern[]{PsiJavaPatterns.psiBinaryExpression().operation((ElementPattern)PsiJavaPatterns.psiElement((IElementType)JavaTokenType.PLUS)).left((ElementPattern)getModuleBaseUrlCall).right((ElementPattern)PsiJavaPatterns.literalExpression((ElementPattern)PsiJavaPatterns.string().save(SERVICE_PATH_KEY)))}).withQualifier((ElementPattern)PsiJavaPatterns.psiExpression().skipParentheses((ElementPattern)PsiJavaPatterns.psiTypeCastExpression().withOperand((ElementPattern)PsiJavaPatterns.psiExpression().ofType((ElementPattern)PsiJavaPatterns.psiType().classType((ElementPattern)PsiJavaPatterns.psiClass().save(GWT_ASYNC_SERVICE_CLASS_KEY)))))).withParent((ElementPattern)PsiJavaPatterns.psiExpressionStatement());
    }

    private static class ReplaceByAnnotationQuickFix
    extends BaseGwtLocalQuickFix {
        private final PsiMethodCallExpression myExpression;
        private final boolean myAddAnnotation;
        private final PsiClass myServiceInterface;
        private final String myServicePath;

        private ReplaceByAnnotationQuickFix(PsiMethodCallExpression expression, boolean addAnnotation, PsiClass serviceInterface, String servicePath) {
            super(addAnnotation ? GwtBundle.message("quickfix.name.replace.set.service.entry.point.call.by.annotation", new Object[0]) : GwtBundle.message("quickfix.name.remove.redundant.set.service.entry.point.call", new Object[0]));
            this.myExpression = expression;
            this.myAddAnnotation = addAnnotation;
            this.myServiceInterface = serviceInterface;
            this.myServicePath = servicePath;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/RedundantSetServiceEntryPointMethodCallsInspection$ReplaceByAnnotationQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/RedundantSetServiceEntryPointMethodCallsInspection$ReplaceByAnnotationQuickFix", "applyFix"));
            }
            if (this.myAddAnnotation && ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{this.myServiceInterface.getContainingFile().getVirtualFile()}).hasReadonlyFiles()) {
                return;
            }
            this.myExpression.getParent().delete();
            if (this.myAddAnnotation) {
                String annotationText = "@com.google.gwt.user.client.rpc.RemoteServiceRelativePath(\"" + this.myServicePath + "\")";
                PsiAnnotation annotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(annotationText, (PsiElement)this.myServiceInterface);
                PsiModifierList modifierList = this.myServiceInterface.getModifierList();
                if (modifierList != null) {
                    PsiElement added = modifierList.addBefore((PsiElement)annotation, modifierList.getFirstChild());
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(added);
                }
            }
        }
    }
}

