/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.codeInsight.GwtMethodGenerationUtil;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.inspections.CreateCssClassLocalQuickFix;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.declarations.UiStyleElement;
import com.intellij.gwt.uiBinder.references.QualifiedUiXmlReference;
import com.intellij.gwt.uiBinder.references.UiXmlVariableReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UiXmlUnresolvedReferencesInspection
extends BaseGwtInspection {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/UiXmlUnresolvedReferencesInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/UiXmlUnresolvedReferencesInspection", "checkFile"));
        }
        if (!UiXmlUnresolvedReferencesInspection.shouldCheck((PsiElement)file)) {
            return null;
        }
        if (file instanceof XmlFile && UiBinderUtil.isUiXmlFile((XmlFile)file)) {
            SmartList problems = new SmartList();
            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((List)problems, manager, isOnTheFly){
                final /* synthetic */ List val$problems;
                final /* synthetic */ InspectionManager val$manager;
                final /* synthetic */ boolean val$isOnTheFly;
                {
                    this.val$problems = list;
                    this.val$manager = inspectionManager;
                    this.val$isOnTheFly = bl;
                }

                public void visitXmlAttributeValue(XmlAttributeValue value) {
                    UiXmlUnresolvedReferencesInspection.checkReferences(value, this.val$problems, this.val$manager, this.val$isOnTheFly);
                }
            });
            return problems.toArray(new ProblemDescriptor[problems.size()]);
        }
        return null;
    }

    private static void checkReferences(XmlAttributeValue value, List<ProblemDescriptor> problems, InspectionManager manager, boolean isOnTheFly) {
        for (PsiReference reference : value.getReferences()) {
            if (reference instanceof QualifiedUiXmlReference) {
                QualifiedUiXmlReference classRef = (QualifiedUiXmlReference)reference;
                if (classRef.multiResolve(false).length > 0) continue;
                PsiClass qualifierClass = PsiTypesUtil.getPsiClass((PsiType)classRef.getQualifierReference().resolveVariableType());
                String lastName = classRef.getValue();
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                UiStyleElement styleElement = classRef.findStyleElement();
                if (styleElement != null) {
                    CssFile cssFile = styleElement.getCssFile();
                    if (cssFile != null) {
                        fixes = new LocalQuickFix[]{new CreateCssClassLocalQuickFix(cssFile, lastName)};
                    }
                } else if (qualifierClass != null) {
                    fixes = new LocalQuickFix[]{new CreateMissingMethodQuickFix(qualifierClass, lastName)};
                }
                String message = qualifierClass != null ? GwtBundle.message("problem.description.cannot.resolve.symbol.0.in.1", lastName, qualifierClass.getName()) : GwtBundle.message("problem.description.cannot.resolve.0", lastName);
                problems.add(manager.createProblemDescriptor((PsiElement)value, classRef.getRangeInElement(), message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly, fixes));
                continue;
            }
            if (!(reference instanceof UiXmlVariableReference) || reference.resolve() != null) continue;
            UiXmlVariableReference variableReference = (UiXmlVariableReference)reference;
            String message = GwtBundle.message("problem.description.cannot.resolve.0", variableReference.getValue());
            problems.add(manager.createProblemDescriptor((PsiElement)value, reference.getRangeInElement(), message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly, new LocalQuickFix[0]));
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.unresolved.references.in.ui.xml.files", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/UiXmlUnresolvedReferencesInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GwtUiXmlReferences" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/UiXmlUnresolvedReferencesInspection", "getShortName"));
        }
        return "GwtUiXmlReferences";
    }

    private static class CreateMissingMethodQuickFix
    extends BaseGwtLocalQuickFix {
        private final PsiClass myPsiClass;
        private final String myMethodName;

        private CreateMissingMethodQuickFix(PsiClass psiClass, String methodName) {
            super("Create '" + methodName + "' method");
            this.myPsiClass = psiClass;
            this.myMethodName = methodName;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/UiXmlUnresolvedReferencesInspection$CreateMissingMethodQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/UiXmlUnresolvedReferencesInspection$CreateMissingMethodQuickFix", "applyFix"));
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myPsiClass.getContainingFile())) {
                return;
            }
            PsiMethod method = GwtMethodGenerationUtil.addStringMethod(this.myPsiClass, this.myMethodName);
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)method);
        }
    }
}

