/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.rpc;

import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtSerializableUtil {
    @NonNls
    private static final Set<String> STANDARD_SERIALIZABLE_CLASSES = new HashSet<String>(Arrays.asList("java.util.Date", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String"));
    @NonNls
    private static final Set<String> COLLECTION_CLASSES = new HashSet<String>(Arrays.asList("java.util.Vector", "java.util.Stack", "java.util.List", "java.util.Collection", "java.util.ArrayList", "java.util.Map", "java.util.Set", "java.util.HashMap", "java.util.HashSet"));
    @NonNls
    private static final String IS_SERIALIZABLE_INTERFACE_NAME = "com.google.gwt.user.client.rpc.IsSerializable";

    private GwtSerializableUtil() {
    }

    public static SerializableChecker createSerializableChecker(GwtFacet facet, boolean checkInterfaces) {
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)facet.getModule());
        return new SerializableChecker(facet.getSdkVersion(), scope, JavaPsiFacade.getInstance((Project)facet.getModule().getProject()), checkInterfaces);
    }

    public static boolean isCollection(PsiType type) {
        return COLLECTION_CLASSES.contains(TypeConversionUtil.erasure((PsiType)type).getCanonicalText());
    }

    public static boolean hasPublicNoArgConstructor(PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        PsiMethod constructor = GwtSerializableUtil.findNoArgConstructor(aClass);
        return constructor != null && constructor.hasModifierProperty("public");
    }

    @Nullable
    public static PsiMethod findNoArgConstructor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/rpc/GwtSerializableUtil", "findNoArgConstructor"));
        }
        for (PsiMethod constructor : psiClass.getConstructors()) {
            if (constructor.getParameterList().getParametersCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    public static class SerializableChecker {
        private final List<PsiClassType> mySerializableMarkerTypes;
        private final List<PsiClass> mySerializableMarkerInterfaces;
        private final GwtVersion myVersion;
        private final boolean myCheckInterfaces;
        private final PsiClass myIsSerializableInterface;

        private SerializableChecker(GwtVersion version, GlobalSearchScope scope, JavaPsiFacade javaPsiFacade, boolean checkInterfaces) {
            this.myVersion = version;
            this.myCheckInterfaces = checkInterfaces;
            PsiClass class1 = this.myIsSerializableInterface = javaPsiFacade.findClass(GwtSerializableUtil.IS_SERIALIZABLE_INTERFACE_NAME, scope);
            PsiClass class2 = null;
            if (version.isJavaIoSerializableSupported()) {
                class2 = javaPsiFacade.findClass(Serializable.class.getName(), scope);
            }
            this.mySerializableMarkerInterfaces = ContainerUtil.packNullables((Object[])new PsiClass[]{class1, class2});
            this.mySerializableMarkerTypes = new ArrayList<PsiClassType>();
            for (PsiClass anInterface : this.mySerializableMarkerInterfaces) {
                this.mySerializableMarkerTypes.add(javaPsiFacade.getElementFactory().createType(anInterface));
            }
        }

        public GwtVersion getVersion() {
            return this.myVersion;
        }

        public List<PsiClass> getSerializableMarkerInterfaces() {
            return this.mySerializableMarkerInterfaces;
        }

        public boolean isSerializable(PsiType type) {
            return this.isSerializable(type, Collections.<PsiType>emptyList());
        }

        public boolean isSerializable(PsiType type, List<PsiType> typeParameters) {
            PsiClass psiClass;
            if (type instanceof PsiPrimitiveType) {
                return true;
            }
            if (type instanceof PsiArrayType) {
                return this.isSerializable(((PsiArrayType)type).getComponentType(), typeParameters);
            }
            if (STANDARD_SERIALIZABLE_CLASSES.contains(type.getCanonicalText())) {
                return true;
            }
            if (GwtSerializableUtil.isCollection(type)) {
                PsiType[] parameters;
                if (this.myVersion.isGenericsSupported() && type instanceof PsiClassType && (parameters = ((PsiClassType)type).getParameters()).length > 0) {
                    boolean serializable = true;
                    for (PsiType parameter : parameters) {
                        serializable &= this.isSerializable(parameter);
                    }
                    if (serializable) {
                        return true;
                    }
                }
                if (!typeParameters.isEmpty() && this.isSerializableTypes(typeParameters)) {
                    return true;
                }
            }
            for (PsiClassType psiClassType : this.mySerializableMarkerTypes) {
                if (!psiClassType.isAssignableFrom(type)) continue;
                return true;
            }
            return type instanceof PsiClassType && ((psiClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter || !this.myCheckInterfaces && psiClass != null && psiClass.isInterface());
        }

        private boolean isSerializableTypes(List<PsiType> typeParameters) {
            for (PsiType type : typeParameters) {
                if (this.isSerializable(type)) continue;
                return false;
            }
            return true;
        }

        public boolean isGwtSerializable(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/rpc/GwtSerializableUtil$SerializableChecker", "isGwtSerializable"));
            }
            return this.myIsSerializableInterface != null && psiClass.isInheritor(this.myIsSerializableInterface, true);
        }

        public boolean isMarkedSerializable(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/rpc/GwtSerializableUtil$SerializableChecker", "isMarkedSerializable"));
            }
            for (PsiClass markerInterface : this.mySerializableMarkerInterfaces) {
                if (!psiClass.isInheritor(markerInterface, true)) continue;
                return true;
            }
            return false;
        }

        public String getPresentableSerializableClassesString() {
            if (this.mySerializableMarkerInterfaces.isEmpty()) {
                return "";
            }
            String name1 = this.mySerializableMarkerInterfaces.get(0).getQualifiedName();
            if (this.mySerializableMarkerInterfaces.size() == 1) {
                return "'" + name1 + "'";
            }
            String name2 = this.mySerializableMarkerInterfaces.get(1).getQualifiedName();
            return GwtBundle.message("text.0.or.1", name1, name2);
        }
    }
}

