/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.rpc;

import com.intellij.gwt.rpc.GwtGenericsUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServiceUtil {
    @NonNls
    public static final String REMOTE_SERVICE_INTERFACE_NAME = "com.google.gwt.user.client.rpc.RemoteService";
    @NonNls
    public static final String ASYNC_CALLBACK_INTERFACE_NAME = "com.google.gwt.user.client.rpc.AsyncCallback";
    @NonNls
    public static final String SERVICE_PATH_ANNOTATION_NAME = "com.google.gwt.user.client.rpc.RemoteServiceRelativePath";
    @NonNls
    private static final String REMOTE_SERVICE_SERVLET_NAME = "com.google.gwt.user.server.rpc.RemoteServiceServlet";
    @NonNls
    public static final String ASYNC_SUFFIX = "Async";
    @NonNls
    public static final String IMPL_SERVICE_SUFFIX = "Impl";
    @NonNls
    private static final String VOID_CLASS_NAME = "java.lang.Void";

    private RemoteServiceUtil() {
    }

    public static boolean isMethodPresentedInAsync(@NotNull PsiMethod method, @NotNull PsiClass async) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/gwt/rpc/RemoteServiceUtil", "isMethodPresentedInAsync"));
        }
        if (async == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "async", "com/intellij/gwt/rpc/RemoteServiceUtil", "isMethodPresentedInAsync"));
        }
        return RemoteServiceUtil.findMethodInAsync(method, async) != null;
    }

    public static boolean isMethodPresentedInSync(@NotNull PsiMethod asyncMethod, @NotNull PsiClass sync) {
        if (asyncMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncMethod", "com/intellij/gwt/rpc/RemoteServiceUtil", "isMethodPresentedInSync"));
        }
        if (sync == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sync", "com/intellij/gwt/rpc/RemoteServiceUtil", "isMethodPresentedInSync"));
        }
        return RemoteServiceUtil.findMethodInSync(asyncMethod, sync) != null;
    }

    @Nullable
    public static PsiMethod findSynchronousMethod(@NotNull PsiMethod asyncMethod) {
        PsiClass syncClass;
        if (asyncMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncMethod", "com/intellij/gwt/rpc/RemoteServiceUtil", "findSynchronousMethod"));
        }
        PsiClass asyncClass = asyncMethod.getContainingClass();
        if (asyncClass != null && (syncClass = RemoteServiceUtil.findSynchronousInterface(asyncClass)) != null) {
            return RemoteServiceUtil.findMethodInSync(asyncMethod, syncClass);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodInSync(@NotNull PsiMethod asyncMethod, @NotNull PsiClass sync) {
        if (asyncMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncMethod", "com/intellij/gwt/rpc/RemoteServiceUtil", "findMethodInSync"));
        }
        if (sync == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sync", "com/intellij/gwt/rpc/RemoteServiceUtil", "findMethodInSync"));
        }
        PsiParameter[] asyncParameters = asyncMethod.getParameterList().getParameters();
        for (PsiMethod method : sync.findMethodsByName(asyncMethod.getName(), true)) {
            PsiParameter[] syncParameters = method.getParameterList().getParameters();
            if (!RemoteServiceUtil.areParametersCorresponding(syncParameters, asyncParameters, method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodInAsync(@NotNull PsiMethod method, @NotNull PsiClass async) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/gwt/rpc/RemoteServiceUtil", "findMethodInAsync"));
        }
        if (async == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "async", "com/intellij/gwt/rpc/RemoteServiceUtil", "findMethodInAsync"));
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (PsiMethod asyncMethod : async.findMethodsByName(method.getName(), true)) {
            PsiParameter[] asyncParams = asyncMethod.getParameterList().getParameters();
            if (!RemoteServiceUtil.areParametersCorresponding(parameters, asyncParams, method.getReturnType())) continue;
            return asyncMethod;
        }
        return null;
    }

    private static boolean areParametersCorresponding(PsiParameter[] syncParameters, PsiParameter[] asyncParameters, @Nullable PsiType syncReturnType) {
        PsiClassType boxedType;
        if (asyncParameters.length != syncParameters.length + 1) {
            return false;
        }
        for (int i = 0; i != syncParameters.length; ++i) {
            if (RemoteServiceUtil.areErasuresEqual(syncParameters[i].getType(), asyncParameters[i].getType())) continue;
            return false;
        }
        PsiParameter lastParameter = asyncParameters[syncParameters.length];
        PsiType lastParameterType = lastParameter.getType();
        if (!(lastParameterType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType lastClassType = (PsiClassType)lastParameterType;
        PsiClassType.ClassResolveResult resolveResult = lastClassType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass == null || !ASYNC_CALLBACK_INTERFACE_NAME.equals(psiClass.getQualifiedName())) {
            return false;
        }
        if (PsiClassType.isRaw((PsiClassType.ClassResolveResult)resolveResult) || !psiClass.hasTypeParameters()) {
            return true;
        }
        PsiType actualTypeParameter = resolveResult.getSubstitutor().substitute(psiClass.getTypeParameters()[0]);
        if (syncReturnType instanceof PsiPrimitiveType && (boxedType = RemoteServiceUtil.getBoxedType((PsiPrimitiveType)syncReturnType, lastParameter.getResolveScope(), lastParameter.getProject())) != null) {
            syncReturnType = boxedType;
        }
        return actualTypeParameter != null && syncReturnType != null && RemoteServiceUtil.areErasuresEqual(syncReturnType, actualTypeParameter);
    }

    private static boolean areErasuresEqual(@NotNull PsiType t1, @NotNull PsiType t2) {
        if (t1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t1", "com/intellij/gwt/rpc/RemoteServiceUtil", "areErasuresEqual"));
        }
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t2", "com/intellij/gwt/rpc/RemoteServiceUtil", "areErasuresEqual"));
        }
        PsiType type1 = TypeConversionUtil.erasure((PsiType)t1);
        PsiType type2 = TypeConversionUtil.erasure((PsiType)t2);
        return type1.equals(type2);
    }

    public static boolean isRemoteServiceInterface(@Nullable PsiClass aClass) {
        if (aClass == null || !aClass.isInterface()) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)REMOTE_SERVICE_INTERFACE_NAME);
    }

    public static boolean isRemoteServiceImplementation(@Nullable PsiClass aClass) {
        if (aClass == null || aClass.isInterface() || aClass.hasModifierProperty("abstract")) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)REMOTE_SERVICE_SERVLET_NAME);
    }

    @Nullable
    public static PsiClass findRemoteServiceInterface(PsiClass serviceImpl) {
        PsiClass[] interfaces;
        for (PsiClass anInterface : interfaces = serviceImpl.getInterfaces()) {
            if (!RemoteServiceUtil.isRemoteServiceInterface(anInterface)) continue;
            return anInterface;
        }
        return null;
    }

    @Nullable
    public static PsiClass findSynchronousInterface(@Nullable PsiClass asyncInterface) {
        if (asyncInterface == null) {
            return null;
        }
        String name = asyncInterface.getQualifiedName();
        if (name == null || !name.endsWith(ASYNC_SUFFIX)) {
            return null;
        }
        PsiManager psiManager = asyncInterface.getManager();
        GlobalSearchScope scope = asyncInterface.getResolveScope();
        String syncName = name.substring(0, name.length() - ASYNC_SUFFIX.length());
        PsiClass sync = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(syncName, scope);
        if (InheritanceUtil.isInheritor((PsiClass)sync, (boolean)true, (String)REMOTE_SERVICE_INTERFACE_NAME)) {
            return sync;
        }
        return null;
    }

    @Nullable
    public static PsiClass findAsynchronousInterface(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(aClass.getQualifiedName() + ASYNC_SUFFIX, aClass.getResolveScope());
    }

    @Nullable
    public static PsiMethod findAsynchronousMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/gwt/rpc/RemoteServiceUtil", "findAsynchronousMethod"));
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null || !RemoteServiceUtil.isRemoteServiceInterface(psiClass)) {
            return null;
        }
        PsiClass asyncClass = RemoteServiceUtil.findAsynchronousInterface(psiClass);
        if (asyncClass == null) {
            return null;
        }
        return RemoteServiceUtil.findMethodInAsync(method, asyncClass);
    }

    public static void copyAllMethodsToAsync(@NotNull PsiClass sync, @NotNull PsiClass async, @NotNull GwtVersion gwtVersion) throws IncorrectOperationException {
        if (sync == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sync", "com/intellij/gwt/rpc/RemoteServiceUtil", "copyAllMethodsToAsync"));
        }
        if (async == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "async", "com/intellij/gwt/rpc/RemoteServiceUtil", "copyAllMethodsToAsync"));
        }
        if (gwtVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtVersion", "com/intellij/gwt/rpc/RemoteServiceUtil", "copyAllMethodsToAsync"));
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)sync.getProject()).getElementFactory();
        for (PsiMethod method : async.getMethods()) {
            method.delete();
        }
        for (PsiMethod method : sync.getMethods()) {
            RemoteServiceUtil.copyMethodToAsync(method, async, elementFactory, gwtVersion);
        }
    }

    public static PsiMethod copyMethodToAsync(@NotNull PsiMethod method, @NotNull PsiClass async, @NotNull GwtVersion gwtVersion) throws IncorrectOperationException {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/gwt/rpc/RemoteServiceUtil", "copyMethodToAsync"));
        }
        if (async == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "async", "com/intellij/gwt/rpc/RemoteServiceUtil", "copyMethodToAsync"));
        }
        if (gwtVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtVersion", "com/intellij/gwt/rpc/RemoteServiceUtil", "copyMethodToAsync"));
        }
        return RemoteServiceUtil.copyMethodToAsync(method, async, JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory(), gwtVersion);
    }

    private static PsiMethod copyMethodToAsync(@NotNull PsiMethod method, @NotNull PsiClass async, @NotNull PsiElementFactory elementFactory, @NotNull GwtVersion gwtVersion) throws IncorrectOperationException {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/gwt/rpc/RemoteServiceUtil", "copyMethodToAsync"));
        }
        if (async == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "async", "com/intellij/gwt/rpc/RemoteServiceUtil", "copyMethodToAsync"));
        }
        if (elementFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFactory", "com/intellij/gwt/rpc/RemoteServiceUtil", "copyMethodToAsync"));
        }
        if (gwtVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtVersion", "com/intellij/gwt/rpc/RemoteServiceUtil", "copyMethodToAsync"));
        }
        PsiClassType asyncCallbackType = !gwtVersion.isGenericsSupported() ? RemoteServiceUtil.createAsyncCallbackType((PsiElement)async, null) : RemoteServiceUtil.createAsyncCallbackType((PsiElement)async, method.getReturnType());
        PsiMethod newMethod = (PsiMethod)method.copy();
        newMethod.getParameterList().add((PsiElement)elementFactory.createParameter("async", (PsiType)asyncCallbackType));
        PsiReferenceList throwsList = newMethod.getThrowsList();
        for (PsiJavaCodeReferenceElement element : throwsList.getReferenceElements()) {
            element.delete();
        }
        GwtGenericsUtil.removeTypeArgsJavadocTags(newMethod);
        PsiTypeElement returnTypeElement = newMethod.getReturnTypeElement();
        assert (returnTypeElement != null);
        returnTypeElement.replace((PsiElement)elementFactory.createTypeElement((PsiType)PsiType.VOID));
        return (PsiMethod)async.add((PsiElement)newMethod);
    }

    public static PsiClassType createAsyncCallbackType(@NotNull PsiElement context, @Nullable PsiType parameter) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/rpc/RemoteServiceUtil", "createAsyncCallbackType"));
        }
        Project project = context.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = context.getResolveScope();
        PsiClass asyncCallbackClass = psiFacade.findClass(ASYNC_CALLBACK_INTERFACE_NAME, scope);
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        if (asyncCallbackClass == null) {
            return elementFactory.createTypeByFQClassName(ASYNC_CALLBACK_INTERFACE_NAME, scope);
        }
        PsiTypeParameter[] typeParameters = asyncCallbackClass.getTypeParameters();
        if (parameter instanceof PsiPrimitiveType) {
            parameter = RemoteServiceUtil.getBoxedType((PsiPrimitiveType)parameter, scope, project);
        }
        if (parameter == null || typeParameters.length == 0) {
            return elementFactory.createType(asyncCallbackClass);
        }
        return elementFactory.createType(asyncCallbackClass, PsiSubstitutor.EMPTY.put(typeParameters[0], parameter));
    }

    @Nullable
    private static PsiClassType getBoxedType(@NotNull PsiPrimitiveType type, @NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/gwt/rpc/RemoteServiceUtil", "getBoxedType"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/gwt/rpc/RemoteServiceUtil", "getBoxedType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/rpc/RemoteServiceUtil", "getBoxedType"));
        }
        if (TypeConversionUtil.isVoidType((PsiType)type)) {
            return JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeByFQClassName(VOID_CLASS_NAME, scope);
        }
        return type.getBoxedType(PsiManager.getInstance((Project)project), scope);
    }

    public static PsiMethod copyMethodToSync(PsiMethod method, PsiClass sync) throws IncorrectOperationException {
        PsiTypeElement typeElement;
        Project project = method.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiMethod newMethod = (PsiMethod)method.copy();
        PsiParameter[] parameters = newMethod.getParameterList().getParameters();
        PsiClassType newReturnType = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)sync.getResolveScope());
        if (parameters.length > 0) {
            PsiClassType classType;
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass psiClass;
            PsiParameter callbackParameter = parameters[parameters.length - 1];
            PsiType type = method.getParameterList().getParameters()[parameters.length - 1].getType();
            if (type instanceof PsiClassType && (psiClass = (resolveResult = (classType = (PsiClassType)type).resolveGenerics()).getElement()) != null && ASYNC_CALLBACK_INTERFACE_NAME.equals(psiClass.getQualifiedName())) {
                PsiType parameter;
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                if (typeParameters.length > 0 && (parameter = resolveResult.getSubstitutor().substitute(typeParameters[0])) != null) {
                    PsiPrimitiveType unboxed = RemoteServiceUtil.isBoxedVoidType(parameter) ? PsiType.VOID : PsiPrimitiveType.getUnboxedType((PsiType)parameter);
                    newReturnType = unboxed != null ? unboxed : parameter;
                }
                callbackParameter.delete();
            }
        }
        if ((typeElement = newMethod.getReturnTypeElement()) != null) {
            PsiTypeElement newTypeElement = elementFactory.createTypeElement((PsiType)newReturnType);
            typeElement.replace((PsiElement)newTypeElement);
        }
        return (PsiMethod)sync.add((PsiElement)newMethod);
    }

    private static boolean isBoxedVoidType(PsiType parameter) {
        if (!(parameter instanceof PsiClassType)) {
            return false;
        }
        PsiClass psiClass = ((PsiClassType)parameter).resolve();
        return psiClass != null && VOID_CLASS_NAME.equals(psiClass.getQualifiedName());
    }
}

