/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.run.ChooseGwtModulesDialog;
import com.intellij.gwt.run.GwtDevModeServer;
import com.intellij.gwt.run.GwtDevModeServerProvider;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.web.GwtWebUtil;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtRunConfigurationEditor
extends SettingsEditor<GwtRunConfiguration> {
    private static final Comparator<List<String>> MODULES_LIST_COMPARATOR = new Comparator<List<String>>(){

        @Override
        public int compare(List<String> o1, List<String> o2) {
            if (o1.size() > o2.size()) {
                return -1;
            }
            if (o1.size() < o2.size()) {
                return 1;
            }
            return ContainerUtil.compareLexicographically(o1, o2, (Comparator)String.CASE_INSENSITIVE_ORDER);
        }
    };
    private SortedComboBoxModel<List<String>> myGwtModulesModel;
    private DefaultComboBoxModel myPagesModel;
    private ModulesComboBox myModulesBox;
    private JPanel myMainPanel;
    private ComboboxWithBrowseButton myHtmlPageBox;
    private RawCommandLineEditor myVMParameters;
    private RawCommandLineEditor myGwtShellParameters;
    private JCheckBox myPatchWebXmlCheckBox;
    private TextFieldWithBrowseButton myWebXmlField;
    private ComboboxWithBrowseButton myGwtModuleComboBox;
    private JLabel myGwtModuleLabel;
    private JLabel myServerLabel;
    private JComboBox myServerComboBox;
    private JCheckBox myOpenInBrowserCheckBox;
    private final BrowserSelector myBrowserSelector;
    private JPanel myBrowserSelectorPanel;
    private JCheckBox myUpdateResourcesOnFrameCheckBox;
    private JBCheckBox myUseSuperDevModeCheckBox;
    private JLabel myStartPageLabel;
    private JCheckBox myStartJavaScriptDebuggerCheckBox;
    private EnvironmentVariablesComponent myEnvironmentVariablesComponent;
    private final Project myProject;
    private final GwtModulesManager myGwtModulesManager;
    private final Map<String, String> myHtmlPage2GwtModule;
    private List<String> myAllGwtModules;

    public GwtRunConfigurationEditor(final Project project) {
        this.$$$setupUI$$$();
        this.myHtmlPage2GwtModule = new THashMap();
        this.myAllGwtModules = new ArrayList<String>();
        this.myProject = project;
        this.myGwtModulesManager = GwtModulesManager.getInstance(this.myProject);
        this.myVMParameters.setDialogCaption(GwtBundle.message("dialog.caption.vm.parameters", new Object[0]));
        this.myGwtShellParameters.setDialogCaption(GwtBundle.message("dialog.caption.gwt.dev.mode.parameters", new Object[0]));
        this.myBrowserSelector = new BrowserSelector();
        this.myGwtModuleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DumbService.isDumb((Project)project)) {
                    Messages.showErrorDialog((Component)GwtRunConfigurationEditor.this.myMainPanel, (String)("GWT Module chooser isn't available while " + ApplicationNamesInfo.getInstance().getProductName() + " is updating indices"));
                    return;
                }
                ChooseGwtModulesDialog dialog = new ChooseGwtModulesDialog(GwtRunConfigurationEditor.this.getSelectedModule(), GwtRunConfigurationEditor.this.getSelectedGwtModules());
                if (dialog.showAndGet()) {
                    GwtRunConfigurationEditor.this.setSelectedGwtModules(dialog.getSelectedModules());
                }
            }
        });
    }

    public void resetEditorFrom(GwtRunConfiguration configuration) {
        GwtRunConfiguration.GwtRunConfigurationState state = configuration.getState();
        this.myVMParameters.setText(state.VM_PARAMETERS);
        this.myEnvironmentVariablesComponent.setEnvs(state.ENVIRONMENT_VARIABLES);
        this.myEnvironmentVariablesComponent.setPassParentEnvs(state.PASS_PARENT_ENVS);
        this.myGwtShellParameters.setText(state.SHELL_PARAMETERS);
        this.myUpdateResourcesOnFrameCheckBox.setSelected(state.UPDATE_RESOURCES_ON_FRAME_DEACTIVATION);
        this.myUseSuperDevModeCheckBox.setSelected(state.USE_SUPER_DEV_MODE);
        Module module = configuration.getModule();
        this.myModulesBox.setModules(configuration.getValidModules());
        this.myModulesBox.setSelectedModule(module);
        boolean customWebXml = state.CUSTOM_WEB_XML != null;
        this.myPatchWebXmlCheckBox.setSelected(customWebXml);
        this.myWebXmlField.setEnabled(customWebXml);
        if (customWebXml) {
            this.setCustomWebXml(state.CUSTOM_WEB_XML);
        }
        this.updateWebXmlPanel(module);
        this.fillPages(module);
        String pagePath = configuration.getPage();
        if (pagePath == null) {
            pagePath = "";
        }
        this.myHtmlPageBox.getComboBox().getEditor().setItem(pagePath);
        this.updateGwtModulesCombobox(module);
        this.myGwtModuleComboBox.getComboBox().setSelectedItem(null);
        List<String> gwtModules = state.getGwtModules();
        this.setSelectedGwtModules(gwtModules != null ? gwtModules : this.myAllGwtModules);
        for (int i = 0; i < this.myServerComboBox.getItemCount(); ++i) {
            GwtDevModeServer server = (GwtDevModeServer)this.myServerComboBox.getItemAt(i);
            if (!server.getId().equals(state.SERVER_ID)) continue;
            this.myServerComboBox.setSelectedIndex(i);
            break;
        }
        this.myOpenInBrowserCheckBox.setSelected(state.OPEN_IN_BROWSER);
        this.myStartJavaScriptDebuggerCheckBox.setSelected(state.START_JAVASCRIPT_DEBUGGER);
        this.myBrowserSelector.setSelected(WebBrowserManager.getInstance().findBrowserById(state.BROWSER));
        this.updateSuperDevModeCheckbox(module);
        this.updateOpenInBrowserSection();
        this.updateUpdateResourcesCheckbox();
        this.updateServerCombobox();
        this.updateStartPagePanel();
    }

    private void setSelectedGwtModules(@NotNull List<String> gwtModules) {
        if (gwtModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtModules", "com/intellij/gwt/run/GwtRunConfigurationEditor", "setSelectedGwtModules"));
        }
        if (this.myGwtModulesModel.indexOf(gwtModules) == -1) {
            for (List list : new ArrayList(this.myGwtModulesModel.getItems())) {
                if (list.size() <= 1 || list.equals(this.myAllGwtModules)) continue;
                this.myGwtModulesModel.remove((Object)list);
            }
            this.myGwtModulesModel.add(gwtModules);
        }
        this.myGwtModuleComboBox.getComboBox().setSelectedItem(gwtModules);
    }

    private void updateStartPagePanel() {
        boolean visible = !this.startCodeServerOnly();
        this.myStartPageLabel.setVisible(visible);
        this.myHtmlPageBox.setVisible(visible);
        this.myStartJavaScriptDebuggerCheckBox.setVisible(this.myUseSuperDevModeCheckBox.isSelected() && JavaScriptDebuggerStarter.Util.hasStarters() && GwtRunConfiguration.useNewSuperDevModeLauncher());
    }

    private void updateGwtModulesCombobox(@Nullable Module module) {
        this.myAllGwtModules = new ArrayList<String>();
        this.myGwtModulesModel.clear();
        boolean enable = false;
        if (module != null) {
            for (GwtModule gwtModule : this.myGwtModulesManager.getCompilableGwtModules(module, false)) {
                String moduleName = gwtModule.getQualifiedName();
                this.myAllGwtModules.add(moduleName);
                this.myGwtModulesModel.add(Collections.singletonList(moduleName));
            }
            GwtFacet facet = GwtFacet.getInstance(module);
            if (facet != null) {
                enable = facet.getSdkVersion().isModulesToLoadSpecifiedInDevMode();
            }
        }
        Collections.sort(this.myAllGwtModules, String.CASE_INSENSITIVE_ORDER);
        this.setSelectedGwtModules(this.myAllGwtModules);
        this.myGwtModuleComboBox.setEnabled(enable);
        this.myGwtModuleLabel.setEnabled(enable);
    }

    private void setCustomWebXml(String url) {
        this.myWebXmlField.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url)));
    }

    @Nullable
    private VirtualFile getFileByPagePath(@Nullable Module module, @NotNull String pagePath) {
        if (pagePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pagePath", "com/intellij/gwt/run/GwtRunConfigurationEditor", "getFileByPagePath"));
        }
        int index = pagePath.indexOf(47);
        if (index == -1) {
            return null;
        }
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.allScope((Project)this.myProject);
        Collection<GwtModule> gwtModules = this.myGwtModulesManager.findGwtModulesByOutputName(pagePath.substring(0, index), scope);
        String name = pagePath.substring(index + 1);
        for (GwtModule gwtModule : gwtModules) {
            Collection<VirtualFile> publicRoots = gwtModule.getPublicRoots();
            for (VirtualFile root : publicRoots) {
                VirtualFile file = root.findFileByRelativePath(name);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    private void fillPages(Module module) {
        this.myPagesModel.removeAllElements();
        this.myHtmlPage2GwtModule.clear();
        if (module == null) {
            return;
        }
        for (GwtModule gwtModule : this.myGwtModulesManager.getCompilableGwtModules(module, false)) {
            Collection<VirtualFile> htmlFiles = this.myGwtModulesManager.getAllHtmlFiles(gwtModule);
            for (VirtualFile htmlFile : htmlFiles) {
                String path = this.myGwtModulesManager.getOutputPath(gwtModule, htmlFile);
                if (path == null) continue;
                this.myHtmlPage2GwtModule.put(path, gwtModule.getQualifiedName());
                this.myPagesModel.addElement(path);
            }
        }
    }

    public void applyEditorTo(GwtRunConfiguration configuration) throws ConfigurationException {
        configuration.setModule(this.getSelectedModule());
        String path = (String)this.myHtmlPageBox.getComboBox().getEditor().getItem();
        configuration.setPage(path);
        GwtRunConfiguration.GwtRunConfigurationState state = configuration.getState();
        state.VM_PARAMETERS = this.myVMParameters.getText();
        state.SHELL_PARAMETERS = this.myGwtShellParameters.getText();
        state.PASS_PARENT_ENVS = this.myEnvironmentVariablesComponent.isPassParentEnvs();
        state.ENVIRONMENT_VARIABLES = this.myEnvironmentVariablesComponent.getEnvs();
        state.UPDATE_RESOURCES_ON_FRAME_DEACTIVATION = this.myUpdateResourcesOnFrameCheckBox.isSelected();
        state.USE_SUPER_DEV_MODE = this.isUseSuperDevModeSelected();
        state.CUSTOM_WEB_XML = this.myPatchWebXmlCheckBox.isSelected() ? VfsUtilCore.pathToUrl((String)FileUtil.toSystemIndependentName((String)this.myWebXmlField.getText())) : null;
        List<String> selectedGwtModules = this.getSelectedGwtModules();
        state.setGwtModules(selectedGwtModules.equals(this.myAllGwtModules) ? null : selectedGwtModules);
        state.SERVER_ID = ((GwtDevModeServer)this.myServerComboBox.getSelectedItem()).getId();
        state.OPEN_IN_BROWSER = this.myOpenInBrowserCheckBox.isSelected();
        state.START_JAVASCRIPT_DEBUGGER = this.myStartJavaScriptDebuggerCheckBox.isSelected();
        state.BROWSER = this.myBrowserSelector.getSelectedBrowserId();
    }

    @NotNull
    private List<String> getSelectedGwtModules() {
        List list = (List)ObjectUtils.notNull((Object)this.myGwtModulesModel.getSelectedItem(), this.myAllGwtModules);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtRunConfigurationEditor", "getSelectedGwtModules"));
        }
        return list;
    }

    private Module getSelectedModule() {
        return this.myModulesBox.getSelectedModule();
    }

    @NotNull
    public JComponent createEditor() {
        this.myPagesModel = new DefaultComboBoxModel();
        JComboBox comboBox = this.myHtmlPageBox.getComboBox();
        comboBox.setEditable(true);
        comboBox.setModel(this.myPagesModel);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String page = (String)e.getItem();
                    String gwtModule = (String)GwtRunConfigurationEditor.this.myHtmlPage2GwtModule.get(page);
                    if (gwtModule != null) {
                        GwtRunConfigurationEditor.this.ensureGwtModuleIsSelected(gwtModule);
                    }
                }
            }
        });
        this.myServerComboBox.setRenderer(new ListCellRendererWrapper<GwtDevModeServer>(){

            public void customize(JList list, GwtDevModeServer value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getName());
                this.setIcon(value.getIcon());
            }
        });
        for (GwtDevModeServerProvider serverProvider : (GwtDevModeServerProvider[])GwtDevModeServerProvider.EP_NAME.getExtensions()) {
            for (GwtDevModeServer gwtDevModeServer : serverProvider.getServers()) {
                this.myServerComboBox.addItem(gwtDevModeServer);
            }
        }
        this.myPatchWebXmlCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GwtRunConfigurationEditor.this.myWebXmlField.setEnabled(GwtRunConfigurationEditor.this.myPatchWebXmlCheckBox.isSelected());
            }
        });
        this.myWebXmlField.addBrowseFolderListener(null, null, this.myProject, this.createWebXmlChooserDescriptor());
        this.myModulesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Module module = GwtRunConfigurationEditor.this.myModulesBox.getSelectedModule();
                GwtRunConfigurationEditor.this.updateSuperDevModeCheckbox(module);
                GwtRunConfigurationEditor.this.fillPages(module);
                GwtRunConfigurationEditor.this.updateWebXmlPanel(module);
                GwtRunConfigurationEditor.this.updateGwtModulesCombobox(module);
                GwtRunConfigurationEditor.this.updateOpenInBrowserSection();
                GwtRunConfigurationEditor.this.updateUpdateResourcesCheckbox();
            }
        });
        this.myUseSuperDevModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GwtRunConfigurationEditor.this.updateSuperDevModeCheckbox(GwtRunConfigurationEditor.this.getSelectedModule());
                GwtRunConfigurationEditor.this.updateServerCombobox();
                GwtRunConfigurationEditor.this.updateWebXmlPanel(GwtRunConfigurationEditor.this.getSelectedModule());
                GwtRunConfigurationEditor.this.updateUpdateResourcesCheckbox();
                GwtRunConfigurationEditor.this.updateStartPagePanel();
            }
        });
        this.myBrowserSelectorPanel.add("Center", this.myBrowserSelector.getMainComponent());
        this.myOpenInBrowserCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GwtRunConfigurationEditor.this.updateOpenInBrowserSection();
            }
        });
        this.myHtmlPageBox.addBrowseFolderListener(this.myProject, (ComponentWithBrowseButton.BrowseFolderActionListener)new HtmlPageActionListener());
        this.myGwtModuleComboBox.getComboBox().setRenderer(new ListCellRendererWrapper<List<String>>(){

            public void customize(JList list, List<String> value, int index, boolean selected, boolean hasFocus) {
                String text = GwtRunConfigurationEditor.this.myAllGwtModules.equals(value) ? GwtBundle.message("text.gwt.modules.to.load.all", new Object[0]) : (value.size() > 1 ? value.get(0) + " and " + (value.size() == 2 ? "one more module" : value.size() - 1 + " more modules") : (value.size() == 1 ? value.get(0) : GwtBundle.message("text.gwt.modules.to.load.none", new Object[0])));
                this.setText(text);
            }
        });
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/run/GwtRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    private void ensureGwtModuleIsSelected(@NotNull String gwtModule) {
        if (gwtModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtModule", "com/intellij/gwt/run/GwtRunConfigurationEditor", "ensureGwtModuleIsSelected"));
        }
        List<String> modules = this.getSelectedGwtModules();
        if (!modules.contains(gwtModule)) {
            this.myGwtModuleComboBox.getComboBox().setSelectedItem(Collections.singletonList(gwtModule));
        }
    }

    private void updateServerCombobox() {
        boolean visible = this.myServerComboBox.getItemCount() >= 2 && !this.startCodeServerOnly();
        this.myServerComboBox.setVisible(visible);
        this.myServerLabel.setVisible(visible);
    }

    private boolean startCodeServerOnly() {
        return this.isUseSuperDevModeSelected() && !GwtRunConfiguration.useNewSuperDevModeLauncher();
    }

    private boolean isUseSuperDevModeSelected() {
        return this.myUseSuperDevModeCheckBox.isVisible() && this.myUseSuperDevModeCheckBox.isSelected();
    }

    private void updateSuperDevModeCheckbox(@Nullable Module module) {
        GwtVersion version = GwtFacet.getGwtVersion(module);
        this.myUseSuperDevModeCheckBox.setVisible(version.isSuperDevModeSupported());
    }

    private void updateUpdateResourcesCheckbox() {
        this.myUpdateResourcesOnFrameCheckBox.setVisible(GwtFacet.getGwtVersion(this.getSelectedModule()).isOutOfProcessHostedModeSupported() && !this.isUseSuperDevModeSelected());
    }

    private void updateOpenInBrowserSection() {
        boolean visible = GwtFacet.getGwtVersion(this.getSelectedModule()).isOutOfProcessHostedModeSupported();
        this.myOpenInBrowserCheckBox.setVisible(visible);
        this.myBrowserSelector.getMainComponent().setVisible(visible);
        boolean enable = this.myOpenInBrowserCheckBox.isSelected();
        this.myBrowserSelector.getMainComponent().setEnabled(enable);
        this.myStartJavaScriptDebuggerCheckBox.setEnabled(enable);
    }

    private FileChooserDescriptor createWebXmlChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || file.getName().equals(DeploymentDescriptorsConstants.WEB_XML_META_DATA.getFileName()));
            }
        };
        this.setContentRoots(descriptor);
        return descriptor;
    }

    private void updateWebXmlPanel(@Nullable Module module) {
        boolean visible = this.updateWebXmlField(module);
        this.myWebXmlField.setVisible(visible);
        this.myPatchWebXmlCheckBox.setVisible(visible);
    }

    private boolean updateWebXmlField(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        GwtFacet facet = GwtFacet.getInstance(module);
        if (webFacets.isEmpty() || facet == null || facet.getSdkVersion().isHostedModeRequiresWebXml()) {
            return false;
        }
        if (this.myWebXmlField.getText().trim().length() == 0) {
            ConfigFile descriptor;
            WebFacet webFacet = facet.getWebFacet();
            if (webFacet == null) {
                webFacet = (WebFacet)webFacets.iterator().next();
            }
            if ((descriptor = webFacet.getWebXmlDescriptor()) != null) {
                this.setCustomWebXml(descriptor.getUrl());
            }
        }
        return true;
    }

    private FileChooserDescriptor createHtmlFileChooserDescriptor() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || file.getFileType() == StdFileTypes.HTML);
            }
        };
        this.setContentRoots(descriptor);
        return descriptor;
    }

    private void setContentRoots(FileChooserDescriptor descriptor) {
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)this.myProject);
        descriptor.setRoots(rootManager.getContentRoots());
    }

    private void createUIComponents() {
        this.myGwtModulesModel = new SortedComboBoxModel(MODULES_LIST_COMPARATOR);
        this.myGwtModuleComboBox = new ComboboxWithBrowseButton((JComboBox)new ComboBox(this.myGwtModulesModel));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EnvironmentVariablesComponent environmentVariablesComponent;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JLabel jLabel;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JCheckBox jCheckBox3;
        JComboBox jComboBox;
        JLabel jLabel2;
        JLabel jLabel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox4;
        RawCommandLineEditor rawCommandLineEditor;
        RawCommandLineEditor rawCommandLineEditor2;
        ModulesComboBox modulesComboBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(14, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.choose.module.text"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(13, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModulesBox = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)modulesComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.text.vm.parameters"));
        jPanel2.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMParameters = rawCommandLineEditor2 = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor2, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.text.gwt.dev.mode.parameters"));
        jPanel2.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGwtShellParameters = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(4, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myPatchWebXmlCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("checkbox.text.use.custom.web.xml"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(11, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myWebXmlField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(12, 0, 1, 2, 0, 1, 3, 0, null, null, null, 2));
        this.myGwtModuleLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.text.gwt.module.to.load"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton2 = this.myGwtModuleComboBox;
        jPanel2.add((Component)comboboxWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myServerLabel = jLabel2 = new JLabel();
        jLabel2.setText("Server:");
        jLabel2.setDisplayedMnemonic('E');
        jLabel2.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myServerComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myOpenInBrowserCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Open in browser:");
        jCheckBox3.setMnemonic('B');
        jCheckBox3.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBrowserSelectorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(8, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUpdateResourcesOnFrameCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Update resources on frame deactivation");
        jCheckBox2.setMnemonic('U');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(10, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myHtmlPageBox = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(7, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myStartPageLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("label.html.to.open.text"));
        jPanel2.add((Component)jLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseSuperDevModeCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Use Super Dev Mode");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myStartJavaScriptDebuggerCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("with JavaScript debugger");
        jPanel2.add((Component)jCheckBox, new GridConstraints(9, 0, 1, 2, 8, 0, 3, 0, null, null, null, 1));
        this.myEnvironmentVariablesComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        jPanel2.add((Component)environmentVariablesComponent, new GridConstraints(5, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        jLabel4.setLabelFor((Component)modulesComboBox);
        jLabel3.setLabelFor((Component)comboboxWithBrowseButton2);
        jLabel2.setLabelFor(jComboBox);
        jLabel.setLabelFor((Component)comboboxWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class HtmlPageActionListener
    extends ComponentWithBrowseButton.BrowseFolderActionListener<JComboBox> {
        public HtmlPageActionListener() {
            super(null, null, (ComponentWithBrowseButton)GwtRunConfigurationEditor.this.myHtmlPageBox, GwtRunConfigurationEditor.this.myProject, GwtRunConfigurationEditor.this.createHtmlFileChooserDescriptor(), (TextComponentAccessor)new RunPageComponentAccessor());
        }

        protected void onFileChosen(@NotNull VirtualFile chosenFile) {
            if (chosenFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/gwt/run/GwtRunConfigurationEditor$HtmlPageActionListener", "onFileChosen"));
            }
            List<Pair<GwtModule, String>> pairs = GwtRunConfigurationEditor.this.myGwtModulesManager.findGwtModulesByPublicFile(chosenFile);
            Pair<GwtModule, String> pair = null;
            if (pairs.size() == 1) {
                pair = pairs.get(0);
            } else if (!pairs.isEmpty()) {
                String[] gwtModules = new String[pairs.size()];
                for (int i = 0; i < pairs.size(); ++i) {
                    gwtModules[i] = ((GwtModule)pairs.get(i).getFirst()).getQualifiedName();
                }
                int answer = Messages.showChooseDialog((Component)GwtRunConfigurationEditor.this.myMainPanel, (String)GwtBundle.message("choose.text.select.gwt.module", new Object[0]), (String)GwtBundle.message("dialog.title.choose.gwt.module", new Object[0]), (String[])gwtModules, (String)gwtModules[0], null);
                if (answer >= 0) {
                    pair = pairs.get(answer);
                }
            }
            if (pair != null) {
                GwtRunConfigurationEditor.this.myHtmlPageBox.getComboBox().getEditor().setItem(GwtWebUtil.getOutputPath((GwtModule)pair.getFirst(), (String)pair.getSecond()));
                GwtRunConfigurationEditor.this.ensureGwtModuleIsSelected(((GwtModule)pair.getFirst()).getQualifiedName());
            } else {
                String path = GwtWebUtil.getRelativeToWebRootPath(chosenFile, GwtRunConfigurationEditor.this.myProject);
                if (path != null) {
                    GwtRunConfigurationEditor.this.myHtmlPageBox.getComboBox().getEditor().setItem(path);
                } else {
                    Messages.showErrorDialog((Component)GwtRunConfigurationEditor.this.myMainPanel, (String)GwtBundle.message("error.message.0.is.not.under.public.roots.of.gwt.modules.nor.under.web.roots", chosenFile.getName()));
                }
            }
        }
    }

    private class RunPageComponentAccessor
    implements TextComponentAccessor<JComboBox> {
        private RunPageComponentAccessor() {
        }

        public String getText(JComboBox component) {
            String pagePath = component.getEditor().getItem().toString();
            VirtualFile file = GwtRunConfigurationEditor.this.getFileByPagePath(GwtRunConfigurationEditor.this.getSelectedModule(), pagePath);
            return file != null ? file.getPath() : "";
        }

        public void setText(JComboBox component, @NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/gwt/run/GwtRunConfigurationEditor$RunPageComponentAccessor", "setText"));
            }
            throw new UnsupportedOperationException();
        }
    }
}

