/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.sdk.impl;

import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.gwt.sdk.GwtSdkType;
import com.intellij.gwt.sdk.impl.GwtSdkImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GwtSdkManager", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class GwtSdkManagerImpl
extends GwtSdkManager
implements PersistentStateComponent<GwtSdkList> {
    private final Map<String, GwtSdk> myGwtSdkMap = new HashMap<String, GwtSdk>();
    private GwtSdkList myGwtSdkList = new GwtSdkList();

    @Override
    @NotNull
    public GwtSdk getGwtSdk(@NotNull String sdkHomeUrl, @Nullable String sdkTypeId) {
        if (sdkHomeUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomeUrl", "com/intellij/gwt/sdk/impl/GwtSdkManagerImpl", "getGwtSdk"));
        }
        String key = sdkTypeId + ":" + sdkHomeUrl;
        GwtSdk gwtSdk = this.myGwtSdkMap.get(key);
        if (gwtSdk == null) {
            gwtSdk = GwtSdkManagerImpl.createGwtSdk(sdkHomeUrl, sdkTypeId);
            this.myGwtSdkMap.put(key, gwtSdk);
        }
        GwtSdk gwtSdk2 = gwtSdk;
        if (gwtSdk2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtSdkManagerImpl", "getGwtSdk"));
        }
        return gwtSdk2;
    }

    @Override
    @NotNull
    public GwtSdk getGwtSdk(@NotNull String sdkHomeUrl) {
        if (sdkHomeUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomeUrl", "com/intellij/gwt/sdk/impl/GwtSdkManagerImpl", "getGwtSdk"));
        }
        GwtSdkType sdkType = this.detectSdkType(sdkHomeUrl);
        GwtSdk gwtSdk = this.getGwtSdk(sdkHomeUrl, sdkType != null ? sdkType.getId() : null);
        if (gwtSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/sdk/impl/GwtSdkManagerImpl", "getGwtSdk"));
        }
        return gwtSdk;
    }

    private static GwtSdk createGwtSdk(@NotNull String sdkHomeUrl, @Nullable String sdkTypeId) {
        if (sdkHomeUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHomeUrl", "com/intellij/gwt/sdk/impl/GwtSdkManagerImpl", "createGwtSdk"));
        }
        GwtSdkType type = GwtSdkType.findType(sdkTypeId);
        if (type != null) {
            return type.createSdk(sdkHomeUrl);
        }
        return new GwtSdkImpl(sdkHomeUrl);
    }

    @Override
    public void registerGwtSdk(@NotNull GwtSdk gwtSdk) {
        if (gwtSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtSdk", "com/intellij/gwt/sdk/impl/GwtSdkManagerImpl", "registerGwtSdk"));
        }
        String url = gwtSdk.getHomeDirectoryUrl();
        if (gwtSdk.isValid() && !this.myGwtSdkList.getSdkInstallations().contains(url)) {
            this.myGwtSdkList.getSdkInstallations().add(0, StringUtil.trimEnd((String)url, (String)"/"));
        }
    }

    @Override
    public void moveToTop(@NotNull GwtSdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/gwt/sdk/impl/GwtSdkManagerImpl", "moveToTop"));
        }
        if (sdk.isValid()) {
            String url = sdk.getHomeDirectoryUrl();
            List<String> list = this.myGwtSdkList.getSdkInstallations();
            list.remove(url);
            String trimmedUrl = StringUtil.trimEnd((String)url, (String)"/");
            list.remove(trimmedUrl);
            list.add(trimmedUrl);
        }
    }

    @Override
    @Nullable
    public GwtSdk suggestGwtSdk() {
        GwtSdk last = null;
        for (String url : this.myGwtSdkList.getSdkInstallations()) {
            GwtSdk sdk = this.getGwtSdk(url, null);
            if (!sdk.isValid()) continue;
            last = sdk;
        }
        return last;
    }

    @Override
    public List<String> getAllSdkPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (String url : this.myGwtSdkList.getSdkInstallations()) {
            paths.add(0, VfsUtil.urlToPath((String)url));
        }
        return paths;
    }

    @Override
    public void removeInvalidSdk() {
        Iterator<String> iterator = this.myGwtSdkList.getSdkInstallations().iterator();
        while (iterator.hasNext()) {
            String url = iterator.next();
            GwtSdk gwtSdk = this.getGwtSdk(url);
            if (gwtSdk.isValid()) continue;
            iterator.remove();
        }
    }

    public GwtSdkList getState() {
        return this.myGwtSdkList;
    }

    public void loadState(GwtSdkList state) {
        this.myGwtSdkList = state;
    }

    @Override
    @Nullable
    public GwtSdkType detectSdkType(String homeDirectoryUrl) {
        for (GwtSdkType sdkType : (GwtSdkType[])GwtSdkType.EP_NAME.getExtensions()) {
            if (!sdkType.isValidSdkHomeDirectory(new File(VfsUtilCore.urlToPath((String)homeDirectoryUrl)))) continue;
            return sdkType;
        }
        return null;
    }

    public static class GwtSdkList {
        private List<String> mySdkInstallations = new ArrayList<String>();

        @Tag(value="gwt-sdk-list")
        @AbstractCollection(elementTag="gwt-sdk", elementValueAttribute="url", surroundWithTag=false)
        public List<String> getSdkInstallations() {
            return this.mySdkInstallations;
        }

        public void setSdkInstallations(List<String> sdkInstallations) {
            this.mySdkInstallations = sdkInstallations;
        }
    }
}

