/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.XmlCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.gwt.uiBinder.GwtUiXmlSchemaProvider;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.xml.XmlExtension;
import org.jetbrains.annotations.NotNull;

public class GwtComponentTagCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, final @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/gwt/uiBinder/GwtComponentTagCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/uiBinder/GwtComponentTagCompletionContributor", "fillCompletionVariants"));
        }
        super.fillCompletionVariants(parameters, result);
        if (!parameters.isExtendedCompletion() || !XmlCompletionContributor.isXmlNameCompletion((CompletionParameters)parameters)) {
            return;
        }
        final PsiFile file = parameters.getOriginalFile();
        if (!(file instanceof XmlFile) || !UiBinderUtil.isUiXmlFile((XmlFile)file)) {
            return;
        }
        Query search = (Query)new ReadAction<Query<PsiClass>>(){

            protected void run(@NotNull Result<Query<PsiClass>> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/uiBinder/GwtComponentTagCompletionContributor$1", "run"));
                }
                GlobalSearchScope scope = file.getResolveScope();
                PsiClass widgetBaseClass = JavaPsiFacade.getInstance((Project)file.getProject()).findClass("com.google.gwt.user.client.ui.IsWidget", scope);
                if (widgetBaseClass != null) {
                    result.setResult((Object)ClassInheritorsSearch.search((PsiClass)widgetBaseClass, (SearchScope)scope, (boolean)true));
                }
            }
        }.execute().getResultObject();
        if (search == null) {
            return;
        }
        search.forEach((Processor)new Processor<PsiClass>(){

            public boolean process(PsiClass psiClass) {
                String name = psiClass.getName();
                if (name == null || !result.getPrefixMatcher().prefixMatches(name)) {
                    return true;
                }
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null) {
                    return true;
                }
                String packageName = StringUtil.getPackageName((String)qualifiedName);
                String namespace = "urn:import:" + packageName;
                if (GwtUiXmlSchemaProvider.isDefaultSchema(namespace)) {
                    return true;
                }
                LookupElement element = XmlCompletionContributor.createLookupElement((XmlExtension.TagInfo)new XmlExtension.TagInfo(name, namespace), (String)packageName, null);
                result.addElement(element);
                return true;
            }
        });
    }
}

