/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtHtmlElementClassesFinder {
    @NonNls
    private static final String TAG_NAME_ANNOTATION = "com.google.gwt.dom.client.TagName";
    private static final Key<CachedValue<Map<String, String>>> TAG_TO_CLASS_MAP_KEY = Key.create((String)"GWT_TAG_TO_CLASS_NAME_MAP");

    private GwtHtmlElementClassesFinder() {
    }

    @Nullable
    public static String findElementClass(@NotNull String tagName, @NotNull Module module) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/gwt/uiBinder/GwtHtmlElementClassesFinder", "findElementClass"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/uiBinder/GwtHtmlElementClassesFinder", "findElementClass"));
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)module.getProject());
        Map map = (Map)cachedValuesManager.getCachedValue((UserDataHolder)module, TAG_TO_CLASS_MAP_KEY, (CachedValueProvider)new TagToClassMapCachedValueProvider(module), false);
        return map != null ? (String)map.get(tagName) : null;
    }

    @NotNull
    public static List<String> getTagNames(@NotNull PsiClass elementClass) {
        PsiAnnotationMemberValue memberValue;
        PsiAnnotation annotation;
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/gwt/uiBinder/GwtHtmlElementClassesFinder", "getTagNames"));
        }
        PsiModifierList modifiers = elementClass.getModifierList();
        if (modifiers != null && (annotation = modifiers.findAnnotation(TAG_NAME_ANNOTATION)) != null && (memberValue = annotation.findAttributeValue("value")) instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)memberValue).getInitializers();
            SmartList result = new SmartList();
            for (PsiAnnotationMemberValue initializer : initializers) {
                String tag = (String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)initializer, String.class);
                if (tag == null) continue;
                result.add(tag);
            }
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/GwtHtmlElementClassesFinder", "getTagNames"));
            }
            return smartList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/GwtHtmlElementClassesFinder", "getTagNames"));
        }
        return list;
    }

    private static class TagToClassMapCachedValueProvider
    implements CachedValueProvider<Map<String, String>> {
        private final Module myModule;

        public TagToClassMapCachedValueProvider(Module module) {
            this.myModule = module;
        }

        public CachedValueProvider.Result<Map<String, String>> compute() {
            final HashMap result = new HashMap();
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
            PsiClass annotationClass = JavaPsiFacade.getInstance((Project)this.myModule.getProject()).findClass(GwtHtmlElementClassesFinder.TAG_NAME_ANNOTATION, scope);
            if (annotationClass != null) {
                AnnotatedElementsSearch.searchPsiClasses((PsiClass)annotationClass, (SearchScope)scope).forEach((Processor)new Processor<PsiClass>(){

                    public boolean process(PsiClass psiClass) {
                        for (String tagName : GwtHtmlElementClassesFinder.getTagNames(psiClass)) {
                            result.put(tagName, psiClass.getQualifiedName());
                        }
                        return true;
                    }
                });
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.myModule.getProject())});
        }
    }
}

