/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.codeInsight.navigation.GutterIconMultipleNavigationHandler;
import com.intellij.gwt.codeInsight.navigation.MultipleNavigationLineMarkerFactory;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.uiBinder.GwtUiXmlFileUtil;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GwtUiLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final Icon UI_BINDER_CLASS_ICON = PlatformIcons.UI_FORM_ICON;
    private static final Icon UI_FIELD_ICON = PlatformIcons.UI_FORM_ICON;
    private static final GutterIconMultipleNavigationHandler<PsiClass> UI_BINDER_CLASS_NAV_HANDLER = new GutterIconMultipleNavigationHandler<PsiClass>(){

        @Override
        @NotNull
        public String getPopupChooserTitle(PsiClass source, List<? extends GotoRelatedItem> targets) {
            String string = GwtBundle.message("popup.title.ui.xml.file.goto", source.getName(), targets.size());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/GwtUiLineMarkerProvider$1", "getPopupChooserTitle"));
            }
            return string;
        }

        @Override
        public String getGutterTooltip(PsiClass source, List<? extends GotoRelatedItem> targets) {
            return GwtBundle.message("tooltip.text.ui.xml.file.gutter", targets.size());
        }
    };
    private static final GutterIconMultipleNavigationHandler<PsiField> UI_FIELD_NAV_HANDLER = new GutterIconMultipleNavigationHandler<PsiField>(){

        @Override
        @NotNull
        public String getPopupChooserTitle(PsiField source, List<? extends GotoRelatedItem> targets) {
            String string = GwtBundle.message("popup.title.ui.tag.file.goto", source.getName(), targets.size());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/GwtUiLineMarkerProvider$2", "getPopupChooserTitle"));
            }
            return string;
        }

        @Override
        public String getGutterTooltip(PsiField source, List<? extends GotoRelatedItem> targets) {
            return GwtBundle.message("tooltip.text.ui.tag.file.gutter", targets.size());
        }
    };

    public RelatedItemLineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/uiBinder/GwtUiLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (element instanceof PsiClass && GwtFacet.isInModuleWithGwtFacet(element.getProject(), element.getContainingFile().getVirtualFile())) {
            PsiClass psiClass = (PsiClass)element;
            List<XmlFile> files = UiBinderMappingService.getUiXmlFilesForClass(psiClass);
            PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
            if (!files.isEmpty() && nameIdentifier != null) {
                List targets = GotoRelatedItem.createItems(files);
                return MultipleNavigationLineMarkerFactory.create(psiClass, nameIdentifier.getTextRange(), UI_BINDER_CLASS_ICON, targets, UI_BINDER_CLASS_NAV_HANDLER, 4);
            }
        }
        return null;
    }

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        for (PsiElement element : elements) {
            List<XmlTag> tags;
            PsiField field;
            if (!(element instanceof PsiField) || !UiBinderUtil.isUiField(field = (PsiField)element) || (tags = GwtUiLineMarkerProvider.findTagsForField(field)).isEmpty()) continue;
            List targets = GotoRelatedItem.createItems(tags);
            result.add(MultipleNavigationLineMarkerFactory.create(field, field.getNameIdentifier().getTextRange(), UI_FIELD_ICON, targets, UI_FIELD_NAV_HANDLER, 6));
        }
    }

    @NotNull
    private static List<XmlTag> findTagsForField(PsiField field) {
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            List<XmlTag> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/GwtUiLineMarkerProvider", "findTagsForField"));
            }
            return list;
        }
        ArrayList<XmlTag> result = new ArrayList<XmlTag>();
        for (XmlFile file : UiBinderMappingService.getUiXmlFilesForClass(psiClass)) {
            ContainerUtil.addIfNotNull(result, (Object)GwtUiXmlFileUtil.findTagForField(file, field.getName()));
        }
        ArrayList<XmlTag> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/GwtUiLineMarkerProvider", "findTagsForField"));
        }
        return arrayList;
    }
}

