/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.mapping;

import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.gwt.uiBinder.mapping.UiTemplateInterfaceJamElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiBinderMappingServiceImpl
extends UiBinderMappingService {
    @NonNls
    private static final String UI_BINDER_INTERFACE = "com.google.gwt.uibinder.client.UiBinder";
    @NonNls
    static final String UI_TEMPLATE_ANNOTATION = "com.google.gwt.uibinder.client.UiTemplate";
    private final Module myModule;
    private final CachedValue<BidirectionalMultiMap<String, String>> myClassNameToUiXmlUrl;

    public UiBinderMappingServiceImpl(Module module) {
        this.myModule = module;
        this.myClassNameToUiXmlUrl = CachedValuesManager.getManager((Project)this.myModule.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<BidirectionalMultiMap<String, String>>(){

            public CachedValueProvider.Result<BidirectionalMultiMap<String, String>> compute() {
                return CachedValueProvider.Result.create((Object)UiBinderMappingServiceImpl.this.computeMapping(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        }, false);
    }

    private BidirectionalMultiMap<String, String> computeMapping() {
        final BidirectionalMultiMap result = new BidirectionalMultiMap();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
        final PsiClass uiBinderInterface = psiFacade.findClass(UI_BINDER_INTERFACE, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
        if (uiBinderInterface != null && uiBinderInterface.getTypeParameters().length == 2) {
            final PsiTypeParameter ownerParameter = uiBinderInterface.getTypeParameters()[1];
            ClassInheritorsSearch.search((PsiClass)uiBinderInterface, (SearchScope)GlobalSearchScope.moduleScope((Module)this.myModule), (boolean)true).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass aClass) {
                    PsiClass ownerClass;
                    PsiType ownerType = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)uiBinderInterface, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).substitute(ownerParameter);
                    if (ownerType != null && (ownerClass = PsiTypesUtil.getPsiClass((PsiType)ownerType)) != null) {
                        UiBinderMappingServiceImpl.registerTemplates(ownerClass, UiTemplateInterfaceJamElement.getElement(aClass), (BidirectionalMultiMap<String, String>)result);
                    }
                    return true;
                }
            });
        }
        return result;
    }

    private static void registerTemplates(PsiClass ownerClass, UiTemplateInterfaceJamElement templateElement, BidirectionalMultiMap<String, String> result) {
        VirtualFile virtualFile;
        String ownerClassName = ownerClass.getQualifiedName();
        if (ownerClassName == null) {
            return;
        }
        XmlFile file = templateElement != null ? templateElement.findTemplateFile() : UiBinderMappingServiceImpl.getDefaultTemplateFile(ownerClass);
        if (file != null && (virtualFile = file.getVirtualFile()) != null) {
            result.put((Object)ownerClassName, (Object)virtualFile.getUrl());
        }
    }

    @Nullable
    public static XmlFile getDefaultTemplateFile(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return null;
        }
        Project project = aClass.getProject();
        PsiFile file = aClass.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return null;
        }
        String packageName = ((PsiJavaFile)file).getPackageName();
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (psiPackage == null) {
            return null;
        }
        String fileName = aClass.getName() + ".ui.xml";
        for (PsiDirectory psiDirectory : psiPackage.getDirectories(aClass.getResolveScope())) {
            PsiFile xmlFile = psiDirectory.findFile(fileName);
            if (!(xmlFile instanceof XmlFile)) continue;
            return (XmlFile)xmlFile;
        }
        return null;
    }

    @Override
    @NotNull
    public List<PsiClass> getBoundClasses(@NotNull PsiFile uiXmlFile) {
        Set classNames;
        if (uiXmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiXmlFile", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getBoundClasses"));
        }
        VirtualFile virtualFile = uiXmlFile.getVirtualFile();
        if (virtualFile != null && (classNames = ((BidirectionalMultiMap)this.myClassNameToUiXmlUrl.getValue()).getKeys((Object)virtualFile.getUrl())) != null) {
            GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)this.myModule);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
            SmartList result = new SmartList();
            for (String className : classNames) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)psiFacade.findClass(className, scope));
            }
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getBoundClasses"));
            }
            return smartList;
        }
        List<PsiClass> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getBoundClasses"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<XmlFile> getUiXmlFiles(@NotNull PsiClass aClass) {
        Set urls;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getUiXmlFiles"));
        }
        String className = aClass.getQualifiedName();
        if (className != null && (urls = ((BidirectionalMultiMap)this.myClassNameToUiXmlUrl.getValue()).getValues((Object)className)) != null) {
            ArrayList<XmlFile> result = new ArrayList<XmlFile>();
            for (String url : urls) {
                PsiFile psiFile;
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file == null || !((psiFile = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(file)) instanceof XmlFile)) continue;
                result.add((XmlFile)psiFile);
            }
            ArrayList<XmlFile> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getUiXmlFiles"));
            }
            return arrayList;
        }
        List<XmlFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getUiXmlFiles"));
        }
        return list;
    }
}

