/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.references;

import com.intellij.gwt.references.GwtToCssClassReferenceProvider;
import com.intellij.gwt.uiBinder.references.GwtUiFieldFromAttributeReference;
import com.intellij.gwt.uiBinder.references.GwtUiFieldFromHandlerReference;
import com.intellij.gwt.uiBinder.references.QualifiedUiXmlReferenceProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.patterns.XmlNamedElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class GwtUiReferenceContributor
extends PsiReferenceContributor {
    public static final ElementPattern<XmlAttribute> ATTRIBUTE_FROM_UI_NAMESPACE_PATTERN = StandardPatterns.or((ElementPattern[])new ElementPattern[]{XmlPatterns.xmlAttribute().withNamespace("urn:ui:com.google.gwt.uibinder"), XmlPatterns.xmlAttribute().withParent((ElementPattern)XmlPatterns.xmlTag().withNamespace("urn:ui:com.google.gwt.uibinder"))});

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute((String)"field").and(ATTRIBUTE_FROM_UI_NAMESPACE_PATTERN)).inFile((ElementPattern)XmlPatterns.xmlFile().withName((ElementPattern)StandardPatterns.string().endsWith(".ui.xml")))), (PsiReferenceProvider)new UiFieldReferenceProvider());
        TreeElementPattern uiHandlerAnnotationValuePattern = PsiJavaPatterns.psiNameValuePair().withName("value").withParent((ElementPattern)PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent((ElementPattern)PsiJavaPatterns.psiAnnotation().qName("com.google.gwt.uibinder.client.UiHandler")));
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{uiHandlerAnnotationValuePattern, PsiJavaPatterns.psiElement(PsiArrayInitializerMemberValue.class).withParent((ElementPattern)uiHandlerAnnotationValuePattern)})), (PsiReferenceProvider)new UiFieldReferenceProvider(), 100.0);
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withLocalName(new String[]{"addStyleNames", "styleName", "stylePrimaryName"})).inFile((ElementPattern)XmlPatterns.psiFile().withName((ElementPattern)StandardPatterns.string().endsWith(".ui.xml")))), (PsiReferenceProvider)new GwtToCssClassReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().inFile((ElementPattern)XmlPatterns.psiFile().withName((ElementPattern)StandardPatterns.string().endsWith(".ui.xml"))), (PsiReferenceProvider)new QualifiedUiXmlReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((ElementPattern)XmlPatterns.xmlAttribute((String)"src").withParent((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("style")).withNamespace("urn:ui:com.google.gwt.uibinder"))), (PsiReferenceProvider)new CssFileReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((ElementPattern)XmlPatterns.xmlAttribute((String)"type").and(ATTRIBUTE_FROM_UI_NAMESPACE_PATTERN)), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$1", "getReferencesByElement"));
                }
                JavaClassReferenceProvider provider = new JavaClassReferenceProvider(){

                    public GlobalSearchScope getScope(Project project) {
                        return element.getResolveScope();
                    }
                };
                provider.setOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES, (Object)Boolean.FALSE);
                PsiReference[] psiReferenceArray = provider.getReferencesByElement(element, context);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static class UiFieldReferenceProvider
    extends PsiReferenceProvider {
        private UiFieldReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiLiteralExpression literalExpression;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$UiFieldReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$UiFieldReferenceProvider", "getReferencesByElement"));
            }
            if (element instanceof XmlAttributeValue) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new GwtUiFieldFromAttributeReference((XmlAttributeValue)element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$UiFieldReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
            if (element instanceof PsiLiteralExpression && (literalExpression = (PsiLiteralExpression)element).getValue() instanceof String) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new GwtUiFieldFromHandlerReference(literalExpression)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$UiFieldReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$UiFieldReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
    }

    private static class CssFileReferenceProvider
    extends PsiReferenceProvider {
        public static final Condition<PsiFileSystemItem> CSS_FILE_CONDITION = new Condition<PsiFileSystemItem>(){

            public boolean value(PsiFileSystemItem psiFileSystemItem) {
                return psiFileSystemItem instanceof CssFile;
            }
        };

        private CssFileReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$CssFileReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$CssFileReferenceProvider", "getReferencesByElement"));
            }
            if (element instanceof XmlAttributeValue) {
                String path = ((XmlAttributeValue)element).getValue();
                FileType[] types = new FileType[]{CssFileType.INSTANCE};
                FileReferenceSet set = new FileReferenceSet(path, element, 1, null, SystemInfo.isFileSystemCaseSensitive, true, types){

                    public boolean couldBeConvertedTo(boolean relative) {
                        return relative;
                    }

                    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                        return CSS_FILE_CONDITION;
                    }
                };
                FileReference[] fileReferenceArray = set.getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$CssFileReferenceProvider", "getReferencesByElement"));
                }
                return fileReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/references/GwtUiReferenceContributor$CssFileReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
    }
}

