/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs2.FileSystem;

public final class FileSystemOptions
implements Cloneable {
    private final Map<FileSystemOptionKey, Object> options;

    public FileSystemOptions() {
        this(new TreeMap<FileSystemOptionKey, Object>());
    }

    protected FileSystemOptions(Map<FileSystemOptionKey, Object> options) {
        this.options = options;
    }

    void setOption(Class<? extends FileSystem> fileSystemClass, String name, Object value) {
        this.options.put(new FileSystemOptionKey(fileSystemClass, name), value);
    }

    Object getOption(Class<? extends FileSystem> fileSystemClass, String name) {
        FileSystemOptionKey key = new FileSystemOptionKey(fileSystemClass, name);
        return this.options.get(key);
    }

    boolean hasOption(Class<? extends FileSystem> fileSystemClass, String name) {
        FileSystemOptionKey key = new FileSystemOptionKey(fileSystemClass, name);
        return this.options.containsKey(key);
    }

    public int compareTo(FileSystemOptions other) {
        int propsFkSz;
        if (this == other) {
            return 0;
        }
        int propsSz = this.options == null ? 0 : this.options.size();
        int n = propsFkSz = other.options == null ? 0 : other.options.size();
        if (propsSz < propsFkSz) {
            return -1;
        }
        if (propsSz > propsFkSz) {
            return 1;
        }
        if (propsSz == 0) {
            return 0;
        }
        for (FileSystemOptionKey k : this.options.keySet()) {
            Object v = this.options.get(k);
            Object fkV = other.options.get(k);
            if (!(v == null ? fkV != null : !FileSystemOptions.equals(v, fkV))) continue;
            return ((Object)this.options).hashCode() < ((Object)other.options).hashCode() ? -1 : 1;
        }
        return 0;
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        return o1.equals(o2);
    }

    public Object clone() {
        return new FileSystemOptions(new TreeMap<FileSystemOptionKey, Object>(this.options));
    }

    public String toString() {
        return this.options.toString();
    }

    private static final class FileSystemOptionKey
    implements Comparable<FileSystemOptionKey> {
        private static final int HASH = 29;
        private final Class<? extends FileSystem> fileSystemClass;
        private final String name;

        private FileSystemOptionKey(Class<? extends FileSystem> fileSystemClass, String name) {
            this.fileSystemClass = fileSystemClass;
            this.name = name;
        }

        @Override
        public int compareTo(FileSystemOptionKey o) {
            int ret = this.fileSystemClass.getName().compareTo(o.fileSystemClass.getName());
            if (ret != 0) {
                return ret;
            }
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileSystemOptionKey that = (FileSystemOptionKey)o;
            if (!this.fileSystemClass.equals(that.fileSystemClass)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.fileSystemClass.hashCode();
            result = 29 * result + this.name.hashCode();
            return result;
        }
    }
}

