/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.facet.ui;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.facet.ui.StrutsFileSet;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.config.ConfigFilesTreeBuilder;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

public class StrutsFilesTree
extends CheckboxTreeBase {
    public StrutsFilesTree() {
        super(new CheckboxTreeBase.CheckboxTreeCellRendererBase(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                ConfigFilesTreeBuilder.renderNode((Object)value, (boolean)expanded, (ColoredTreeCellRenderer)this.getTextRenderer());
            }
        }, null);
        ConfigFilesTreeBuilder.installSearch((JTree)((Object)this));
    }

    public void updateFileSet(final StrutsFileSet fileSet) {
        final HashSet configured = new HashSet();
        TreeUtil.traverse((TreeNode)((TreeNode)this.getModel().getRoot()), (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                CheckedTreeNode checkedTreeNode = (CheckedTreeNode)node;
                if (!checkedTreeNode.isChecked()) {
                    return true;
                }
                Object object = checkedTreeNode.getUserObject();
                VirtualFile virtualFile = null;
                if (object instanceof XmlFile) {
                    virtualFile = ((XmlFile)object).getVirtualFile();
                } else if (object instanceof VirtualFile) {
                    virtualFile = (VirtualFile)object;
                }
                if (virtualFile != null) {
                    if (!fileSet.hasFile(virtualFile)) {
                        fileSet.addFile(virtualFile);
                    }
                    configured.add(virtualFile);
                }
                return true;
            }
        });
        Iterator<VirtualFilePointer> i = fileSet.getFiles().iterator();
        while (i.hasNext()) {
            VirtualFilePointer pointer = i.next();
            VirtualFile file = pointer.getFile();
            if (file != null && configured.contains(file)) continue;
            i.remove();
        }
    }
}

