/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.graph.fileEditor;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.graph.fileEditor.Struts2GraphComponent;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Struts2GraphFileEditor
extends PerspectiveFileEditor {
    private Struts2GraphComponent myComponent;
    private final XmlFile myXmlFile;

    public Struts2GraphFileEditor(Project project, VirtualFile file) {
        super(project, file);
        PsiFile psiFile = this.getPsiFile();
        assert (psiFile instanceof XmlFile);
        this.myXmlFile = (XmlFile)psiFile;
    }

    @Nullable
    protected DomElement getSelectedDomElement() {
        List<DomElement> selectedDomElements = this.getStruts2GraphComponent().getSelectedDomElements();
        return selectedDomElements.size() > 0 ? selectedDomElements.get(0) : null;
    }

    protected void setSelectedDomElement(DomElement domElement) {
        this.getStruts2GraphComponent().setSelectedDomElement(domElement);
    }

    @NotNull
    protected JComponent createCustomComponent() {
        Struts2GraphComponent struts2GraphComponent = this.getStruts2GraphComponent();
        if (struts2GraphComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/graph/fileEditor/Struts2GraphFileEditor", "createCustomComponent"));
        }
        return struts2GraphComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getStruts2GraphComponent().getBuilder().getView().getJComponent();
    }

    public void commit() {
    }

    public void reset() {
        this.getStruts2GraphComponent().getBuilder().queueUpdate();
    }

    @NotNull
    public String getName() {
        if ("Graph" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/graph/fileEditor/Struts2GraphFileEditor", "getName"));
        }
        return "Graph";
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return GraphViewUtil.createStructureViewBuilder((Overview)this.getStruts2GraphComponent().getOverview());
    }

    private Struts2GraphComponent getStruts2GraphComponent() {
        if (this.myComponent == null) {
            this.myComponent = this.createGraphComponent();
            Disposer.register((Disposable)this, (Disposable)this.myComponent);
        }
        return this.myComponent;
    }

    private Struts2GraphComponent createGraphComponent() {
        final Struts2GraphComponent[] graphComponent = new Struts2GraphComponent[]{null};
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                graphComponent[0] = (Struts2GraphComponent)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Struts2GraphComponent>(){

                    public Struts2GraphComponent compute() {
                        return new Struts2GraphComponent(Struts2GraphFileEditor.this.myXmlFile);
                    }
                });
            }
        }, "Generating Graph", false, this.myXmlFile.getProject());
        return graphComponent[0];
    }
}

