/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.Annotations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.annotate.VFSForAnnotationListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.Nullable;

public class CCaseFileAnnotation
extends FileAnnotation {
    private final StringBuffer myContentBuffer = new StringBuffer();
    private final List<LineInfo> myLineInfos = new ArrayList<LineInfo>();
    private final VirtualFile myFile;
    private VFSForAnnotationListener myListener;
    private final LineAnnotationAspect DATE_ASPECT = new CCAnnotationAspect(CCAnnotationAspect.DATE, true){

        public String getValue(int lineNumber) {
            if (CCaseFileAnnotation.this.myLineInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            return ((LineInfo)CCaseFileAnnotation.this.myLineInfos.get(lineNumber)).getDate();
        }
    };
    private final LineAnnotationAspect REVISION_ASPECT = new CCAnnotationAspect(CCAnnotationAspect.REVISION, false){

        public String getValue(int lineNumber) {
            if (CCaseFileAnnotation.this.myLineInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            return ((LineInfo)CCaseFileAnnotation.this.myLineInfos.get(lineNumber)).getRevision();
        }
    };
    private final LineAnnotationAspect AUTHOR_ASPECT = new CCAnnotationAspect(CCAnnotationAspect.AUTHOR, true){

        public String getValue(int lineNumber) {
            if (CCaseFileAnnotation.this.myLineInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            return ((LineInfo)CCaseFileAnnotation.this.myLineInfos.get(lineNumber)).getAuthor();
        }
    };

    public CCaseFileAnnotation(Project project, VirtualFile file) {
        super(project);
        this.myFile = file;
        this.myListener = new VFSForAnnotationListener(file, (FileAnnotation)this);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myListener);
    }

    public void dispose() {
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myListener);
    }

    public String getToolTip(int lineNumber) {
        if (this.myLineInfos.size() <= lineNumber || lineNumber < 0) {
            return "";
        }
        LineInfo info = this.myLineInfos.get(lineNumber);
        return info.getRevision();
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    public String getAnnotatedContent() {
        return this.myContentBuffer.toString();
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        return null;
    }

    public Date getLineDate(int lineNumber) {
        if (this.myLineInfos.size() <= lineNumber || lineNumber < 0) {
            return null;
        }
        LineInfo info = this.myLineInfos.get(lineNumber);
        return null;
    }

    public VcsRevisionNumber originalRevision(int lineNumber) {
        return null;
    }

    @Nullable
    public List<VcsFileRevision> getRevisions() {
        return null;
    }

    public boolean revisionsNotEmpty() {
        return false;
    }

    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        return null;
    }

    public int getLineCount() {
        return this.myLineInfos.size();
    }

    public void addLineInfo(String date, String revision, String author, String line) {
        this.myLineInfos.add(new LineInfo(date, revision, author));
        this.myContentBuffer.append(line);
        this.myContentBuffer.append("\n");
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return null;
    }

    public VcsKey getVcsKey() {
        return TransparentVcs.getKey();
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    private abstract class CCAnnotationAspect
    extends LineAnnotationAspectAdapter {
        protected CCAnnotationAspect() {
        }

        protected CCAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        protected void showAffectedPaths(int lineNum) {
        }
    }

    static class LineInfo {
        private final String date;
        private final String revisionSig;
        private final String author;

        public LineInfo(String date, String rev, String author) {
            this.date = date;
            this.revisionSig = rev;
            this.author = author;
        }

        public String getDate() {
            return this.date;
        }

        public String getRevision() {
            return this.revisionSig;
        }

        public String getAuthor() {
            return this.author;
        }
    }
}

