/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.ChangeManagement;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import net.sourceforge.transparent.History.CCaseHistoryParser;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCaseContentRevision
implements ContentRevision {
    @NonNls
    private static final String TMP_FILE_NAME = "idea_ccase";
    @NonNls
    private static final String VERSION_SEPARATOR = "@@";
    @NonNls
    private static final String WARNING_NO_GROUP_SIG = "Warning: Can not find a group named";
    private final VirtualFile file;
    private final FilePath revisionPath;
    @NotNull
    private final Project project;
    private String myServerContent;
    private final TransparentVcs host;
    private String myVersion;

    public CCaseContentRevision(FilePath path, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "net/sourceforge/transparent/ChangeManagement/CCaseContentRevision", "<init>"));
        }
        this(path, project, null);
    }

    public CCaseContentRevision(FilePath path, @NotNull Project project, String version) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "net/sourceforge/transparent/ChangeManagement/CCaseContentRevision", "<init>"));
        }
        this.revisionPath = path;
        this.project = project;
        this.host = TransparentVcs.getInstance(project);
        this.file = path.getVirtualFile();
        this.myVersion = version;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = VcsRevisionNumber.NULL;
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sourceforge/transparent/ChangeManagement/CCaseContentRevision", "getRevisionNumber"));
        }
        return vcsRevisionNumber;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.revisionPath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "net/sourceforge/transparent/ChangeManagement/CCaseContentRevision", "getFile"));
        }
        return filePath;
    }

    public String getContent() {
        if (this.myServerContent == null) {
            this.myServerContent = this.getServerContent();
        }
        return this.myServerContent;
    }

    private String getServerContent() {
        String TITLE = "Error";
        String EXT = ".tmp";
        String content = "";
        if (this.host.fileIsUnderVcs(this.revisionPath)) {
            if (this.host.getConfig().isOffline()) {
                if (this.file != null) {
                    try {
                        content = CharsetToolkit.bytesToString((byte[])this.file.contentsToByteArray(), (Charset)EncodingProjectManager.getInstance((Project)this.project).getDefaultCharset());
                    }
                    catch (IOException iOException) {}
                }
            } else {
                try {
                    File tmpFile = FileUtil.createTempFile((String)TMP_FILE_NAME, (String)".tmp");
                    tmpFile.deleteOnExit();
                    File tmpDir = tmpFile.getParentFile();
                    File myTmpFile = new File(tmpDir, Long.toString(new Date().getTime()));
                    FileStatusManager mgr = FileStatusManager.getInstance((Project)this.project);
                    if (this.myVersion == null) {
                        this.detectVersion(mgr);
                    }
                    if (this.myVersion != null) {
                        String path = VcsUtil.getCanonicalLocalPath((String)this.revisionPath.getPath());
                        final String out2 = TransparentVcs.cleartoolWithOutput("get", "-to", myTmpFile.getPath(), path + VERSION_SEPARATOR + this.myVersion);
                        if (out2.length() > 0 && !CCaseContentRevision.isKnownMessage(out2)) {
                            WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    VcsImplUtil.showErrorMessage((Project)CCaseContentRevision.this.project, (String)out2, (String)"Error");
                                }
                            }, null, (Project)this.project);
                        } else {
                            byte[] byteContent = VcsUtil.getFileByteContent((File)myTmpFile);
                            content = this.file == null ? CharsetToolkit.bytesToString((byte[])byteContent, (Charset)EncodingProjectManager.getInstance((Project)this.project).getDefaultCharset()) : CharsetToolkit.bytesToString((byte[])byteContent, (Charset)this.file.getCharset());
                            myTmpFile.delete();
                        }
                    }
                }
                catch (Exception e) {
                    VcsImplUtil.showErrorMessage((Project)this.project, (String)e.getMessage(), (String)"Error");
                }
            }
        }
        return content;
    }

    private void detectVersion(FileStatusManager mgr) {
        if (this.file == null) {
            String out = TransparentVcs.cleartoolWithOutput("describe", this.revisionPath.getPath());
            this.myVersion = CCaseContentRevision.parseLastRepositoryVersion(out);
        } else if (mgr.getStatus(this.file) == FileStatus.HIJACKED) {
            ArrayList<String> commandParts = new ArrayList<String>();
            commandParts.add("lshistory");
            CCaseHistoryParser.fillParametersVersionOnly(commandParts);
            commandParts.add(this.file.getPath() + VERSION_SEPARATOR);
            String log = TransparentVcs.cleartoolWithOutput(ArrayUtil.toStringArray(commandParts));
            ArrayList<CCaseHistoryParser.SubmissionData> changes = CCaseHistoryParser.parse(log);
            if (changes.size() > 0) {
                this.myVersion = changes.get((int)0).version;
                if (this.myVersion.startsWith(VERSION_SEPARATOR)) {
                    this.myVersion = this.myVersion.substring(2);
                }
            }
        } else {
            String out = TransparentVcs.cleartoolWithOutput("describe", this.file.getPath());
            this.myVersion = CCaseContentRevision.parseLastRepositoryVersion(out);
        }
    }

    private static boolean isKnownMessage(String message) {
        return message.contains(WARNING_NO_GROUP_SIG);
    }

    @Nullable
    private static String parseLastRepositoryVersion(String text) {
        String[] lines;
        String SIG = "predecessor version:";
        String version = null;
        for (String line : lines = text.split("\n")) {
            int index = line.indexOf("predecessor version:");
            if (index == -1) continue;
            version = line.substring(index + "predecessor version:".length()).trim();
            break;
        }
        return version;
    }
}

