/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.CheckedOutStatus;
import net.sourceforge.transparent.ClearCase;
import net.sourceforge.transparent.Runner;
import net.sourceforge.transparent.Status;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.exceptions.ClearCaseException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineClearCase
implements ClearCase {
    @NonNls
    private static final String VERSIONED_SIG = "@@";
    @NonNls
    private static final String HIJACKED_SIG = "[hijacked]";
    @NonNls
    private static final String CHECKEDOUT_SIG = "Rule: CHECKEDOUT";
    @NonNls
    private static final String CHECKEDOUT_REMOVED_SIG = "checkedout but removed";
    @NonNls
    private static final String ACTIVITY_SIG = "    activity:";
    @NonNls
    private static final String NOT_VOB_ELEMENT = "Pathname is not within";
    @NonNls
    private static final String UNABLE_TO_ACCESS = "Unable to access";
    @NonNls
    private static final String NO_SUCH_FILE_OR_DIR = "No such file or directory";
    @NonNls
    private static final String IDENTICAL_CONTENT_SIG = "version with data identical to";
    private TransparentVcs host;

    @Override
    public String getName() {
        return CommandLineClearCase.class.getName();
    }

    public void setHost(TransparentVcs host) {
        this.host = host;
    }

    @Override
    public void undoCheckOut(File file) {
        CommandLineClearCase.cleartool(new String[]{"unco", "-rm", file.getAbsolutePath()});
    }

    @Override
    public void checkIn(File file, String comment) {
        if (this.host.getConfig().useIdenticalSwitch) {
            if (StringUtil.isNotEmpty((String)comment)) {
                CommandLineClearCase.cleartool(new String[]{"ci", "-c", CommandLineClearCase.quote(comment), "-identical", file.getAbsolutePath()});
            } else {
                CommandLineClearCase.cleartool(new String[]{"ci", "-nc", "-identical", file.getAbsolutePath()});
            }
        } else {
            try {
                if (StringUtil.isNotEmpty((String)comment)) {
                    CommandLineClearCase.cleartool(new String[]{"ci", "-c", CommandLineClearCase.quote(comment), file.getAbsolutePath()});
                } else {
                    CommandLineClearCase.cleartool(new String[]{"ci", "-nc", file.getAbsolutePath()});
                }
            }
            catch (ClearCaseException e) {
                if (e.getMessage().indexOf(IDENTICAL_CONTENT_SIG) != -1) {
                    this.undoCheckOut(file);
                }
                throw e;
            }
        }
    }

    @Override
    public void checkOut(File file, boolean isReserved, String comment, boolean noData) {
        String activity;
        String canonName;
        try {
            canonName = file.getCanonicalPath();
        }
        catch (IOException e) {
            canonName = file.getAbsolutePath();
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add("co");
        if (StringUtil.isNotEmpty((String)comment)) {
            commandLine.add("-c");
            commandLine.add(CommandLineClearCase.quote(comment));
        } else {
            commandLine.add("-nc");
        }
        commandLine.add(isReserved ? "-reserved" : "-unreserved");
        if (noData) {
            commandLine.add("-ndata");
        }
        commandLine.add("-nq");
        commandLine.add(canonName);
        String[] params = commandLine.toArray(new String[commandLine.size()]);
        Runner runner = CommandLineClearCase.cleartool(params, true);
        if (!runner.isSuccessfull()) {
            boolean isCheckedOut = false;
            try {
                Status status = this.getStatus(file);
                isCheckedOut = Status.CHECKED_OUT.equals(status);
            }
            catch (ClearCaseException status) {
                // empty catch block
            }
            if (!isCheckedOut) {
                throw new ClearCaseException(runner.getOutput());
            }
        }
        if ((activity = CommandLineClearCase.extractActivity(runner.getOutput())) != null && !file.isDirectory()) {
            CCaseViewsManager viewsManager = CCaseViewsManager.getInstance(this.host.getProject());
            viewsManager.addFile2Changelist(file.getPath(), activity);
            viewsManager.checkChangedActivityForView(file.getPath(), activity);
        }
    }

    @Override
    public void delete(File file, String comment) {
        String canonName;
        try {
            canonName = file.getCanonicalPath();
        }
        catch (IOException e) {
            canonName = file.getAbsolutePath();
        }
        if (StringUtil.isNotEmpty((String)comment)) {
            CommandLineClearCase.cleartool(new String[]{"rmname", "-force", "-c", CommandLineClearCase.quote(comment), canonName});
        } else {
            CommandLineClearCase.cleartool(new String[]{"rmname", "-force", canonName});
        }
    }

    @Override
    public void add(File file, String comment) {
        if (file.isDirectory()) {
            CommandLineClearCase.doAddDir(file, comment);
        } else {
            CommandLineClearCase.doAdd("mkelem", file.getAbsolutePath(), comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAddDir(File dir, String comment) {
        String ext = Long.toString(new Date().getTime());
        String prefix = "Could not rename the content of " + dir.getPath();
        String error = prefix + " as part of adding it to ClearCase." + " Please add it manually";
        File tmpDir = new File(dir.getParentFile(), dir.getName() + "." + ext);
        try {
            FileUtil.rename((File)dir, (File)tmpDir);
            try {
                CommandLineClearCase.doAdd("mkdir", dir.getAbsolutePath(), comment);
                FileUtil.delete((File)dir);
            }
            finally {
                error = prefix + " back as part of adding it to Clearcase:\n" + "Its old content is in the " + tmpDir.getName() + ". Please rename it back manually.";
                FileUtil.moveDirWithContent((File)tmpDir, (File)dir);
            }
        }
        catch (IOException e) {
            throw new ClearCaseException(error);
        }
    }

    private static void doAdd(@NonNls String subcmd, String path, String comment) {
        if (StringUtil.isNotEmpty((String)comment)) {
            CommandLineClearCase.cleartool(new String[]{subcmd, "-c", CommandLineClearCase.quote(comment), path});
        } else {
            CommandLineClearCase.cleartool(new String[]{subcmd, "-nc", path});
        }
    }

    @Override
    public void move(File file, File target, String comment) {
        CommandLineClearCase.cleartool(new String[]{"mv", "-c", CommandLineClearCase.quote(comment), file.getAbsolutePath(), target.getAbsolutePath()});
    }

    @Override
    public boolean isElement(File file) {
        return this.getStatus(file) != Status.NOT_AN_ELEMENT;
    }

    @Override
    public boolean isCheckedOut(File file) {
        return this.getStatus(file) == Status.CHECKED_OUT;
    }

    @Override
    public Status getStatus(File file) {
        String fileName = VcsUtil.getCanonicalPath((File)file);
        Runner runner = CommandLineClearCase.cleartool(new String[]{"ls", "-directory", fileName}, true);
        String output = runner.getOutput();
        if (output == null) {
            output = "";
        }
        return this.parseLine(output, runner.isSuccessfull());
    }

    private Status parseLine(@NotNull String output, boolean wasSuccessful) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "net/sourceforge/transparent/CommandLineClearCase", "parseLine"));
        }
        if (output.indexOf(NOT_VOB_ELEMENT) != -1) {
            return Status.NOT_AN_ELEMENT;
        }
        if (output.indexOf(UNABLE_TO_ACCESS) != -1 && output.indexOf(NO_SUCH_FILE_OR_DIR) != -1) {
            return Status.NOT_AN_ELEMENT;
        }
        if (!wasSuccessful) {
            throw new ClearCaseException(output);
        }
        if (output.indexOf(VERSIONED_SIG) == -1) {
            return Status.NOT_AN_ELEMENT;
        }
        if (output.indexOf(HIJACKED_SIG) != -1) {
            return Status.HIJACKED;
        }
        if (output.indexOf(CHECKEDOUT_SIG) != -1 || output.indexOf(CHECKEDOUT_REMOVED_SIG) != -1) {
            return Status.CHECKED_OUT;
        }
        return Status.CHECKED_IN;
    }

    @Override
    public CheckedOutStatus getCheckedOutStatus(File file) {
        return TransparentVcs.getCheckedOutStatus(file);
    }

    @Override
    @Nullable
    public String getCheckoutComment(File file) {
        return TransparentVcs.getCheckoutComment(file);
    }

    public static String quote(String str) {
        String result = "\"" + str.replaceAll("\"", "\\\\\\\"") + "\"";
        return result;
    }

    @Override
    public void cleartool(@NonNls String subcmd) {
        CommandLineClearCase.cleartool(new String[]{"cleartool", subcmd});
    }

    public static void cleartool(@NonNls String[] subcmd) {
        CommandLineClearCase.cleartool(subcmd, false);
    }

    private static Runner cleartool(@NonNls String[] subcmd, boolean canFail) {
        String[] cmd = Runner.getCommand("cleartool", subcmd);
        Runner runner = new Runner();
        runner.run(cmd, canFail);
        return runner;
    }

    @Nullable
    private static String extractActivity(String out) {
        String[] lines;
        String activity = null;
        for (String line : lines = LineTokenizer.tokenize((CharSequence)out, (boolean)false)) {
            if (!line.startsWith(ACTIVITY_SIG)) continue;
            activity = line;
            int quoteIndex = line.indexOf(34);
            if (quoteIndex == -1) break;
            activity = line.substring(quoteIndex + 1, line.length() - 1);
            break;
        }
        return activity;
    }
}

