/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import javax.swing.Icon;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.CheckoutDialog;
import net.sourceforge.transparent.actions.SynchronousAction;
import net.sourceforge.transparent.exceptions.ClearCaseException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckOutAction
extends SynchronousAction {
    @NonNls
    private static final String ACTION_NAME = "Check Out";
    @NonNls
    private static final String CHECKOUT_HIJACKED_TITLE = "Check out Hijacked File";
    @NonNls
    private static final String NOT_A_VOB_OBJECT_SIG = "Not a vob object";
    @NonNls
    private static final String IS_ALREADY_CHECKED_OUT_SIG = "is already checked out";
    private int cnt;

    @Override
    protected String getActionName(AnActionEvent e) {
        TransparentVcs host = CheckOutAction.getHost(e);
        boolean verbose = host != null && host.getCheckoutOptions() != null && host.getCheckoutOptions().getValue();
        return verbose ? "Check Out..." : ACTION_NAME;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        TransparentVcs host = CheckOutAction.getHost(e);
        boolean isVisible = host != null && host.getConfig() != null;
        e.getPresentation().setVisible(isVisible);
        e.getPresentation().setEnabled(isVisible && !host.getConfig().isOffline() && e.getPresentation().isEnabled());
    }

    @Override
    protected boolean isEnabled(VirtualFile file, Project project) {
        if (!VcsUtil.isFileForVcs((VirtualFile)file, (Project)project, (AbstractVcs)TransparentVcs.getInstance(project))) {
            return false;
        }
        FileStatus status = CheckOutAction.getFileStatus(project, file);
        return status == FileStatus.NOT_CHANGED || status == FileStatus.HIJACKED;
    }

    @Override
    protected void execute(AnActionEvent e, final List<VcsException> errors) {
        this.cnt = 0;
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        String comment = "";
        final VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        if (TransparentVcs.getInstance(project).getCheckoutOptions().getValue()) {
            CheckoutDialog dialog = files.length == 1 ? new CheckoutDialog(project, files[0]) : new CheckoutDialog(project, files);
            dialog.show();
            if (dialog.getExitCode() == 1) {
                return;
            }
            comment = dialog.getComment();
        }
        if (files.length == 0) {
            return;
        }
        final ProgressManager pm = ProgressManager.getInstance();
        final String finalComment = comment;
        String title = "Checkout ";
        title = files.length > 1 ? title + "files" : title + (files[0].isDirectory() ? "directory" : "file");
        pm.runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator indicator = pm.getProgressIndicator();
                indicator.setIndeterminate(true);
                for (VirtualFile file : files) {
                    CheckOutAction.this.performOnFile(project, file, finalComment, errors, indicator);
                }
            }
        }, title, true, project);
    }

    private void performOnFile(Project project, VirtualFile file, String comment, List<VcsException> errors, ProgressIndicator indicator) {
        if (indicator != null) {
            indicator.checkCanceled();
            VirtualFile parent = file.getParent();
            indicator.setText("Processing: " + file.getName() + " (" + (parent == null ? file.getPath() : parent.getPath()) + ')');
            indicator.setText2("Processed: " + this.cnt + " files");
            ++this.cnt;
        }
        if (this.isEnabled(file, project)) {
            block6: {
                VcsDirtyScopeManager mgr = VcsDirtyScopeManager.getInstance((Project)project);
                try {
                    CheckOutAction.perform(file, comment, project);
                    mgr.fileDirty(file);
                }
                catch (VcsException ex) {
                    if (!CheckOutAction.isIgnorableMessage(ex.getMessage())) {
                        ex.setVirtualFile(file);
                        errors.add(ex);
                    }
                }
                catch (RuntimeException ex) {
                    if (CheckOutAction.isIgnorableMessage(ex.getMessage())) break block6;
                    VcsException vcsEx = new VcsException((Throwable)ex);
                    vcsEx.setVirtualFile(file);
                    errors.add(vcsEx);
                }
            }
            this.executeRecursively(project, file, comment, errors, indicator);
        }
    }

    private void executeRecursively(Project project, VirtualFile file, String comment, List<VcsException> errors, ProgressIndicator indicator) {
        if (file.isDirectory()) {
            for (VirtualFile child : file.getChildren()) {
                this.performOnFile(project, child, comment, errors, indicator);
            }
        }
    }

    protected static void perform(VirtualFile file, String comment, Project project) throws VcsException {
        FileStatus status;
        TransparentVcs vcs = TransparentVcs.getInstance(project);
        if (file.isDirectory()) {
            vcs.folderCheckedOut(file.getPath());
        }
        if ((status = CheckOutAction.getFileStatus(project, file)) == FileStatus.UNKNOWN || status == FileStatus.MODIFIED) {
            return;
        }
        boolean keepHijack = false;
        if (status == FileStatus.HIJACKED) {
            keepHijack = CheckOutAction.askIfUseHijackedFileAsCheckedOut(file);
        }
        try {
            vcs.checkoutFile(file, keepHijack, comment);
            file.putUserData(TransparentVcs.SUCCESSFUL_CHECKOUT, (Object)true);
            file.refresh(true, file.isDirectory());
        }
        catch (ClearCaseException exc) {
            VcsException vcsExc = new VcsException((Throwable)exc);
            AbstractVcsHelper.getInstance((Project)project).showError(vcsExc, ACTION_NAME);
        }
    }

    private static boolean askIfUseHijackedFileAsCheckedOut(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "net/sourceforge/transparent/actions/CheckOutAction", "askIfUseHijackedFileAsCheckedOut"));
        }
        final Ref answer = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                String message = "The file " + file.getPresentableUrl() + " has been hijacked. \n" + "Would you like to use it as the checked-out file?\nIf not it will be lost.";
                answer.set((Object)Messages.showYesNoDialog((String)message, (String)CheckOutAction.CHECKOUT_HIJACKED_TITLE, (Icon)Messages.getQuestionIcon()));
            }
        }, ModalityState.defaultModalityState());
        return (Integer)answer.get() == 0;
    }

    private static boolean isIgnorableMessage(String message) {
        return message.contains(NOT_A_VOB_OBJECT_SIG) || message.contains(IS_ALREADY_CHECKED_OUT_SIG);
    }

    @Override
    protected void perform(VirtualFile file, Project project) throws VcsException {
        throw new UnsupportedOperationException();
    }
}

