/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CheckoutDialog
extends OptionsDialog
implements Refreshable {
    @NonNls
    private static final String TITLE = "Checkout Comment";
    @NonNls
    private static final String FILES_SUFFIX = " files";
    private final String myLabel;
    private final JTextArea myCommentArea = new JTextArea();
    private final VcsConfiguration myConfiguration;
    protected Collection<Refreshable> myAdditionalComponents = new ArrayList<Refreshable>();

    public CheckoutDialog(Project project, VirtualFile fileToCheckout) {
        super(project);
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myLabel = fileToCheckout.getPresentableUrl();
        this.setTitle(TITLE);
        this.init();
    }

    public CheckoutDialog(Project project, VirtualFile[] filesToCheckout) {
        super(project);
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myLabel = filesToCheckout.length + FILES_SUFFIX;
        this.setTitle(TITLE);
        this.init();
    }

    protected boolean isToBeShown() {
        return TransparentVcs.getInstance(this.myProject).getCheckoutOptions().getValue();
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        TransparentVcs.getInstance(this.myProject).getCheckoutOptions().setValue(value);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel commentArea = new JPanel(new BorderLayout());
        commentArea.add((Component)new JLabel(this.myLabel), "North");
        commentArea.add((Component)ScrollPaneFactory.createScrollPane((Component)this.getCommentArea()), "Center");
        panel.add((Component)commentArea, "Center");
        return panel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myCommentArea;
    }

    public String getComment() {
        return this.myCommentArea.getText().trim();
    }

    protected void doOKAction() {
        int requestForCheckin;
        if (this.myConfiguration.FORCE_NON_EMPTY_COMMENT && this.getComment().length() == 0 && (requestForCheckin = Messages.showYesNoDialog((String)"Check out with empty comment?", (String)"Comment Is Empty", (Icon)Messages.getWarningIcon())) != 0) {
            return;
        }
        this.myConfiguration.LAST_COMMIT_MESSAGE = this.getComment();
        try {
            this.saveState();
            super.doOKAction();
        }
        catch (InputException ex) {
            ex.show();
        }
    }

    protected JTextArea getCommentArea() {
        this.initCommentArea();
        return this.myCommentArea;
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return false;
    }

    protected void initCommentArea() {
        this.myCommentArea.setRows(3);
        this.myCommentArea.setWrapStyleWord(true);
        this.myCommentArea.setLineWrap(true);
        this.myCommentArea.setSelectionStart(0);
        this.myCommentArea.setSelectionEnd(this.myCommentArea.getText().length());
    }

    public void refresh() {
        for (Refreshable component : this.myAdditionalComponents) {
            component.refresh();
        }
    }

    public void saveState() {
        for (Refreshable component : this.myAdditionalComponents) {
            component.saveState();
        }
    }

    public void restoreState() {
        for (Refreshable component : this.myAdditionalComponents) {
            component.restoreState();
        }
    }

    public void show() {
        this.refresh();
        super.show();
    }
}

