/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml;

import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.PsiClass;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.xml.BeanName;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.RequiredBeanType;
import com.intellij.spring.security.model.ModelVersion;
import com.intellij.spring.security.model.SpringSecurityVersion;
import com.intellij.spring.security.model.xml.SpringSecurityDomElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="HTTP Firewall")
@BeanType(provider=HttpFirewallBeanTypeProvider.class)
@BeanName(value="Http Firewall", displayOnly=true)
@ModelVersion(value=SpringSecurityVersion.SpringSecurity_2_0_6)
public interface HttpFirewall
extends SpringSecurityDomElement,
DomSpringBean {
    @Convert(value=SpringBeanResolveConverter.class)
    @RequiredBeanType(value={"org.springframework.security.firewall.HttpFirewall", "org.springframework.security.web.firewall.HttpFirewall"})
    @NotNull
    public GenericAttributeValue<SpringBeanPointer> getRef();

    public static class HttpFirewallBeanTypeProvider
    implements BeanTypeProvider<HttpFirewall> {
        @NotNull
        public String[] getBeanTypeCandidates() {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/model/xml/HttpFirewall$HttpFirewallBeanTypeProvider", "getBeanTypeCandidates"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        @Nullable
        public String getBeanType(HttpFirewall firewall) {
            if (!DomUtil.hasXml(firewall.getRef())) {
                return null;
            }
            SpringBeanPointer springBeanPointer = (SpringBeanPointer)firewall.getRef().getValue();
            if (springBeanPointer == null) {
                return null;
            }
            PsiClass beanClass = springBeanPointer.getBeanClass();
            return beanClass != null ? beanClass.getQualifiedName() : null;
        }
    }
}

