/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.oauth2.converters;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.spring.security.model.xml.oauth2.GrantType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class AuthorizedGrantTypesConverter
extends DelimitedListConverter<GrantType> {
    public AuthorizedGrantTypesConverter() {
        super(",");
    }

    protected GrantType convertString(@Nullable String string, ConvertContext context) {
        for (GrantType type : GrantType.values()) {
            if (!Comparing.strEqual((String)string, (String)type.getValue())) continue;
            return type;
        }
        return null;
    }

    protected String toString(@Nullable GrantType type) {
        return type != null ? type.getValue() : null;
    }

    protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<List<GrantType>> value) {
        return ContainerUtil.map2Array((Object[])GrantType.values(), (Function)new Function<GrantType, Object>(){

            public Object fun(GrantType type) {
                return type.getValue();
            }
        });
    }

    protected PsiElement resolveReference(@Nullable GrantType type, ConvertContext context) {
        return context.getReferenceXmlElement();
    }

    protected String getUnresolvedMessage(String value) {
        return PsiBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[]{value});
    }
}

