/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.references.StaticStringValuesReferenceProvider;
import com.intellij.spring.security.references.SpringSecurityExpressionRootMethodsReferenceProvider;
import com.intellij.spring.security.references.SpringSecurityRolePsiReferenceProvider;
import com.intellij.spring.security.references.SpringSecurityUrlReferenceProvider;
import com.intellij.spring.security.references.SpringSecurityUserPropertyReferenceProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityEEReferenceContributor
extends PsiReferenceContributor {
    private static final XmlAttributeValuePattern TAGLIB_ELEMENT_FILTER = (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().inVirtualFile(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.virtualFile().ofType((FileType)StdFileTypes.JSP), PlatformPatterns.virtualFile().ofType((FileType)StdFileTypes.JSPX)}))).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withNamespace("http://www.springframework.org/security/tags"));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/security/references/SpringSecurityEEReferenceContributor", "registerReferenceProviders"));
        }
        SpringSecurityEEReferenceContributor.registerJavaAnnotations(registrar);
        SpringSecurityEEReferenceContributor.registerTaglib(registrar);
    }

    private static void registerJavaAnnotations(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("javax.annotation.security.RolesAllowed"), (PsiReferenceProvider)new SpringSecurityRolePsiReferenceProvider.PsiLiteralExpressionProvider(false, true), 100.0);
    }

    private static void registerTaglib(PsiReferenceRegistrar registrar) {
        SpringSecurityRolePsiReferenceProvider.XmlAttributeValueProvider securityRoleProvider = new SpringSecurityRolePsiReferenceProvider.XmlAttributeValueProvider(true);
        SpringSecurityEEReferenceContributor.registerTags(securityRoleProvider, "ifAllGranted", registrar, "authorize");
        SpringSecurityEEReferenceContributor.registerTags(securityRoleProvider, "ifAnyGranted", registrar, "authorize");
        SpringSecurityEEReferenceContributor.registerTags(securityRoleProvider, "ifNotGranted", registrar, "authorize");
        SpringSecurityEEReferenceContributor.registerTags(new SpringSecurityExpressionRootMethodsReferenceProvider(), "access", registrar, "authorize");
        SpringSecurityEEReferenceContributor.registerTags(new SpringSecurityUrlReferenceProvider(), "url", registrar, "authorize");
        SpringSecurityEEReferenceContributor.registerTags((PsiReferenceProvider)new StaticStringValuesReferenceProvider(new String[]{"GET", "POST"}), "method", registrar, "authorize");
        SpringSecurityEEReferenceContributor.registerTags((PsiReferenceProvider)new StaticStringValuesReferenceProvider(false, new String[]{"true", "false"}), "htmlEscape", registrar, "authentication");
        SpringSecurityEEReferenceContributor.registerTags((PsiReferenceProvider)new StaticStringValuesReferenceProvider(false, new String[]{"request", "page", "session", "application"}), "scope", registrar, "authentication");
        SpringSecurityEEReferenceContributor.registerTags(new SpringSecurityUserPropertyReferenceProvider(), "property", registrar, "authentication");
    }

    private static void registerTags(PsiReferenceProvider provider, @NonNls String attributeName, PsiReferenceRegistrar registrar, String ... tagNames) {
        registrar.registerReferenceProvider(StandardPatterns.and((ElementPattern[])new ElementPattern[]{XmlPatterns.xmlAttributeValue().withLocalName(new String[]{attributeName}).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withLocalName(tagNames)), TAGLIB_ELEMENT_FILTER}), provider);
    }
}

