/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.security.model.SpringSecurityVersion;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityUtil {
    public static boolean isSpringSecurityUsed(DomFileElement<Beans> domFileElement) {
        return SpringSecurityUtil.isSpringSecurityNamespaceUsed(domFileElement) || SpringSecurityUtil.isFilterChainProxyDefined(domFileElement);
    }

    public static boolean isSpringSecurityNamespaceUsed(DomFileElement<Beans> domFileElement) {
        return SpringDomUtils.hasNamespace(domFileElement, (String)"Spring Security namespace key");
    }

    private static boolean isFilterChainProxyDefined(DomFileElement<Beans> domFileElement) {
        Module module = domFileElement.getModule();
        if (module == null) {
            return false;
        }
        PsiClass filterChainProxy = DomJavaUtil.findClass((String)"org.springframework.security.web.FilterChainProxy", domFileElement);
        if (filterChainProxy == null) {
            return false;
        }
        Set springModels = SpringManager.getInstance((Project)module.getProject()).getSpringModelsByFile((PsiFile)domFileElement.getFile());
        for (SpringModel model : springModels) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)model, (PsiClass)filterChainProxy)) continue;
            return true;
        }
        return false;
    }

    public static SpringSecurityVersion getVersion(@NotNull DomElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/util/SpringSecurityUtil", "getVersion"));
        }
        PsiClass encodingUtils = DomJavaUtil.findClass((String)"org.springframework.security.crypto.util.EncodingUtils", (DomElement)element);
        if (encodingUtils != null) {
            return SpringSecurityVersion.SpringSecurity_3_1;
        }
        PsiClass methodInvocationAdapter = DomJavaUtil.findClass((String)"org.springframework.security.access.intercept.aspectj.MethodInvocationAdapter", (DomElement)element);
        if (methodInvocationAdapter != null) {
            return SpringSecurityVersion.SpringSecurity_3_0_3;
        }
        PsiClass grantedAuthority30 = DomJavaUtil.findClass((String)"org.springframework.security.core.authority.GrantedAuthorityImpl", (DomElement)element);
        if (grantedAuthority30 != null) {
            return SpringSecurityVersion.SpringSecurity_3_0;
        }
        PsiClass namespaceAuthenticationManager = DomJavaUtil.findClass((String)"org.springframework.security.config.NamespaceAuthenticationManager", (DomElement)element);
        if (namespaceAuthenticationManager != null) {
            return SpringSecurityVersion.SpringSecurity_2_0_4;
        }
        return SpringSecurityVersion.SpringSecurity_2_0;
    }
}

