/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.html5;

import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafElementProcessor;
import com.intellij.thymeleaf.html5.ThymeleafXmlElementDescriptor;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafNamespaceDescriptorProvider
implements ImplicitNamespaceDescriptorProvider {
    @Nullable
    public XmlNSDescriptor getNamespaceDescriptor(@Nullable Module module, @NotNull String ns, @Nullable PsiFile file) {
        if (ns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ns", "com/intellij/thymeleaf/html5/ThymeleafNamespaceDescriptorProvider", "getNamespaceDescriptor"));
        }
        if (ThymeleafCommonUtil.isThymeleafNamespace(ns)) {
            return new ThymeleafNamespaceDescriptor();
        }
        return null;
    }

    private static class ThymeleafNamespaceDescriptor
    extends XmlNSDescriptorImpl {
        private ThymeleafNamespaceDescriptor() {
        }

        @NotNull
        public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument doc) {
            if (doc == null) {
                if (XmlElementDescriptor.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/html5/ThymeleafNamespaceDescriptorProvider$ThymeleafNamespaceDescriptor", "getRootElementsDescriptors"));
                }
                return XmlElementDescriptor.EMPTY_ARRAY;
            }
            Set<XmlElementDescriptor> descriptors = this.getAllDescriptors(doc.getRootTag());
            XmlElementDescriptor[] xmlElementDescriptorArray = descriptors.toArray(new XmlElementDescriptor[descriptors.size()]);
            if (xmlElementDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/html5/ThymeleafNamespaceDescriptorProvider$ThymeleafNamespaceDescriptor", "getRootElementsDescriptors"));
            }
            return xmlElementDescriptorArray;
        }

        @NotNull
        public Set<XmlElementDescriptor> getAllDescriptors(@Nullable XmlTag tag) {
            HashSet descriptors = new HashSet();
            if (tag != null) {
                final PsiFile containingFile = tag.getContainingFile();
                for (ThymeleafDialect dialect : (ThymeleafDialect[])Extensions.getExtensions(ThymeleafDialect.EP_NAME)) {
                    String prefix;
                    if (!dialect.isSupported(tag.getProject()) || (prefix = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(tag, dialect.getNamespaces())) == null) continue;
                    for (ThymeleafElementProcessor elementProcessor : dialect.getElementProcessors()) {
                        String name = elementProcessor.getName();
                        if (!StringUtil.isNotEmpty((String)name)) continue;
                        descriptors.add(new ThymeleafXmlElementDescriptor((XmlNSDescriptor)this, prefix, name){

                            @Override
                            public PsiElement getDeclaration() {
                                return containingFile;
                            }
                        });
                    }
                }
            }
            HashSet hashSet = descriptors;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/html5/ThymeleafNamespaceDescriptorProvider$ThymeleafNamespaceDescriptor", "getAllDescriptors"));
            }
            return hashSet;
        }

        public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/thymeleaf/html5/ThymeleafNamespaceDescriptorProvider$ThymeleafNamespaceDescriptor", "getElementDescriptor"));
            }
            String ns = tag.getNamespace();
            if (ThymeleafCommonUtil.isThymeleafNamespace(ns)) {
                Set<XmlElementDescriptor> descriptors = this.getAllDescriptors(tag);
                for (XmlElementDescriptor descriptor : descriptors) {
                    if (!tag.getName().equals(descriptor.getDefaultName())) continue;
                    return descriptor;
                }
            }
            return null;
        }
    }
}

