/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.thymeleaf.lang.ThymeleafPsiFile;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateFragmentName;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateName;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafTemplateNameReferenceImpl;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class ThymeleafCompletionContributor
extends CompletionContributor {
    public ThymeleafCompletionContributor() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("ThymeleafTemplateName"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                XmlAttribute contextAttribute;
                PsiElement contextElement;
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/thymeleaf/lang/support/ThymeleafCompletionContributor$1", "accepts"));
                }
                PsiFile containingFile = psiElement.getContainingFile();
                if (containingFile instanceof ThymeleafPsiFile && (contextElement = containingFile.getContext()) != null && (contextAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)contextElement, XmlAttribute.class)) != null) {
                    String localName = contextAttribute.getLocalName();
                    return "replace".equals(localName) || "include".equals(localName);
                }
                return false;
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                boolean isTemplateFragment;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/thymeleaf/lang/support/ThymeleafCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/thymeleaf/lang/support/ThymeleafCompletionContributor$2", "addCompletions"));
                }
                PsiElement originalPosition = parameters.getOriginalPosition();
                if ((originalPosition == null || originalPosition.getParent() instanceof ThymesTemplateName) && !(isTemplateFragment = parameters.getPosition().getParent() instanceof ThymesTemplateFragmentName)) {
                    PsiDirectory directory = ThymeleafTemplateNameReferenceImpl.getContextDirectory(parameters.getPosition().getContainingFile());
                    if (directory != null) {
                        for (PsiFile file : directory.getFiles()) {
                            if (file.getFileType() != HtmlFileType.INSTANCE) continue;
                            String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)file.getName());
                            result.addElement((LookupElement)LookupElementBuilder.create((String)nameWithoutExtension).withIcon(file.getIcon(0)).bold().withTypeText(file.getName(), true));
                        }
                    }
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"this").bold());
                }
            }
        });
    }
}

