/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.utils;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.constants.ThymeleafNamespaceConstants;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.lang.ThymeleafExpressionsFileType;
import com.intellij.thymeleaf.lang.injectors.ThymeleafExpressionsInjector;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafRenameableImplicitVariable;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.references.ThymeleafFakeRenameableReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafCommonUtil {
    private static AtomicNotNullLazyValue<String[]> THYMELEAF_URIS = new AtomicNotNullLazyValue<String[]>(){

        @NotNull
        protected String[] compute() {
            HashSet uris = ContainerUtil.newHashSet();
            for (ThymeleafDialect dialect : (ThymeleafDialect[])Extensions.getExtensions(ThymeleafDialect.EP_NAME)) {
                ContainerUtil.addAll((Collection)uris, (Object[])dialect.getNamespaces());
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)uris);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil$1", "compute"));
            }
            return stringArray;
        }
    };

    @Nullable
    public static ThymesElExpression findObjectExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findObjectExpression"));
        }
        return ThymeleafCommonUtil.findParentTagExpression(expression, "object");
    }

    @NotNull
    public static Collection<ThymesElExpression> findEachExpressions(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findEachExpressions"));
        }
        Collection<ThymesElExpression> collection = ThymeleafCommonUtil.findAllParentTagExpressions(expression, "each");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findEachExpressions"));
        }
        return collection;
    }

    @Nullable
    public static ThymesElExpression findFragmentExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findFragmentExpression"));
        }
        return ThymeleafCommonUtil.findParentTagExpression(expression, "fragment");
    }

    @NotNull
    public static Collection<ThymesElExpression> findWithExpressions(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findWithExpressions"));
        }
        Collection<ThymesElExpression> collection = ThymeleafCommonUtil.findAllParentTagExpressions(expression, "with");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findWithExpressions"));
        }
        return collection;
    }

    @Nullable
    private static ThymesElExpression findParentTagExpression(@NotNull PsiElement expression, @NotNull String attrName) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findParentTagExpression"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findParentTagExpression"));
        }
        CommonProcessors.FindFirstProcessor findFirst = new CommonProcessors.FindFirstProcessor();
        ThymeleafCommonUtil.processParentTagExpressions(expression, attrName, (Processor<ThymesElExpression>)findFirst);
        return (ThymesElExpression)findFirst.getFoundValue();
    }

    @NotNull
    private static Collection<ThymesElExpression> findAllParentTagExpressions(@NotNull PsiElement expression, @NotNull String attrName) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findAllParentTagExpressions"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findAllParentTagExpressions"));
        }
        CommonProcessors.CollectProcessor findFirst = new CommonProcessors.CollectProcessor();
        ThymeleafCommonUtil.processParentTagExpressions(expression, attrName, (Processor<ThymesElExpression>)findFirst);
        Collection collection = findFirst.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findAllParentTagExpressions"));
        }
        return collection;
    }

    private static boolean processParentTagExpressions(@NotNull PsiElement expression, @NotNull String attrName, @NotNull Processor<ThymesElExpression> processor) {
        XmlTag xmlTag;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "processParentTagExpressions"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "processParentTagExpressions"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "processParentTagExpressions"));
        }
        XmlAttribute contextAttribute = ThymeleafCommonUtil.getContextAttribute(expression);
        if (contextAttribute != null && (xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)contextAttribute, XmlTag.class)) != null) {
            XmlTag parentTag;
            XmlTag xmlTag2 = parentTag = attrName.equals(ThymeleafCommonUtil.getLocalName(contextAttribute)) ? xmlTag.getParentTag() : xmlTag;
            while (parentTag != null) {
                ThymesElExpression thymesElExpression;
                XmlAttribute attribute = ThymeleafCommonUtil.getAttribute(attrName, parentTag);
                if (attribute != null && (thymesElExpression = ThymeleafCommonUtil.getAttributeExpression(attribute)) != null && !processor.process((Object)thymesElExpression)) {
                    return false;
                }
                parentTag = parentTag.getParentTag();
            }
        }
        return true;
    }

    @Nullable
    public static XmlAttribute getContextAttribute(@NotNull PsiElement expression) {
        PsiElement context;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "getContextAttribute"));
        }
        PsiFile containingFile = expression.getContainingFile();
        if (containingFile != null && (context = containingFile.getContext()) != null) {
            return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
        }
        return null;
    }

    private static String getLocalName(@NotNull XmlAttribute contextAttribute) {
        if (contextAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextAttribute", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "getLocalName"));
        }
        String attrNameHtml5 = ThymeleafExpressionsInjector.getThymeleafAttrNameHtml5(contextAttribute);
        return attrNameHtml5 != null ? attrNameHtml5 : contextAttribute.getLocalName();
    }

    @Nullable
    private static XmlAttribute getAttribute(@NotNull String attrName, @NotNull XmlTag xmlTag) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "getAttribute"));
        }
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "getAttribute"));
        }
        XmlAttribute attribute = ThymeleafCommonUtil.findThymeleafAttribute(xmlTag, attrName);
        if (attribute != null) {
            return attribute;
        }
        String prefixByNamespace = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(xmlTag);
        if (prefixByNamespace != null) {
            return xmlTag.getAttribute("data-" + prefixByNamespace + "-" + attrName);
        }
        return null;
    }

    @Nullable
    public static ThymesElExpression getAttributeExpression(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "getAttributeExpression"));
        }
        final Ref ref = Ref.create();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)attribute.getProject());
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement != null) {
            manager.enumerate((PsiElement)valueElement, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil$2", "visit"));
                    }
                    if (places == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil$2", "visit"));
                    }
                    if (injectedPsi.getFileType() instanceof ThymeleafExpressionsFileType) {
                        PsiElement[] children;
                        for (PsiElement child : children = injectedPsi.getChildren()) {
                            if (!(child instanceof ThymesElExpression)) continue;
                            ref.set((Object)((ThymesElExpression)child));
                            break;
                        }
                    }
                }
            });
        }
        return (ThymesElExpression)ref.get();
    }

    public static Map<String, ThymeleafVariable> getInitVariables(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "getInitVariables"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "getInitVariables"));
        }
        final ConcurrentMap set = ContainerUtil.newConcurrentMap();
        MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                Pair evaluatedExpression;
                PsiExpression[] expressions;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
                if (methodCallExpression != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length == 2 && (evaluatedExpression = StringExpressionHelper.evaluateExpression((PsiElement)expressions[0])) != null) {
                    PsiElement psiExpression = (PsiElement)evaluatedExpression.getFirst();
                    String name = (String)evaluatedExpression.getSecond();
                    PsiType type = expressions[1].getType();
                    if (name != null && type != null) {
                        if (psiExpression instanceof PsiLiteral) {
                            RenameableFakePsiElement renamebaleElement = ThymeleafFakeRenameableReferenceProvider.getOrCreateRenamebaleFakeElement((PsiLiteral)psiExpression);
                            set.put(name, new ThymeleafRenameableImplicitVariable(name, type, renamebaleElement));
                        } else {
                            set.put(name, new ThymeleafVariable(name, type, psiExpression));
                        }
                    }
                }
                return true;
            }
        });
        return set;
    }

    @Nullable
    public static String getPrefixByThymeleafNamespace(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "getPrefixByThymeleafNamespace"));
        }
        for (String uri : (String[])THYMELEAF_URIS.getValue()) {
            String prefixByNamespace = tag.getPrefixByNamespace(uri);
            if (prefixByNamespace == null) continue;
            return prefixByNamespace;
        }
        return null;
    }

    @Nullable
    public static String getPrefixByThymeleafNamespace(@NotNull XmlTag tag, String ... uris) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "getPrefixByThymeleafNamespace"));
        }
        if (uris == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uris", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "getPrefixByThymeleafNamespace"));
        }
        for (String uri : uris) {
            String prefixByNamespace = tag.getPrefixByNamespace(uri);
            if (prefixByNamespace == null) continue;
            return prefixByNamespace;
        }
        return null;
    }

    public static boolean isThymeleafPrefix(XmlTag context, String prefixByQualifiedName) {
        return ThymeleafCommonUtil.isThymeleafNamespace(context.getNamespaceByPrefix(prefixByQualifiedName));
    }

    public static boolean isThymeleafNamespace(@NotNull String ns) {
        if (ns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ns", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "isThymeleafNamespace"));
        }
        for (String uri : (String[])THYMELEAF_URIS.getValue()) {
            if (!uri.equals(ns)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static XmlAttribute findThymeleafAttribute(@NotNull XmlTag tag, @NotNull String attrName) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findThymeleafAttribute"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findThymeleafAttribute"));
        }
        return ThymeleafCommonUtil.findThymeleafAttribute(tag, attrName, ThymeleafNamespaceConstants.THYMELEAF_URIS);
    }

    @Nullable
    public static XmlAttribute findThymeleafAttribute(@NotNull XmlTag tag, @NotNull String attrName, String ... uris) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findThymeleafAttribute"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil", "findThymeleafAttribute"));
        }
        for (String uri : uris) {
            XmlAttribute attribute = tag.getAttribute(attrName, uri);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }
}

